/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.writer;

import com.google.common.base.Preconditions;
import io.pravega.common.AbstractTimer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class WriterState {
    private final AtomicLong lastReadSequenceNumber = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong lastTruncatedSequenceNumber = new AtomicLong(Long.MIN_VALUE);
    private final AtomicBoolean lastIterationError = new AtomicBoolean(false);
    private final AtomicReference<Duration> currentIterationStartTime = new AtomicReference();
    private final AtomicLong iterationId = new AtomicLong();

    WriterState() {
    }

    void recordIterationStarted(AbstractTimer timer) {
        this.iterationId.incrementAndGet();
        this.currentIterationStartTime.set(timer.getElapsed());
        this.lastIterationError.set(false);
    }

    Duration getElapsedSinceIterationStart(AbstractTimer timer) {
        return timer.getElapsed().minus(this.currentIterationStartTime.get());
    }

    long getIterationId() {
        return this.iterationId.get();
    }

    boolean getLastIterationError() {
        return this.lastIterationError.get();
    }

    void recordIterationError() {
        this.lastIterationError.set(true);
    }

    long getLastTruncatedSequenceNumber() {
        return this.lastTruncatedSequenceNumber.get();
    }

    void setLastTruncatedSequenceNumber(long value) {
        Preconditions.checkArgument((value >= this.lastTruncatedSequenceNumber.get() ? 1 : 0) != 0, (Object)"New LastTruncatedSequenceNumber cannot be smaller than the previous one.");
        this.lastTruncatedSequenceNumber.set(value);
    }

    long getLastReadSequenceNumber() {
        return this.lastReadSequenceNumber.get();
    }

    void setLastReadSequenceNumber(long value) {
        Preconditions.checkArgument((value >= this.lastReadSequenceNumber.get() ? 1 : 0) != 0, (Object)"New LastReadSequenceNumber cannot be smaller than the previous one.");
        this.lastReadSequenceNumber.set(value);
    }

    public String toString() {
        return String.format("LastRead=%s, LastTruncate=%s, Error=%s", this.lastReadSequenceNumber, this.lastTruncatedSequenceNumber, this.lastIterationError);
    }
}

