/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.DataLogNotAvailableException;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.DurableDataLogFactory;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperLog;
import io.pravega.segmentstore.storage.impl.bookkeeper.DebugLogWrapper;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperLogFactory
implements DurableDataLogFactory {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(BookKeeperLogFactory.class);
    private final String namespace;
    private final CuratorFramework zkClient;
    private final AtomicReference<BookKeeper> bookKeeper;
    private final BookKeeperConfig config;
    private final ScheduledExecutorService executor;

    public BookKeeperLogFactory(BookKeeperConfig config, CuratorFramework zkClient, ScheduledExecutorService executor) {
        this.config = (BookKeeperConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.namespace = zkClient.getNamespace();
        this.zkClient = ((CuratorFramework)Preconditions.checkNotNull((Object)zkClient, (Object)"zkClient")).usingNamespace(this.namespace + this.config.getZkMetadataPath());
        this.bookKeeper = new AtomicReference();
    }

    public void close() {
        BookKeeper bk = this.bookKeeper.getAndSet(null);
        if (bk != null) {
            try {
                bk.close();
            }
            catch (Exception ex) {
                log.error("Unable to close BookKeeper client.", (Throwable)ex);
            }
        }
    }

    public void initialize() throws DurableDataLogException {
        Preconditions.checkState((this.bookKeeper.get() == null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is already initialized.");
        try {
            this.bookKeeper.set(this.startBookKeeperClient());
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            if (!Exceptions.mustRethrow((Throwable)ex)) {
                this.close();
            }
            throw new DataLogNotAvailableException("Unable to establish connection to ZooKeeper or BookKeeper.", ex);
        }
    }

    public DurableDataLog createDurableDataLog(int logId) {
        Preconditions.checkState((this.bookKeeper.get() != null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is not initialized.");
        return new BookKeeperLog(logId, this.zkClient, this.bookKeeper.get(), this.config, this.executor);
    }

    public DebugLogWrapper createDebugLogWrapper(int logId) {
        Preconditions.checkState((this.bookKeeper.get() != null ? 1 : 0) != 0, (Object)"BookKeeperLogFactory is not initialized.");
        return new DebugLogWrapper(logId, this.zkClient, this.bookKeeper.get(), this.config, this.executor);
    }

    @VisibleForTesting
    public BookKeeper getBookKeeperClient() {
        return this.bookKeeper.get();
    }

    private BookKeeper startBookKeeperClient() throws Exception {
        int writeTimeout = (int)Math.ceil((double)this.config.getBkWriteTimeoutMillis() / 1000.0);
        int readTimeout = (int)Math.ceil((double)this.config.getBkReadTimeoutMillis() / 1000.0);
        ClientConfiguration config = (ClientConfiguration)new ClientConfiguration().setClientTcpNoDelay(true).setAddEntryTimeout(writeTimeout).setReadEntryTimeout(readTimeout).setGetBookieInfoTimeout(readTimeout).setClientConnectTimeoutMillis((int)this.config.getZkConnectionTimeout().toMillis()).setZkTimeout((int)this.config.getZkConnectionTimeout().toMillis());
        if (this.config.isTLSEnabled()) {
            config = (ClientConfiguration)config.setTLSProvider("OpenSSL");
            config = config.setTLSTrustStore(this.config.getTlsTrustStore());
            config.setTLSTrustStorePasswordPath(this.config.getTlsTrustStorePasswordPath());
        }
        String metadataServiceUri = "zk://" + this.config.getZkAddress();
        metadataServiceUri = this.config.getBkLedgerPath().isEmpty() ? metadataServiceUri + "/" + this.namespace + "/bookkeeper/ledgers" : metadataServiceUri + this.config.getBkLedgerPath();
        config.setMetadataServiceUri(metadataServiceUri);
        return new BookKeeper(config);
    }
}

