/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;

class LedgerAddress
extends LogAddress
implements Comparable<LedgerAddress> {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private final long ledgerId;

    LedgerAddress(int ledgerSequence, long ledgerId, long entryId) {
        this(LedgerAddress.calculateAppendSequence(ledgerSequence, entryId), ledgerId);
    }

    LedgerAddress(LedgerMetadata metadata, long entryId) {
        this(LedgerAddress.calculateAppendSequence(metadata.getSequence(), entryId), metadata.getLedgerId());
    }

    LedgerAddress(long addressSequence, long ledgerId) {
        super(addressSequence);
        Preconditions.checkArgument((ledgerId >= 0L ? 1 : 0) != 0, (Object)"ledgerId must be a non-negative number.");
        this.ledgerId = ledgerId;
    }

    int getLedgerSequence() {
        return (int)(this.getSequence() >>> 32);
    }

    long getEntryId() {
        return this.getSequence() & 0xFFFFFFFFL;
    }

    public String toString() {
        return String.format("%s, LedgerId = %d, EntryId = %d", super.toString(), this.ledgerId, this.getEntryId());
    }

    private static long calculateAppendSequence(int ledgerSequence, long entryId) {
        return ((long)ledgerSequence << 32) + (entryId & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return Long.hashCode(this.getSequence());
    }

    public boolean equals(Object obj) {
        if (obj instanceof LedgerAddress) {
            return this.compareTo((LedgerAddress)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(LedgerAddress address) {
        return Long.compare(this.getSequence(), address.getSequence());
    }

    @SuppressFBWarnings(justification="generated code")
    public long getLedgerId() {
        return this.ledgerId;
    }
}

