/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.DataLogNotAvailableException;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Ledgers {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(Ledgers.class);
    static final long NO_ENTRY_ID = -1L;
    static final int MIN_FENCE_LEDGER_COUNT = 2;
    private static final BookKeeper.DigestType LEDGER_DIGEST_TYPE = BookKeeper.DigestType.MAC;

    Ledgers() {
    }

    static LedgerHandle create(BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        try {
            return (LedgerHandle)Exceptions.handleInterruptedCall(() -> bookKeeper.createLedger(config.getBkEnsembleSize(), config.getBkWriteQuorumSize(), config.getBkAckQuorumSize(), LEDGER_DIGEST_TYPE, config.getBKPassword()));
        }
        catch (BKException.BKNotEnoughBookiesException bkEx) {
            throw new DataLogNotAvailableException("Unable to create new BookKeeper Ledger.", (Throwable)bkEx);
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException("Unable to create new BookKeeper Ledger.", (Throwable)bkEx);
        }
    }

    static LedgerHandle openFence(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        try {
            return (LedgerHandle)Exceptions.handleInterruptedCall(() -> bookKeeper.openLedger(ledgerId, LEDGER_DIGEST_TYPE, config.getBKPassword()));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to open-fence ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    static LedgerHandle openRead(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        try {
            return (LedgerHandle)Exceptions.handleInterruptedCall(() -> bookKeeper.openLedgerNoRecovery(ledgerId, LEDGER_DIGEST_TYPE, config.getBKPassword()));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to open-read ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLastAddConfirmed(long ledgerId, BookKeeper bookKeeper, BookKeeperConfig config) throws DurableDataLogException {
        LedgerHandle h = null;
        try {
            h = Ledgers.openFence(ledgerId, bookKeeper, config);
            long l = h.getLastAddConfirmed();
            return l;
        }
        finally {
            if (h != null) {
                Ledgers.close(h);
            }
        }
    }

    static void close(LedgerHandle handle) throws DurableDataLogException {
        try {
            Exceptions.handleInterrupted(() -> ((LedgerHandle)handle).close());
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to close ledger %d.", handle.getId()), (Throwable)bkEx);
        }
    }

    static void delete(long ledgerId, BookKeeper bookKeeper) throws DurableDataLogException {
        try {
            Exceptions.handleInterrupted(() -> bookKeeper.deleteLedger(ledgerId));
        }
        catch (BKException bkEx) {
            throw new DurableDataLogException(String.format("Unable to delete Ledger %d.", ledgerId), (Throwable)bkEx);
        }
    }

    static Map<Long, Long> fenceOut(List<LedgerMetadata> ledgers, BookKeeper bookKeeper, BookKeeperConfig config, String traceObjectId) throws DurableDataLogException {
        int nonEmptyCount = 0;
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        ListIterator<LedgerMetadata> iterator = ledgers.listIterator(ledgers.size());
        while (iterator.hasPrevious() && nonEmptyCount < 2) {
            LedgerMetadata ledgerMetadata = iterator.previous();
            LedgerHandle handle = Ledgers.openFence(ledgerMetadata.getLedgerId(), bookKeeper, config);
            if (handle.getLastAddConfirmed() != -1L) {
                ++nonEmptyCount;
            }
            if (ledgerMetadata.getStatus() == LedgerMetadata.Status.Unknown) {
                result.put(ledgerMetadata.getLedgerId(), handle.getLastAddConfirmed());
            }
            Ledgers.close(handle);
            log.info("{}: Fenced out Ledger {}.", (Object)traceObjectId, (Object)ledgerMetadata);
        }
        return result;
    }
}

