/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.CollectionHelpers;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerAddress;
import io.pravega.segmentstore.storage.impl.bookkeeper.LedgerMetadata;
import io.pravega.segmentstore.storage.impl.bookkeeper.ReadOnlyLogMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class LogMetadata
implements ReadOnlyLogMetadata {
    static final VersionedSerializer.WithBuilder<LogMetadata, LogMetadataBuilder> SERIALIZER = new Serializer();
    private static final long INITIAL_EPOCH = 1L;
    private static final int INITIAL_VERSION = -1;
    private static final int INITIAL_LEDGER_SEQUENCE = 1;
    private static final LedgerAddress INITIAL_TRUNCATION_ADDRESS = new LedgerAddress(0, 0L, 0L);
    private final long epoch;
    private final boolean enabled;
    private final List<LedgerMetadata> ledgers;
    private final LedgerAddress truncationAddress;
    private final AtomicInteger updateVersion;

    LogMetadata(long initialLedgerId) {
        this(1L, true, Collections.singletonList(new LedgerMetadata(initialLedgerId, 1)), INITIAL_TRUNCATION_ADDRESS, -1);
    }

    private LogMetadata(long epoch, boolean enabled, List<LedgerMetadata> ledgers, LedgerAddress truncationAddress, int updateVersion) {
        Preconditions.checkArgument((epoch > 0L ? 1 : 0) != 0, (Object)"epoch must be a positive number");
        this.epoch = epoch;
        this.enabled = enabled;
        this.ledgers = (List)Preconditions.checkNotNull(ledgers, (Object)"ledgers");
        this.truncationAddress = (LedgerAddress)Preconditions.checkNotNull((Object)truncationAddress, (Object)"truncationAddress");
        this.updateVersion = new AtomicInteger(updateVersion);
    }

    LogMetadata addLedger(long ledgerId) {
        Preconditions.checkState((boolean)this.enabled, (Object)"Log is not enabled. Cannot perform any modifications on it.");
        ArrayList<LedgerMetadata> newLedgers = new ArrayList<LedgerMetadata>(this.ledgers.size() + 1);
        newLedgers.addAll(this.ledgers);
        int sequence = this.ledgers.size() == 0 ? 1 : this.ledgers.get(this.ledgers.size() - 1).getSequence() + 1;
        newLedgers.add(new LedgerMetadata(ledgerId, sequence));
        return new LogMetadata(this.epoch + 1L, this.enabled, Collections.unmodifiableList(newLedgers), this.truncationAddress, this.updateVersion.get());
    }

    LogMetadata truncate(LedgerAddress upToAddress) {
        Preconditions.checkState((boolean)this.enabled, (Object)"Log is not enabled. Cannot perform any modifications on it.");
        List newLedgers = this.ledgers.stream().filter(lm -> lm.getLedgerId() >= upToAddress.getLedgerId()).collect(Collectors.toList());
        return new LogMetadata(this.epoch, this.enabled, Collections.unmodifiableList(newLedgers), upToAddress, this.updateVersion.get());
    }

    LogMetadata removeEmptyLedgers(int skipCountFromEnd) {
        int i;
        ArrayList<LedgerMetadata> newLedgers = new ArrayList<LedgerMetadata>();
        int cutoffIndex = this.ledgers.size() - skipCountFromEnd;
        for (i = 0; i < cutoffIndex; ++i) {
            LedgerMetadata lm = this.ledgers.get(i);
            if (lm.getStatus() == LedgerMetadata.Status.Empty) continue;
            newLedgers.add(lm);
        }
        for (i = cutoffIndex; i < this.ledgers.size(); ++i) {
            newLedgers.add(this.ledgers.get(i));
        }
        return new LogMetadata(this.epoch, this.enabled, Collections.unmodifiableList(newLedgers), this.truncationAddress, this.updateVersion.get());
    }

    LogMetadata updateLedgerStatus(Map<Long, Long> lastAddConfirmed) {
        if (lastAddConfirmed.isEmpty()) {
            return this;
        }
        List newLedgers = this.ledgers.stream().map(lm -> {
            long lac = lastAddConfirmed.getOrDefault(lm.getLedgerId(), Long.MIN_VALUE);
            if (lm.getStatus() == LedgerMetadata.Status.Unknown && lac != Long.MIN_VALUE) {
                LedgerMetadata.Status e = lac == -1L ? LedgerMetadata.Status.Empty : LedgerMetadata.Status.NotEmpty;
                lm = new LedgerMetadata(lm.getLedgerId(), lm.getSequence(), e);
            }
            return lm;
        }).collect(Collectors.toList());
        return new LogMetadata(this.epoch, this.enabled, Collections.unmodifiableList(newLedgers), this.truncationAddress, this.updateVersion.get());
    }

    @Override
    public int getUpdateVersion() {
        return this.updateVersion.get();
    }

    LogMetadata withUpdateVersion(int value) {
        Preconditions.checkArgument((value >= this.updateVersion.get() ? 1 : 0) != 0, (Object)"versions must increase");
        this.updateVersion.set(value);
        return this;
    }

    LogMetadata asEnabled() {
        return this.enabled ? this : new LogMetadata(this.epoch, true, this.ledgers, this.truncationAddress, this.updateVersion.get());
    }

    LogMetadata asDisabled() {
        return this.enabled ? new LogMetadata(this.epoch, false, this.ledgers, this.truncationAddress, this.updateVersion.get()) : this;
    }

    LedgerMetadata getLedger(long ledgerId) {
        int index = this.getLedgerMetadataIndex(ledgerId);
        if (index >= 0) {
            return this.ledgers.get(index);
        }
        return null;
    }

    LedgerAddress getNextAddress(LedgerAddress address, long lastEntryId) {
        LedgerAddress result;
        block5: {
            LedgerMetadata ledgerMetadata;
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (this.ledgers.size() == 0) {
                                return null;
                            }
                            result = null;
                            LedgerMetadata firstLedger = this.ledgers.get(0);
                            if (address.getLedgerSequence() >= firstLedger.getSequence()) break block4;
                            result = new LedgerAddress(firstLedger, 0L);
                            break block5;
                        }
                        if (address.getEntryId() >= lastEntryId) break block6;
                        result = new LedgerAddress(address.getLedgerSequence(), address.getLedgerId(), address.getEntryId() + 1L);
                        break block5;
                    }
                    ledgerMetadata = null;
                    int index = this.getLedgerMetadataIndex(address.getLedgerId()) + 1;
                    if (index <= 0) break block7;
                    if (index >= this.ledgers.size()) break block8;
                    ledgerMetadata = this.ledgers.get(index);
                    break block8;
                }
                for (LedgerMetadata lm : this.ledgers) {
                    if (lm.getLedgerId() <= address.getLedgerId()) continue;
                    ledgerMetadata = lm;
                    break;
                }
            }
            if (ledgerMetadata != null) {
                result = new LedgerAddress(ledgerMetadata, 0L);
            }
        }
        if (result != null && result.compareTo(this.truncationAddress) < 0) {
            result = this.truncationAddress;
        }
        return result;
    }

    private int getLedgerMetadataIndex(long ledgerId) {
        return CollectionHelpers.binarySearch(this.ledgers, lm -> Long.compare(ledgerId, lm.getLedgerId()));
    }

    public String toString() {
        return String.format("Version = %d, Epoch = %d, LedgerCount = %d, Truncate = (%d-%d)", this.updateVersion.get(), this.epoch, this.ledgers.size(), this.truncationAddress.getLedgerId(), this.truncationAddress.getEntryId());
    }

    @SuppressFBWarnings(justification="generated code")
    public static LogMetadataBuilder builder() {
        return new LogMetadataBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getEpoch() {
        return this.epoch;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public List<LedgerMetadata> getLedgers() {
        return this.ledgers;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public LedgerAddress getTruncationAddress() {
        return this.truncationAddress;
    }

    private static class Serializer
    extends VersionedSerializer.WithBuilder<LogMetadata, LogMetadataBuilder> {
        private Serializer() {
        }

        protected LogMetadataBuilder newBuilder() {
            return LogMetadata.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(LogMetadata m, RevisionDataOutput output) throws IOException {
            output.writeBoolean(m.isEnabled());
            output.writeCompactLong(m.getEpoch());
            output.writeCompactLong(m.truncationAddress.getSequence());
            output.writeCompactLong(m.truncationAddress.getLedgerId());
            output.writeCollection((Collection)m.ledgers, this::writeLedger00);
        }

        private void read00(RevisionDataInput input, LogMetadataBuilder builder) throws IOException {
            builder.enabled(input.readBoolean());
            builder.epoch(input.readCompactLong());
            builder.truncationAddress(new LedgerAddress(input.readCompactLong(), input.readCompactLong()));
            List ledgers = (List)input.readCollection(this::readLedger00, ArrayList::new);
            builder.ledgers(Collections.unmodifiableList(ledgers));
            builder.updateVersion(-1);
        }

        private void writeLedger00(RevisionDataOutput output, LedgerMetadata m) throws IOException {
            output.writeCompactLong(m.getLedgerId());
            output.writeCompactInt(m.getSequence());
            output.writeByte((int)m.getStatus().getValue());
        }

        private LedgerMetadata readLedger00(RevisionDataInput input) throws IOException {
            long ledgerId = input.readCompactLong();
            int seq = input.readCompactInt();
            LedgerMetadata.Status empty = LedgerMetadata.Status.valueOf(input.readByte());
            return new LedgerMetadata(ledgerId, seq, empty);
        }
    }

    static class LogMetadataBuilder
    implements ObjectBuilder<LogMetadata> {
        @SuppressFBWarnings(justification="generated code")
        private long epoch;
        @SuppressFBWarnings(justification="generated code")
        private boolean enabled;
        @SuppressFBWarnings(justification="generated code")
        private List<LedgerMetadata> ledgers;
        @SuppressFBWarnings(justification="generated code")
        private LedgerAddress truncationAddress;
        @SuppressFBWarnings(justification="generated code")
        private int updateVersion;

        @SuppressFBWarnings(justification="generated code")
        LogMetadataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadataBuilder epoch(long epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadataBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadataBuilder ledgers(List<LedgerMetadata> ledgers) {
            this.ledgers = ledgers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadataBuilder truncationAddress(LedgerAddress truncationAddress) {
            this.truncationAddress = truncationAddress;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadataBuilder updateVersion(int updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LogMetadata build() {
            return new LogMetadata(this.epoch, this.enabled, this.ledgers, this.truncationAddress, this.updateVersion);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "LogMetadata.LogMetadataBuilder(epoch=" + this.epoch + ", enabled=" + this.enabled + ", ledgers=" + this.ledgers + ", truncationAddress=" + this.truncationAddress + ", updateVersion=" + this.updateVersion + ")";
        }
    }
}

