/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.impl.bookkeeper;

import com.google.common.base.Preconditions;
import io.pravega.common.Exceptions;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.Retry;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

class SequentialAsyncProcessor
implements AutoCloseable {
    private final Runnable runnable;
    private final Retry.RetryAndThrowBase<? extends Throwable> retry;
    private final Consumer<Throwable> failureCallback;
    private final ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private boolean runAgain;
    @GuardedBy(value="this")
    private boolean closed;

    SequentialAsyncProcessor(Runnable runnable, Retry.RetryAndThrowBase<? extends Throwable> retry, Consumer<Throwable> failureCallback, ScheduledExecutorService executor) {
        this.runnable = (Runnable)Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        this.retry = (Retry.RetryAndThrowBase)Preconditions.checkNotNull(retry, (Object)"retry");
        this.failureCallback = (Consumer)Preconditions.checkNotNull(failureCallback, (Object)"failureCallback");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsync() {
        SequentialAsyncProcessor sequentialAsyncProcessor = this;
        synchronized (sequentialAsyncProcessor) {
            Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
            if (this.running) {
                this.runAgain = true;
                return;
            }
            this.running = true;
        }
        this.runInternal();
    }

    private void runInternal() {
        this.retry.runInExecutor(this.runnable, this.executor).whenComplete((r, ex) -> {
            boolean loopAgain;
            if (ex != null) {
                Callbacks.invokeSafely(this.failureCallback, (Object)ex, null);
            }
            SequentialAsyncProcessor sequentialAsyncProcessor = this;
            synchronized (sequentialAsyncProcessor) {
                this.running = this.runAgain && !this.closed;
                this.runAgain = false;
                loopAgain = this.running;
            }
            if (loopAgain) {
                this.runInternal();
            }
        });
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }
}

