/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import io.pravega.common.util.ArrayView;
import io.pravega.common.util.CloseableIterator;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.LogAddress;
import io.pravega.segmentstore.storage.QueueStats;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public interface DurableDataLog
extends AutoCloseable {
    public void initialize(Duration var1) throws DurableDataLogException;

    public void enable() throws DurableDataLogException;

    public void disable() throws DurableDataLogException;

    public CompletableFuture<LogAddress> append(ArrayView var1, Duration var2);

    public CompletableFuture<Void> truncate(LogAddress var1, Duration var2);

    public CloseableIterator<ReadItem, DurableDataLogException> getReader() throws DurableDataLogException;

    public int getMaxAppendLength();

    public long getEpoch();

    public QueueStats getQueueStatistics();

    @Override
    public void close();

    public static interface ReadItem {
        public InputStream getPayload();

        public int getLength();

        public LogAddress getAddress();
    }
}

