/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;

public class QueueStats {
    public static final QueueStats DEFAULT = new QueueStats(0, 0.0, 0);
    private final int size;
    private final double averageItemFillRatio;
    private final int expectedProcessingTimeMillis;

    public String toString() {
        return String.format("Size = %d, Fill = %.2f, ProcTime = %dms", this.size, this.averageItemFillRatio, this.expectedProcessingTimeMillis);
    }

    @ConstructorProperties(value={"size", "averageItemFillRatio", "expectedProcessingTimeMillis"})
    @SuppressFBWarnings(justification="generated code")
    public QueueStats(int size, double averageItemFillRatio, int expectedProcessingTimeMillis) {
        this.size = size;
        this.averageItemFillRatio = averageItemFillRatio;
        this.expectedProcessingTimeMillis = expectedProcessingTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSize() {
        return this.size;
    }

    @SuppressFBWarnings(justification="generated code")
    public double getAverageItemFillRatio() {
        return this.averageItemFillRatio;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getExpectedProcessingTimeMillis() {
        return this.expectedProcessingTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueueStats)) {
            return false;
        }
        QueueStats other = (QueueStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (Double.compare(this.getAverageItemFillRatio(), other.getAverageItemFillRatio()) != 0) {
            return false;
        }
        return this.getExpectedProcessingTimeMillis() == other.getExpectedProcessingTimeMillis();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof QueueStats;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        long $averageItemFillRatio = Double.doubleToLongBits(this.getAverageItemFillRatio());
        result = result * 59 + (int)($averageItemFillRatio >>> 32 ^ $averageItemFillRatio);
        result = result * 59 + this.getExpectedProcessingTimeMillis();
        return result;
    }
}

