/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import io.pravega.common.Exceptions;
import io.pravega.common.function.Callbacks;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.storage.Cache;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryCache
implements Cache {
    private final Map<Cache.Key, byte[]> map;
    private final String id;
    private final Consumer<String> closeCallback;
    private final AtomicBoolean closed;

    public InMemoryCache(String id) {
        this(id, null);
    }

    InMemoryCache(String id, Consumer<String> closeCallback) {
        this.id = id;
        this.map = new ConcurrentHashMap<Cache.Key, byte[]>();
        this.closeCallback = closeCallback;
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.map.clear();
            Consumer<String> callback = this.closeCallback;
            if (callback != null) {
                Callbacks.invokeSafely(callback, (Object)this.id, null);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void insert(Cache.Key key, byte[] payload) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.map.put(key, payload);
    }

    @Override
    public void insert(Cache.Key key, BufferView data) {
        this.insert(key, data.getCopy());
    }

    @Override
    public byte[] get(Cache.Key key) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        byte[] data = this.map.get(key);
        return data == null ? null : Arrays.copyOf(data, data.length);
    }

    @Override
    public void remove(Cache.Key key) {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.map.remove(key);
    }

    public void clear() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        this.map.clear();
    }
}

