/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.mocks;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.DurableDataLog;
import io.pravega.segmentstore.storage.DurableDataLogException;
import io.pravega.segmentstore.storage.DurableDataLogFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryDurableDataLog;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class InMemoryDurableDataLogFactory
implements DurableDataLogFactory {
    private final HashMap<Integer, InMemoryDurableDataLog.EntryCollection> persistedData = new HashMap();
    private final int maxAppendSize;
    private final ScheduledExecutorService executorService;
    private Supplier<Duration> appendDelayProvider = InMemoryDurableDataLog.DEFAULT_APPEND_DELAY_PROVIDER;
    private boolean closed;

    public InMemoryDurableDataLogFactory(ScheduledExecutorService executorService) {
        this(-1, executorService);
    }

    public InMemoryDurableDataLogFactory(int maxAppendSize, ScheduledExecutorService executorService) {
        Preconditions.checkNotNull((Object)executorService, (Object)"executorService");
        this.maxAppendSize = maxAppendSize;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DurableDataLog createDurableDataLog(int containerId) {
        InMemoryDurableDataLog.EntryCollection entries;
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        HashMap<Integer, InMemoryDurableDataLog.EntryCollection> hashMap = this.persistedData;
        synchronized (hashMap) {
            entries = this.persistedData.getOrDefault(containerId, null);
            if (entries == null) {
                entries = this.maxAppendSize < 0 ? new InMemoryDurableDataLog.EntryCollection() : new InMemoryDurableDataLog.EntryCollection(this.maxAppendSize);
                this.persistedData.put(containerId, entries);
            }
        }
        return new InMemoryDurableDataLog(entries, this.appendDelayProvider, this.executorService);
    }

    @Override
    public void initialize() throws DurableDataLogException {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setAppendDelayProvider(Supplier<Duration> appendDelayProvider) {
        this.appendDelayProvider = appendDelayProvider;
    }
}

