/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.rolling;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.SegmentHandle;
import io.pravega.segmentstore.storage.SegmentRollingPolicy;
import io.pravega.segmentstore.storage.rolling.SegmentChunk;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class RollingSegmentHandle
implements SegmentHandle {
    private final String segmentName;
    private final boolean readOnly;
    @GuardedBy(value="this")
    private SegmentHandle headerHandle;
    private final SegmentRollingPolicy rollingPolicy;
    @GuardedBy(value="this")
    private int headerLength;
    @GuardedBy(value="this")
    private List<SegmentChunk> segmentChunks;
    @GuardedBy(value="this")
    private boolean sealed;
    @GuardedBy(value="this")
    private boolean deleted;
    @GuardedBy(value="this")
    private SegmentHandle activeChunkHandle;

    RollingSegmentHandle(SegmentHandle headerHandle, SegmentRollingPolicy rollingPolicy, List<SegmentChunk> segmentChunks) {
        this.headerHandle = (SegmentHandle)Preconditions.checkNotNull((Object)headerHandle, (Object)"headerHandle");
        this.readOnly = this.headerHandle.isReadOnly();
        this.segmentName = StreamSegmentNameUtils.getSegmentNameFromHeader((String)headerHandle.getSegmentName());
        Exceptions.checkNotNullOrEmpty((String)this.segmentName, (String)"headerHandle.getSegmentName()");
        this.rollingPolicy = rollingPolicy == null ? SegmentRollingPolicy.NO_ROLLING : rollingPolicy;
        this.segmentChunks = (List)Preconditions.checkNotNull(segmentChunks, (Object)"segmentChunks");
    }

    RollingSegmentHandle(SegmentHandle segmentHandle) {
        this.headerHandle = null;
        this.readOnly = segmentHandle.isReadOnly();
        this.segmentName = Exceptions.checkNotNullOrEmpty((String)segmentHandle.getSegmentName(), (String)"headerHandle.getSegmentName()");
        this.rollingPolicy = SegmentRollingPolicy.NO_ROLLING;
        this.segmentChunks = Collections.singletonList(new SegmentChunk(segmentHandle.getSegmentName(), 0L));
    }

    synchronized void refresh(RollingSegmentHandle source) {
        Preconditions.checkArgument((boolean)source.getSegmentName().equals(this.getSegmentName()), (Object)"SegmentName mismatch.");
        if (this.readOnly == source.readOnly) {
            this.headerHandle = source.headerHandle;
        }
        this.segmentChunks = new ArrayList<SegmentChunk>(source.chunks());
        this.setHeaderLength(source.getHeaderLength());
        if (source.isSealed()) {
            this.markSealed();
        }
        if (source.isDeleted()) {
            this.markDeleted();
        }
    }

    synchronized SegmentHandle getHeaderHandle() {
        return this.headerHandle;
    }

    synchronized void markSealed() {
        if (!this.sealed) {
            this.sealed = true;
            this.segmentChunks = Collections.unmodifiableList(this.segmentChunks);
            this.activeChunkHandle = null;
        }
    }

    synchronized boolean isSealed() {
        return this.sealed;
    }

    synchronized void markDeleted() {
        this.deleted = true;
    }

    synchronized boolean isDeleted() {
        return this.deleted;
    }

    synchronized SegmentChunk lastChunk() {
        return this.segmentChunks.size() == 0 ? null : this.segmentChunks.get(this.segmentChunks.size() - 1);
    }

    synchronized List<SegmentChunk> chunks() {
        if (this.sealed) {
            return this.segmentChunks;
        }
        return Collections.unmodifiableList(this.segmentChunks.subList(0, this.segmentChunks.size()));
    }

    synchronized void addChunk(SegmentChunk segmentChunk, SegmentHandle activeChunkHandle) {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Cannot add SegmentChunks for a Sealed Handle.");
        if (this.segmentChunks.size() > 0) {
            long expectedOffset = this.segmentChunks.get(this.segmentChunks.size() - 1).getLastOffset();
            Preconditions.checkArgument((segmentChunk.getStartOffset() == expectedOffset ? 1 : 0) != 0, (String)"Invalid SegmentChunk StartOffset. Expected %s, given %s.", (long)expectedOffset, (long)segmentChunk.getStartOffset());
        }
        Preconditions.checkNotNull((Object)activeChunkHandle, (Object)"activeChunkHandle");
        Preconditions.checkArgument((!activeChunkHandle.isReadOnly() ? 1 : 0) != 0, (Object)"Active SegmentChunk handle cannot be readonly.");
        Preconditions.checkArgument((boolean)activeChunkHandle.getSegmentName().equals(segmentChunk.getName()), (Object)"Active SegmentChunk handle must be for the last SegmentChunk.");
        this.activeChunkHandle = activeChunkHandle;
        this.segmentChunks.add(segmentChunk);
    }

    synchronized void addChunks(List<SegmentChunk> segmentChunks) {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Cannot add SegmentChunks for a Sealed Handle.");
        long expectedOffset = 0L;
        if (this.segmentChunks.size() > 0) {
            expectedOffset = this.segmentChunks.get(this.segmentChunks.size() - 1).getLastOffset();
        } else if (segmentChunks.size() > 0) {
            expectedOffset = segmentChunks.get(0).getStartOffset();
        }
        for (SegmentChunk s : segmentChunks) {
            Preconditions.checkArgument((s.getStartOffset() == expectedOffset ? 1 : 0) != 0, (String)"Invalid SegmentChunk StartOffset. Expected %s, given %s.", (long)expectedOffset, (long)s.getStartOffset());
            expectedOffset += s.getLength();
        }
        this.segmentChunks.addAll(segmentChunks);
        this.activeChunkHandle = null;
    }

    synchronized long length() {
        SegmentChunk lastSegmentChunk = this.lastChunk();
        return lastSegmentChunk == null ? 0L : lastSegmentChunk.getLastOffset();
    }

    synchronized SegmentHandle getActiveChunkHandle() {
        return this.activeChunkHandle;
    }

    synchronized void setActiveChunkHandle(SegmentHandle handle) {
        Preconditions.checkArgument((handle == null || !handle.isReadOnly() ? 1 : 0) != 0, (Object)"Active SegmentChunk handle cannot be readonly.");
        SegmentChunk last = this.lastChunk();
        Preconditions.checkState((last != null ? 1 : 0) != 0, (Object)"Cannot set an Active SegmentChunk handle when there are no SegmentChunks.");
        Preconditions.checkArgument((handle == null || handle.getSegmentName().equals(last.getName()) ? 1 : 0) != 0, (Object)"Active SegmentChunk handle must be for the last SegmentChunk.");
        this.activeChunkHandle = handle;
    }

    synchronized int getHeaderLength() {
        return this.headerLength;
    }

    synchronized void setHeaderLength(int value) {
        this.headerLength = value;
    }

    synchronized void increaseHeaderLength(int value) {
        this.headerLength += value;
    }

    public synchronized String toString() {
        if (this.deleted) {
            return String.format("%s (Deleted)", this.segmentName);
        }
        return String.format("%s (%s, %s, SegmentChunks=%d)", this.segmentName, this.sealed ? "Sealed" : "Not Sealed", this.isReadOnly() ? "R" : "RW", this.segmentChunks.size());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String getSegmentName() {
        return this.segmentName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @SuppressFBWarnings(justification="generated code")
    public SegmentRollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }
}

