/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.storage.rolling;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class SegmentChunk {
    private final String name;
    private final long startOffset;
    @GuardedBy(value="this")
    private long length;
    @GuardedBy(value="this")
    private boolean sealed;
    @GuardedBy(value="this")
    private boolean exists = true;

    SegmentChunk(String chunkName, long startOffset) {
        this.name = Exceptions.checkNotNullOrEmpty((String)chunkName, (String)"chunkName");
        Preconditions.checkArgument((startOffset >= 0L ? 1 : 0) != 0, (Object)"startOffset must be a non-negative number.");
        this.startOffset = startOffset;
    }

    static SegmentChunk forSegment(String segmentName, long startOffset) {
        return new SegmentChunk(StreamSegmentNameUtils.getSegmentChunkName((String)segmentName, (long)startOffset), startOffset);
    }

    SegmentChunk withNewOffset(long newOffset) {
        SegmentChunk ns = new SegmentChunk(this.name, newOffset);
        ns.setLength(this.getLength());
        if (this.isSealed()) {
            ns.markSealed();
        }
        if (!this.exists()) {
            ns.markInexistent();
        }
        return ns;
    }

    synchronized boolean isSealed() {
        return this.sealed;
    }

    synchronized void markSealed() {
        this.sealed = true;
    }

    synchronized void markUnsealed() {
        this.sealed = false;
    }

    synchronized boolean exists() {
        return this.exists;
    }

    synchronized void markInexistent() {
        this.exists = false;
    }

    synchronized long getLength() {
        return this.length;
    }

    synchronized void increaseLength(long delta) {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Cannot increase the length of a sealed SegmentChunk.");
        Preconditions.checkArgument((delta >= 0L ? 1 : 0) != 0, (Object)"Cannot decrease the length of a SegmentChunk.");
        this.length += delta;
    }

    synchronized void setLength(long length) {
        Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Cannot increase the length of a sealed SegmentChunk.");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be a non-negative number.");
        this.length = length;
    }

    synchronized long getLastOffset() {
        return this.startOffset + this.length;
    }

    public synchronized String toString() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.name;
        objectArray[1] = this.startOffset;
        objectArray[2] = this.length;
        objectArray[3] = this.exists ? (this.sealed ? ", sealed" : "") : ", deleted";
        return String.format("%s (%d+%d%s)", objectArray);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getStartOffset() {
        return this.startOffset;
    }
}

