/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.cluster;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.cluster.ContainerSet;
import io.pravega.common.cluster.Host;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HostContainerMap {
    public static final HostContainerMapSerializer SERIALIZER = new HostContainerMapSerializer();
    public static final HostContainerMap EMPTY = new HostContainerMap(Collections.emptyMap());
    private final Map<Host, ContainerSet> map;

    public HostContainerMap(Map<Host, ContainerSet> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public static HostContainerMap createHostContainerMap(Map<Host, Set<Integer>> map) {
        return new HostContainerMap(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new ContainerSet((Set)x.getValue()))));
    }

    public static HostContainerMap fromBytes(byte[] data) {
        return (HostContainerMap)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public Map<Host, Set<Integer>> getHostContainerMap() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((ContainerSet)x.getValue()).getContainerSet()));
    }

    @SuppressFBWarnings(justification="generated code")
    public static HostContainerMapBuilder builder() {
        return new HostContainerMapBuilder();
    }

    private static class HostContainerMapSerializer
    extends VersionedSerializer.WithBuilder<HostContainerMap, HostContainerMapBuilder> {
        private HostContainerMapSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, HostContainerMapBuilder hostContainerMapBuilder) throws IOException {
            hostContainerMapBuilder.map(revisionDataInput.readMap(arg_0 -> ((Host.HostSerializer)Host.SERIALIZER).deserialize(arg_0), arg_0 -> ((ContainerSet.ContainerSetSerializer)ContainerSet.SERIALIZER).deserialize(arg_0)));
        }

        private void write00(HostContainerMap hostContainerMap, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(hostContainerMap.map, (arg_0, arg_1) -> ((Host.HostSerializer)Host.SERIALIZER).serialize(arg_0, arg_1), (arg_0, arg_1) -> ((ContainerSet.ContainerSetSerializer)ContainerSet.SERIALIZER).serialize(arg_0, arg_1));
        }

        protected HostContainerMapBuilder newBuilder() {
            return HostContainerMap.builder();
        }
    }

    public static class HostContainerMapBuilder
    implements ObjectBuilder<HostContainerMap> {
        @SuppressFBWarnings(justification="generated code")
        private Map<Host, ContainerSet> map;

        @SuppressFBWarnings(justification="generated code")
        HostContainerMapBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public HostContainerMapBuilder map(Map<Host, ContainerSet> map) {
            this.map = map;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public HostContainerMap build() {
            return new HostContainerMap(this.map);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "HostContainerMap.HostContainerMapBuilder(map=" + this.map + ")";
        }
    }
}

