/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class DeleteStreamEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final long requestId;
    private final long creationTime;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return processor.processDeleteStream(this);
    }

    @SuppressFBWarnings(justification="generated code")
    public static DeleteStreamEventBuilder builder() {
        return new DeleteStreamEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getCreationTime() {
        return this.creationTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteStreamEvent)) {
            return false;
        }
        DeleteStreamEvent other = (DeleteStreamEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        return this.getCreationTime() == other.getCreationTime();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof DeleteStreamEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "DeleteStreamEvent(scope=" + this.getScope() + ", stream=" + this.getStream() + ", requestId=" + this.getRequestId() + ", creationTime=" + this.getCreationTime() + ")";
    }

    @ConstructorProperties(value={"scope", "stream", "requestId", "creationTime"})
    @SuppressFBWarnings(justification="generated code")
    public DeleteStreamEvent(String scope, String stream, long requestId, long creationTime) {
        this.scope = scope;
        this.stream = stream;
        this.requestId = requestId;
        this.creationTime = creationTime;
    }

    static class Serializer
    extends VersionedSerializer.WithBuilder<DeleteStreamEvent, DeleteStreamEventBuilder> {
        Serializer() {
        }

        protected DeleteStreamEventBuilder newBuilder() {
            return DeleteStreamEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(DeleteStreamEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeLong(e.requestId);
            target.writeLong(e.creationTime);
        }

        private void read00(RevisionDataInput source, DeleteStreamEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.requestId(source.readLong());
            b.creationTime(source.readLong());
        }
    }

    private static class DeleteStreamEventBuilder
    implements ObjectBuilder<DeleteStreamEvent> {
        @SuppressFBWarnings(justification="generated code")
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        private long creationTime;

        @SuppressFBWarnings(justification="generated code")
        DeleteStreamEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public DeleteStreamEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public DeleteStreamEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public DeleteStreamEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public DeleteStreamEventBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public DeleteStreamEvent build() {
            return new DeleteStreamEvent(this.scope, this.stream, this.requestId, this.creationTime);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "DeleteStreamEvent.DeleteStreamEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", requestId=" + this.requestId + ", creationTime=" + this.creationTime + ")";
        }
    }
}

