/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ScaleOpEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final List<Long> segmentsToSeal;
    private final List<Map.Entry<Double, Double>> newRanges;
    private final boolean runOnlyIfStarted;
    private final long scaleTime;
    private final long requestId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return processor.processScaleOpRequest(this);
    }

    @SuppressFBWarnings(justification="generated code")
    public static ScaleOpEventBuilder builder() {
        return new ScaleOpEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    public List<Long> getSegmentsToSeal() {
        return this.segmentsToSeal;
    }

    @SuppressFBWarnings(justification="generated code")
    public List<Map.Entry<Double, Double>> getNewRanges() {
        return this.newRanges;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isRunOnlyIfStarted() {
        return this.runOnlyIfStarted;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getScaleTime() {
        return this.scaleTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleOpEvent)) {
            return false;
        }
        ScaleOpEvent other = (ScaleOpEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        List<Long> this$segmentsToSeal = this.getSegmentsToSeal();
        List<Long> other$segmentsToSeal = other.getSegmentsToSeal();
        if (this$segmentsToSeal == null ? other$segmentsToSeal != null : !((Object)this$segmentsToSeal).equals(other$segmentsToSeal)) {
            return false;
        }
        List<Map.Entry<Double, Double>> this$newRanges = this.getNewRanges();
        List<Map.Entry<Double, Double>> other$newRanges = other.getNewRanges();
        if (this$newRanges == null ? other$newRanges != null : !((Object)this$newRanges).equals(other$newRanges)) {
            return false;
        }
        if (this.isRunOnlyIfStarted() != other.isRunOnlyIfStarted()) {
            return false;
        }
        if (this.getScaleTime() != other.getScaleTime()) {
            return false;
        }
        return this.getRequestId() == other.getRequestId();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ScaleOpEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        List<Long> $segmentsToSeal = this.getSegmentsToSeal();
        result = result * 59 + ($segmentsToSeal == null ? 43 : ((Object)$segmentsToSeal).hashCode());
        List<Map.Entry<Double, Double>> $newRanges = this.getNewRanges();
        result = result * 59 + ($newRanges == null ? 43 : ((Object)$newRanges).hashCode());
        result = result * 59 + (this.isRunOnlyIfStarted() ? 79 : 97);
        long $scaleTime = this.getScaleTime();
        result = result * 59 + (int)($scaleTime >>> 32 ^ $scaleTime);
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ScaleOpEvent(scope=" + this.getScope() + ", stream=" + this.getStream() + ", segmentsToSeal=" + this.getSegmentsToSeal() + ", newRanges=" + this.getNewRanges() + ", runOnlyIfStarted=" + this.isRunOnlyIfStarted() + ", scaleTime=" + this.getScaleTime() + ", requestId=" + this.getRequestId() + ")";
    }

    @ConstructorProperties(value={"scope", "stream", "segmentsToSeal", "newRanges", "runOnlyIfStarted", "scaleTime", "requestId"})
    @SuppressFBWarnings(justification="generated code")
    public ScaleOpEvent(String scope, String stream, List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, boolean runOnlyIfStarted, long scaleTime, long requestId) {
        this.scope = scope;
        this.stream = stream;
        this.segmentsToSeal = segmentsToSeal;
        this.newRanges = newRanges;
        this.runOnlyIfStarted = runOnlyIfStarted;
        this.scaleTime = scaleTime;
        this.requestId = requestId;
    }

    static class Serializer
    extends VersionedSerializer.WithBuilder<ScaleOpEvent, ScaleOpEventBuilder> {
        Serializer() {
        }

        protected ScaleOpEventBuilder newBuilder() {
            return ScaleOpEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(ScaleOpEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeCollection((Collection)e.segmentsToSeal, DataOutput::writeLong);
            target.writeCollection((Collection)e.newRanges, this::writeNewRanges00);
            target.writeBoolean(e.runOnlyIfStarted);
            target.writeLong(e.scaleTime);
            target.writeLong(e.requestId);
        }

        private void read00(RevisionDataInput source, ScaleOpEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.segmentsToSeal((List)source.readCollection(DataInput::readLong, ArrayList::new));
            b.newRanges((List)source.readCollection(this::readNewRanges00, ArrayList::new));
            b.runOnlyIfStarted(source.readBoolean());
            b.scaleTime(source.readLong());
            b.requestId(source.readLong());
        }

        private void writeNewRanges00(RevisionDataOutput target, Map.Entry<Double, Double> element) throws IOException {
            target.writeDouble(element.getKey().doubleValue());
            target.writeDouble(element.getValue().doubleValue());
        }

        private Map.Entry<Double, Double> readNewRanges00(RevisionDataInput dataInput) throws IOException {
            return new AbstractMap.SimpleImmutableEntry<Double, Double>(dataInput.readDouble(), dataInput.readDouble());
        }
    }

    private static class ScaleOpEventBuilder
    implements ObjectBuilder<ScaleOpEvent> {
        @SuppressFBWarnings(justification="generated code")
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        private List<Long> segmentsToSeal;
        @SuppressFBWarnings(justification="generated code")
        private List<Map.Entry<Double, Double>> newRanges;
        @SuppressFBWarnings(justification="generated code")
        private boolean runOnlyIfStarted;
        @SuppressFBWarnings(justification="generated code")
        private long scaleTime;
        @SuppressFBWarnings(justification="generated code")
        private long requestId;

        @SuppressFBWarnings(justification="generated code")
        ScaleOpEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder segmentsToSeal(List<Long> segmentsToSeal) {
            this.segmentsToSeal = segmentsToSeal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder newRanges(List<Map.Entry<Double, Double>> newRanges) {
            this.newRanges = newRanges;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder runOnlyIfStarted(boolean runOnlyIfStarted) {
            this.runOnlyIfStarted = runOnlyIfStarted;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder scaleTime(long scaleTime) {
            this.scaleTime = scaleTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScaleOpEvent build() {
            return new ScaleOpEvent(this.scope, this.stream, this.segmentsToSeal, this.newRanges, this.runOnlyIfStarted, this.scaleTime, this.requestId);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ScaleOpEvent.ScaleOpEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", segmentsToSeal=" + this.segmentsToSeal + ", newRanges=" + this.newRanges + ", runOnlyIfStarted=" + this.runOnlyIfStarted + ", scaleTime=" + this.scaleTime + ", requestId=" + this.requestId + ")";
        }
    }
}

