/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class MetricsTags {
    public static final String DEFAULT_HOSTNAME_KEY = "HOSTNAME";
    public static final String TAG_CONTAINER = "container";
    public static final String TAG_HOST = "host";
    public static final String TAG_SCOPE = "scope";
    public static final String TAG_STREAM = "stream";
    public static final String TAG_SEGMENT = "segment";
    public static final String TAG_TRANSACTION = "transaction";
    public static final String TAG_EPOCH = "epoch";
    private static final String TRANSACTION_DELIMITER = "#transaction.";
    private static final String EPOCH_DELIMITER = ".#epoch.";
    private static final int TRANSACTION_PART_LENGTH = 16;
    private static final int TRANSACTION_ID_LENGTH = 32;
    private static final String TABLES = "_tables";
    private static final String TABLE_SEGMENT_DELIMITER = "/_tables/";

    public static String[] containerTag(int containerId) {
        return new String[]{TAG_CONTAINER, String.valueOf(containerId)};
    }

    public static String[] hostTag(String hostname) {
        return new String[]{TAG_HOST, hostname};
    }

    public static String[] streamTags(String scope, String stream) {
        return new String[]{TAG_SCOPE, scope, TAG_STREAM, stream};
    }

    public static String[] transactionTags(String scope, String stream, String transactionId) {
        return new String[]{TAG_SCOPE, scope, TAG_STREAM, stream, TAG_TRANSACTION, transactionId};
    }

    public static String[] segmentTags(String qualifiedSegmentName) {
        int segmentIdIndex;
        Preconditions.checkNotNull((Object)qualifiedSegmentName);
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null};
        if (qualifiedSegmentName.contains(TABLE_SEGMENT_DELIMITER)) {
            String[] tokens = qualifiedSegmentName.split(TABLE_SEGMENT_DELIMITER);
            tags[1] = tokens[0];
            tags[3] = TABLES;
            tags[5] = tokens[1];
            tags[7] = "0";
            return tags;
        }
        String segmentBaseName = MetricsTags.getSegmentBaseName(qualifiedSegmentName);
        String[] tokens = segmentBaseName.split("[/]");
        int n = segmentIdIndex = tokens.length == 2 ? 1 : 2;
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            tags[5] = segmentIdTokens[0];
            tags[7] = segmentIdTokens[1];
        } else {
            tags[5] = tokens[segmentIdIndex];
            tags[7] = "0";
        }
        if (tokens.length == 3) {
            tags[1] = tokens[0];
            tags[3] = tokens[1];
        } else {
            tags[1] = "default";
            tags[3] = tokens[0];
        }
        return tags;
    }

    private static String getSegmentBaseName(String segmentQualifiedName) {
        int endOfStreamNamePos = segmentQualifiedName.lastIndexOf(TRANSACTION_DELIMITER);
        if (endOfStreamNamePos < 0 || endOfStreamNamePos + TRANSACTION_DELIMITER.length() + 32 > segmentQualifiedName.length()) {
            return segmentQualifiedName;
        }
        return segmentQualifiedName.substring(0, endOfStreamNamePos);
    }

    public static String[] createHostTag(String hostnameKey) {
        String[] hostTag = new String[]{TAG_HOST, null};
        hostTag[1] = System.getProperty(hostnameKey);
        if (!Strings.isNullOrEmpty((String)hostTag[1])) {
            return hostTag;
        }
        hostTag[1] = System.getenv(hostnameKey);
        if (!Strings.isNullOrEmpty((String)hostTag[1])) {
            return hostTag;
        }
        try {
            hostTag[1] = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostTag[1] = "unknown";
        }
        return hostTag;
    }
}

