/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.MeterRegistry;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.Gauge;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.StatsLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLoggerImpl
implements DynamicLogger {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(DynamicLoggerImpl.class);
    private final long cacheSize;
    private final long cacheEvictionDuration;
    private final MeterRegistry metrics;
    private final StatsLogger underlying;
    private final Cache<String, Counter> countersCache;
    private final Cache<String, Gauge> gaugesCache;
    private final Cache<String, Meter> metersCache;

    public DynamicLoggerImpl(MetricsConfig metricsConfig, final MeterRegistry metrics, StatsLogger statsLogger) {
        Preconditions.checkNotNull((Object)metricsConfig, (Object)"metricsConfig");
        Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
        Preconditions.checkNotNull((Object)statsLogger, (Object)"statsLogger");
        this.metrics = metrics;
        this.underlying = statsLogger;
        this.cacheSize = metricsConfig.getDynamicCacheSize();
        this.cacheEvictionDuration = metricsConfig.getDynamicCacheEvictionDurationMinutes().toMillis();
        this.countersCache = CacheBuilder.newBuilder().maximumSize(this.cacheSize).expireAfterAccess(this.cacheEvictionDuration, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, Counter>(){

            public void onRemoval(RemovalNotification<String, Counter> removal) {
                Counter counter = (Counter)removal.getValue();
                if (removal.getCause() != RemovalCause.REPLACED) {
                    metrics.remove(counter.getId());
                    log.debug("Removed Counter: {}.", (Object)counter.getId());
                }
            }
        }).build();
        this.gaugesCache = CacheBuilder.newBuilder().maximumSize(this.cacheSize).expireAfterAccess(this.cacheEvictionDuration, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, Gauge>(){

            public void onRemoval(RemovalNotification<String, Gauge> removal) {
                Gauge gauge = (Gauge)removal.getValue();
                if (removal.getCause() != RemovalCause.REPLACED) {
                    metrics.remove(gauge.getId());
                    log.debug("Removed Gauge: {}.", (Object)gauge.getId());
                }
            }
        }).build();
        this.metersCache = CacheBuilder.newBuilder().maximumSize(this.cacheSize).expireAfterAccess(this.cacheEvictionDuration, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<String, Meter>(){

            public void onRemoval(RemovalNotification<String, Meter> removal) {
                Meter meter = (Meter)removal.getValue();
                if (removal.getCause() != RemovalCause.REPLACED) {
                    metrics.remove(meter.getId());
                    log.debug("Removed Meter: {}.", (Object)meter.getId());
                }
            }
        }).build();
    }

    @Override
    public void incCounterValue(String name, long delta, final String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        Preconditions.checkNotNull((Object)delta);
        final long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"incCounterValue", (Object[])new Object[]{name, delta, tags});
        try {
            final MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
            Counter counter = (Counter)this.countersCache.get((Object)keys.getCacheKey(), (Callable)new Callable<Counter>(){

                @Override
                public Counter call() throws Exception {
                    LoggerHelpers.traceLeave((Logger)log, (String)"createCounter", (long)traceId, (Object[])new Object[]{keys.getRegistryKey(), tags});
                    return DynamicLoggerImpl.this.underlying.createCounter(keys.getRegistryKey(), tags);
                }
            });
            counter.add(delta);
            LoggerHelpers.traceLeave((Logger)log, (String)"counter.add", (long)traceId, (Object[])new Object[]{counter.get(), delta});
        }
        catch (ExecutionException e) {
            log.error("Error while countersCache create counter", (Throwable)e);
        }
    }

    @Override
    public void updateCounterValue(String name, long value, String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"updateCounterValue", (Object[])new Object[]{name, value, tags});
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Counter counter = (Counter)this.countersCache.getIfPresent((Object)keys.getCacheKey());
        if (counter != null) {
            counter.clear();
            LoggerHelpers.traceLeave((Logger)log, (String)"counter.clear", (long)traceId, (Object[])new Object[]{counter.getId()});
        } else {
            counter = this.underlying.createCounter(keys.getRegistryKey(), tags);
            LoggerHelpers.traceLeave((Logger)log, (String)"createCounter", (long)traceId, (Object[])new Object[]{keys.getRegistryKey(), tags});
        }
        counter.add(value);
        LoggerHelpers.traceLeave((Logger)log, (String)"counter.add", (long)traceId, (Object[])new Object[]{counter.getId(), value});
        this.countersCache.put((Object)keys.getCacheKey(), (Object)counter);
    }

    @Override
    public void freezeCounter(String name, String ... tags) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"freezeCounter", (Object[])new Object[]{name, tags});
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Counter counter = (Counter)this.countersCache.getIfPresent((Object)keys.getCacheKey());
        if (counter != null) {
            counter.close();
            LoggerHelpers.traceLeave((Logger)log, (String)"counter.close():", (long)traceId, (Object[])new Object[]{counter.getId()});
        }
        this.countersCache.invalidate((Object)keys.getRegistryKey());
        LoggerHelpers.traceLeave((Logger)log, (String)"counterCache.invalidate", (long)traceId, (Object[])new Object[]{keys.getRegistryKey()});
    }

    @Override
    public <T extends Number> void reportGaugeValue(String name, final T value, final String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        Preconditions.checkNotNull(value);
        final long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"reportGaugeValue", (Object[])new Object[]{name, value, tags});
        try {
            final MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
            Gauge gauge = (Gauge)this.gaugesCache.get((Object)keys.getCacheKey(), (Callable)new Callable<Gauge>(){

                @Override
                public Gauge call() throws Exception {
                    LoggerHelpers.traceLeave((Logger)log, (String)"registerGauge", (long)traceId, (Object[])new Object[]{keys.getRegistryKey(), value.doubleValue(), tags});
                    return DynamicLoggerImpl.this.underlying.registerGauge(keys.getRegistryKey(), value::doubleValue, tags);
                }
            });
            gauge.setSupplier(value::doubleValue);
            LoggerHelpers.traceLeave((Logger)log, (String)"gauge.setSupplier", (long)traceId, (Object[])new Object[]{gauge.getId(), value.doubleValue()});
        }
        catch (ExecutionException e) {
            log.error("Error accessing gauge through gaugesCache", (Throwable)e);
        }
    }

    @Override
    public void freezeGaugeValue(String name, String ... tags) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"freezeGaugeValue", (Object[])new Object[]{name, tags});
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Gauge gauge = (Gauge)this.gaugesCache.getIfPresent((Object)keys.getCacheKey());
        if (gauge != null) {
            gauge.close();
            LoggerHelpers.traceLeave((Logger)log, (String)"gauge.close():", (long)traceId, (Object[])new Object[]{gauge.getId()});
        }
        this.gaugesCache.invalidate((Object)keys.getCacheKey());
        LoggerHelpers.traceLeave((Logger)log, (String)"gaugeCache.invalidate", (long)traceId, (Object[])new Object[]{keys.getCacheKey()});
    }

    @Override
    public void recordMeterEvents(String name, long number, final String ... tags) {
        Exceptions.checkNotNullOrEmpty((String)name, (String)"name");
        Preconditions.checkNotNull((Object)number);
        final long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"recordMeterEvents", (Object[])new Object[]{name, number, tags});
        final MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        try {
            Meter meter = (Meter)this.metersCache.get((Object)keys.getCacheKey(), (Callable)new Callable<Meter>(){

                @Override
                public Meter call() throws Exception {
                    LoggerHelpers.traceLeave((Logger)log, (String)"createMeter", (long)traceId, (Object[])new Object[]{keys.getRegistryKey(), tags});
                    return DynamicLoggerImpl.this.underlying.createMeter(keys.getRegistryKey(), tags);
                }
            });
            meter.recordEvents(number);
            LoggerHelpers.traceLeave((Logger)log, (String)"meter.recordEvents", (long)traceId, (Object[])new Object[]{meter.getId(), number});
        }
        catch (ExecutionException e) {
            log.error("Error while metersCache create meter", (Throwable)e);
        }
    }

    @Override
    public void freezeMeter(String name, String ... tags) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"freezeMeter", (Object[])new Object[]{name, tags});
        MetricsNames.MetricKey keys = MetricsNames.metricKey(name, tags);
        Meter meter = (Meter)this.metersCache.getIfPresent((Object)keys.getCacheKey());
        if (meter != null) {
            meter.close();
            LoggerHelpers.traceLeave((Logger)log, (String)"meter.close():", (long)traceId, (Object[])new Object[]{meter.getId()});
        }
        this.metersCache.invalidate((Object)keys.getCacheKey());
        LoggerHelpers.traceLeave((Logger)log, (String)"metersCache.invalidate", (long)traceId, (Object[])new Object[]{keys.getCacheKey()});
    }
}

