/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import io.micrometer.core.instrument.Meter;
import io.pravega.shared.metrics.Counter;
import io.pravega.shared.metrics.Gauge;
import io.pravega.shared.metrics.Meter;
import io.pravega.shared.metrics.OpStatsData;
import io.pravega.shared.metrics.OpStatsLogger;
import io.pravega.shared.metrics.StatsLogger;
import java.time.Duration;
import java.util.EnumMap;
import java.util.function.Supplier;

public class NullStatsLogger
implements StatsLogger {
    public static final NullStatsLogger INSTANCE = new NullStatsLogger();
    static final NullCounter NULLCOUNTER = new NullCounter();
    static final NullGauge NULLGAUGE = new NullGauge();
    static final NullMeter NULLMETER = new NullMeter();
    static final NullOpStatsLogger NULLOPSTATSLOGGER = new NullOpStatsLogger();
    private static final Meter.Id NULL_ID = null;

    @Override
    public OpStatsLogger createStats(String name, String ... tags) {
        return NULLOPSTATSLOGGER;
    }

    @Override
    public Counter createCounter(String name, String ... tags) {
        return NULLCOUNTER;
    }

    @Override
    public Gauge registerGauge(String name, Supplier<Number> value, String ... tags) {
        return NULLGAUGE;
    }

    @Override
    public Meter createMeter(String name, String ... tags) {
        return NULLMETER;
    }

    @Override
    public StatsLogger createScopeLogger(String name) {
        return this;
    }

    private static class NullMeter
    implements Meter {
        private NullMeter() {
        }

        @Override
        public void recordEvent() {
        }

        @Override
        public void recordEvents(long n) {
        }

        @Override
        public long getCount() {
            return 0L;
        }

        @Override
        public Meter.Id getId() {
            return NULL_ID;
        }

        @Override
        public void close() {
        }
    }

    private static class NullCounter
    implements Counter {
        private NullCounter() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void inc() {
        }

        @Override
        public void add(long delta) {
        }

        @Override
        public long get() {
            return 0L;
        }

        @Override
        public Meter.Id getId() {
            return NULL_ID;
        }

        @Override
        public void close() {
        }
    }

    private static class NullOpStatsLogger
    implements OpStatsLogger {
        final OpStatsData nullOpStats = new OpStatsData(0L, 0L, 0.0, new EnumMap<OpStatsData.Percentile, Long>(OpStatsData.Percentile.class));

        private NullOpStatsLogger() {
        }

        @Override
        public void reportFailEvent(Duration duration) {
        }

        @Override
        public void reportSuccessEvent(Duration duration) {
        }

        @Override
        public void reportSuccessValue(long value) {
        }

        @Override
        public void reportFailValue(long value) {
        }

        @Override
        public OpStatsData toOpStatsData() {
            return this.nullOpStats;
        }

        @Override
        public void clear() {
        }

        @Override
        public Meter.Id getId() {
            return NULL_ID;
        }

        @Override
        public void close() {
        }
    }

    private static class NullGauge
    implements Gauge {
        private NullGauge() {
        }

        @Override
        public Meter.Id getId() {
            return NULL_ID;
        }

        @Override
        public Supplier<Number> getSupplier() {
            return null;
        }

        @Override
        public void setSupplier(Supplier<Number> supplier) {
        }

        @Override
        public void close() {
        }
    }
}

