/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.EnumSet;

public class OpStatsData {
    static final EnumSet<Percentile> PERCENTILE_SET = EnumSet.allOf(Percentile.class);
    static final double[] PERCENTILE_ARRAY = new double[]{0.1, 0.5, 0.9, 0.99, 0.999, 0.9999};
    private final long numSuccessfulEvents;
    private final long numFailedEvents;
    private final double avgLatencyMillis;
    private final EnumMap<Percentile, Long> percentileLongMap;

    public OpStatsData(long numSuccessfulEvents, long numFailedEvents, double avgLatencyMillis, EnumMap<Percentile, Long> percentileLongMap) {
        Preconditions.checkArgument((numSuccessfulEvents >= 0L ? 1 : 0) != 0, (Object)"numSuccessfulEvents must be non-negative number.");
        Preconditions.checkArgument((numFailedEvents >= 0L ? 1 : 0) != 0, (Object)"numFailedEvents must be non-negative number.");
        Preconditions.checkArgument((avgLatencyMillis >= 0.0 ? 1 : 0) != 0, (Object)"avgLatencyMillis must be non-negative number.");
        this.numSuccessfulEvents = numSuccessfulEvents;
        this.numFailedEvents = numFailedEvents;
        this.avgLatencyMillis = avgLatencyMillis;
        this.percentileLongMap = percentileLongMap;
    }

    public long getPercentile(Percentile percentile) {
        return this.percentileLongMap.getOrDefault((Object)percentile, -1L);
    }

    public long getNumSuccessfulEvents() {
        return this.numSuccessfulEvents;
    }

    public long getNumFailedEvents() {
        return this.numFailedEvents;
    }

    public double getAvgLatencyMillis() {
        return this.avgLatencyMillis;
    }

    public static enum Percentile {
        P10(10.0),
        P50(50.0),
        P90(90.0),
        P99(99.0),
        P999(99.9),
        P9999(99.99);

        private final double numVal;

        private Percentile(double numVal) {
            this.numVal = numVal;
        }

        public double getValue() {
            return this.numVal;
        }
    }
}

