/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.pravega.shared.MetricsNames;
import io.pravega.shared.metrics.OpStatsData;
import io.pravega.shared.metrics.OpStatsLogger;
import java.time.Duration;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;

class OpStatsLoggerImpl
implements OpStatsLogger {
    private final Timer success;
    private final Timer fail;
    private final MeterRegistry meterRegistry;

    OpStatsLoggerImpl(MeterRegistry metricRegistry, String statName, String ... tags) {
        this.meterRegistry = (MeterRegistry)Preconditions.checkNotNull((Object)metricRegistry, (Object)"metrics");
        this.success = Timer.builder((String)statName).tags(tags).publishPercentiles(OpStatsData.PERCENTILE_ARRAY).register(this.meterRegistry);
        this.fail = Timer.builder((String)MetricsNames.failMetricName(statName)).tags(tags).publishPercentiles(OpStatsData.PERCENTILE_ARRAY).register(this.meterRegistry);
    }

    @Override
    public void close() {
        this.meterRegistry.remove((Meter)this.success);
        this.meterRegistry.remove((Meter)this.fail);
    }

    @Override
    public Meter.Id getId() {
        return this.success.getId();
    }

    @Override
    public void reportFailEvent(Duration duration) {
        this.fail.record(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportSuccessEvent(Duration duration) {
        this.success.record(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportSuccessValue(long value) {
        this.success.record(value, TimeUnit.MILLISECONDS);
    }

    @Override
    public void reportFailValue(long value) {
        this.fail.record(value, TimeUnit.MILLISECONDS);
    }

    @Override
    public void clear() {
    }

    @Override
    public OpStatsData toOpStatsData() {
        long numFailed = this.fail.count();
        long numSuccess = this.success.count();
        HistogramSnapshot snapshot = this.success.takeSnapshot();
        double avgLatencyMillis = snapshot.mean();
        EnumMap<OpStatsData.Percentile, Long> percentileLongMap = new EnumMap<OpStatsData.Percentile, Long>(OpStatsData.Percentile.class);
        if (OpStatsData.PERCENTILE_ARRAY.length == snapshot.percentileValues().length) {
            int index = 0;
            for (OpStatsData.Percentile percent : OpStatsData.PERCENTILE_SET) {
                percentileLongMap.put(percent, (long)snapshot.percentileValues()[index++].value());
            }
        }
        return new OpStatsData(numSuccess, numFailed, avgLatencyMillis, percentileLongMap);
    }
}

