/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.NullStatsProvider;
import io.pravega.shared.metrics.StatsLogger;
import io.pravega.shared.metrics.StatsLoggerProxy;
import io.pravega.shared.metrics.StatsProvider;
import io.pravega.shared.metrics.StatsProviderImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsProviderProxy
implements StatsProvider {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StatsProviderProxy.class);
    private final AtomicReference<StatsProvider> instance = new AtomicReference<NullStatsProvider>(new NullStatsProvider());
    private final ConcurrentHashMap<StatsLoggerProxy, String> statsLoggerProxies = new ConcurrentHashMap();

    StatsProviderProxy() {
    }

    void setProvider(MetricsConfig config) {
        if (config.isEnableStatistics()) {
            log.info("Stats enabled");
            this.instance.set(new StatsProviderImpl(config));
        } else {
            log.info("Stats disabled");
            this.instance.set(new NullStatsProvider());
        }
        this.statsLoggerProxies.forEach((proxy, scope) -> proxy.setLogger(this.instance.get().createStatsLogger((String)scope)));
    }

    @Override
    public void start() {
        this.instance.get().start();
    }

    @Override
    public void startWithoutExporting() {
        this.instance.get().startWithoutExporting();
    }

    @Override
    public void close() {
        this.instance.get().close();
    }

    @Override
    public StatsLogger createStatsLogger(String scope) {
        StatsLogger logger = this.instance.get().createStatsLogger(scope);
        StatsLoggerProxy proxy = new StatsLoggerProxy(logger);
        this.statsLoggerProxies.put(proxy, scope);
        return proxy;
    }

    @Override
    public DynamicLogger createDynamicLogger() {
        return this.instance.get().createDynamicLogger();
    }
}

