/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class NameUtils {
    public static final String INTERNAL_NAME_PREFIX = "_";
    public static final String INTERNAL_SCOPE_NAME = "_system";
    public static final String READER_GROUP_STREAM_PREFIX = "_RG";
    private static final String MARK_PREFIX = "_MARK";

    public static String getInternalNameForStream(String streamName) {
        return INTERNAL_NAME_PREFIX + streamName;
    }

    public static String getStreamForReaderGroup(String groupNameName) {
        return READER_GROUP_STREAM_PREFIX + groupNameName;
    }

    public static String validateUserStreamName(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)name.matches("[\\p{Alnum}\\.\\-]+"), (Object)"Name must be a-z, 0-9, ., -.");
        return name;
    }

    public static String validateStreamName(String name) {
        Preconditions.checkNotNull((Object)name);
        String matcher = "[_]?[\\p{Alnum}\\.\\-]+";
        Preconditions.checkArgument((boolean)name.matches("[_]?[\\p{Alnum}\\.\\-]+"), (Object)"Name must be [_]?[\\p{Alnum}\\.\\-]+");
        return name;
    }

    public static String validateUserScopeName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String validateScopeName(String name) {
        return NameUtils.validateStreamName(name);
    }

    public static String validateReaderGroupName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String getMarkStreamForStream(String stream) {
        StringBuffer sb = new StringBuffer();
        sb.append(MARK_PREFIX);
        sb.append(stream);
        return sb.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    static String getMARK_PREFIX() {
        return MARK_PREFIX;
    }
}

