/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.protocol.netty.WireCommands;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandDecoder
extends ByteToMessageDecoder {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(CommandDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        WireCommand command = CommandDecoder.parseCommand(in);
        if (log.isTraceEnabled()) {
            log.trace("Decode a message on connection: {}. Message was {}", (Object)ctx.channel().remoteAddress(), (Object)command);
        }
        if (command != null) {
            out.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static WireCommand parseCommand(ByteBuf in) throws IOException {
        ByteBufInputStream is = new ByteBufInputStream(in);
        try {
            int readableBytes = in.readableBytes();
            if (readableBytes < 8) {
                throw new InvalidMessageException("Not enough bytes to read.");
            }
            WireCommandType type = CommandDecoder.readType((DataInput)is);
            int length = CommandDecoder.readLength((DataInput)is, readableBytes);
            int readIndex = in.readerIndex();
            WireCommand command = type.readFrom(is, length);
            in.readerIndex(readIndex + length);
            WireCommand wireCommand = command;
            return wireCommand;
        }
        finally {
            if (Collections.singletonList(is).get(0) != null) {
                is.close();
            }
        }
    }

    private static int readLength(DataInput is, int readableBytes) throws IOException {
        int length = is.readInt();
        if (length < 0) {
            throw new InvalidMessageException("Length read from wire was negitive.");
        }
        if (length > readableBytes - 8) {
            throw new InvalidMessageException("Header indicated more bytes than exist.");
        }
        return length;
    }

    private static WireCommandType readType(DataInput is) throws IOException {
        int t = is.readInt();
        WireCommandType type = WireCommands.getType(t);
        if (type == null) {
            throw new InvalidMessageException("Unknown wire command: " + t);
        }
        return type;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "CommandDecoder()";
    }
}

