/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionLoggingHandler
extends ChannelDuplexHandler {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ExceptionLoggingHandler.class);
    private final String connectionName;

    public ExceptionLoggingHandler(String connectionName) {
        this.connectionName = connectionName;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Uncaught exception on connection " + this.connectionName, cause);
        super.exceptionCaught(ctx, cause);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            super.channelRead(ctx, msg);
        }
        catch (Exception e) {
            log.error("Uncaught exception on connection " + this.connectionName, (Throwable)e);
            throw e;
        }
    }
}

