/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.RequestProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.segment.ScaleType;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public final class WireCommands {
    public static final int WIRE_VERSION = 9;
    public static final int OLDEST_COMPATIBLE_VERSION = 5;
    public static final int TYPE_SIZE = 4;
    public static final int TYPE_PLUS_LENGTH_SIZE = 8;
    public static final int MAX_WIRECOMMAND_SIZE = 0x7FFFFF;
    public static final long NULL_ATTRIBUTE_VALUE = Long.MIN_VALUE;
    private static final Map<Integer, WireCommandType> MAPPING;
    private static final String EMPTY_STACK_TRACE = "";

    public static WireCommandType getType(int value) {
        return MAPPING.get(value);
    }

    static {
        HashMap<Integer, WireCommandType> map = new HashMap<Integer, WireCommandType>();
        for (WireCommandType t : WireCommandType.values()) {
            map.put(t.getCode(), t);
        }
        MAPPING = Collections.unmodifiableMap(map);
    }

    public static final class TableKeyBadVersion
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEY_BAD_VERSION;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeyBadVersion(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableKeyBadVersion(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Conditional table update failed since the key version is incorrect : " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public TableKeyBadVersion(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeyBadVersion)) {
                return false;
            }
            TableKeyBadVersion other = (TableKeyBadVersion)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class TableKeyDoesNotExist
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEY_DOES_NOT_EXIST;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeyDoesNotExist(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableKeyDoesNotExist(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Conditional table update failed since the key does not exist : " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public TableKeyDoesNotExist(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeyDoesNotExist)) {
                return false;
            }
            TableKeyDoesNotExist other = (TableKeyDoesNotExist)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class TableValue {
        public static final TableValue EMPTY = new TableValue(Unpooled.EMPTY_BUFFER);
        public static final int HEADER_BYTES = 8;
        final ByteBuf data;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(4 + this.data.readableBytes());
            out.writeInt(this.data.readableBytes());
            if (this.data.readableBytes() != 0) {
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
            }
        }

        public static TableValue readFrom(DataInput in, int length) throws IOException {
            int payloadSize = in.readInt();
            int valueLength = in.readInt();
            if (valueLength == 0) {
                return EMPTY;
            }
            if (length < payloadSize) {
                throw new InvalidMessageException("Was expecting length of at least : " + payloadSize + " but found: " + length);
            }
            byte[] msg = new byte[valueLength];
            in.readFully(msg);
            return new TableValue(Unpooled.wrappedBuffer((byte[])msg));
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        public TableValue(ByteBuf data) {
            this.data = data;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableValue)) {
                return false;
            }
            TableValue other = (TableValue)o;
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableValue(data=" + this.getData() + ")";
        }
    }

    public static final class TableKey {
        public static final long NO_VERSION = Long.MIN_VALUE;
        public static final long NOT_EXISTS = -1L;
        public static final int HEADER_BYTES = 8;
        public static final TableKey EMPTY = new TableKey(Unpooled.EMPTY_BUFFER, Long.MIN_VALUE);
        final ByteBuf data;
        final long keyVersion;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(4 + this.data.readableBytes() + 8);
            out.writeInt(this.data.readableBytes());
            if (this.data.readableBytes() != 0) {
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
                out.writeLong(this.keyVersion);
            }
        }

        public static TableKey readFrom(DataInput in, int length) throws IOException {
            int payLoadSize = in.readInt();
            int dataLength = in.readInt();
            if (dataLength == 0) {
                return EMPTY;
            }
            if (length < payLoadSize) {
                throw new InvalidMessageException("Was expecting length of at least : " + payLoadSize + " but found: " + length);
            }
            byte[] msg = new byte[dataLength];
            in.readFully(msg);
            long keyVersion = in.readLong();
            return new TableKey(Unpooled.wrappedBuffer((byte[])msg), keyVersion);
        }

        @ConstructorProperties(value={"data", "keyVersion"})
        @SuppressFBWarnings(justification="generated code")
        public TableKey(ByteBuf data, long keyVersion) {
            this.data = data;
            this.keyVersion = keyVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getKeyVersion() {
            return this.keyVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKey)) {
                return false;
            }
            TableKey other = (TableKey)o;
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            return this.getKeyVersion() == other.getKeyVersion();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            long $keyVersion = this.getKeyVersion();
            result = result * 59 + (int)($keyVersion >>> 32 ^ $keyVersion);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableKey(data=" + this.getData() + ", keyVersion=" + this.getKeyVersion() + ")";
        }
    }

    public static final class TableEntries {
        static final Function<Integer, Integer> GET_HEADER_BYTES = entryCount -> 4 + entryCount * 16;
        final List<Map.Entry<TableKey, TableValue>> entries;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.entries.size());
            for (Map.Entry<TableKey, TableValue> ent : this.entries) {
                ent.getKey().writeFields(out);
                ent.getValue().writeFields(out);
            }
        }

        public static TableEntries readFrom(ByteBufInputStream in, int length) throws IOException {
            int numberOfEntries = in.readInt();
            ArrayList<Map.Entry<TableKey, TableValue>> entries = new ArrayList<Map.Entry<TableKey, TableValue>>();
            for (int i = 0; i < numberOfEntries; ++i) {
                entries.add(new AbstractMap.SimpleImmutableEntry<TableKey, TableValue>(TableKey.readFrom((DataInput)in, in.available()), TableValue.readFrom((DataInput)in, in.available())));
            }
            return new TableEntries(entries);
        }

        public int size() {
            int dataBytes = this.entries.stream().mapToInt(e -> ((TableKey)e.getKey()).getData().readableBytes() + 8 + ((TableValue)e.getValue()).getData().readableBytes()).sum();
            return GET_HEADER_BYTES.apply(this.entries.size()) + dataBytes;
        }

        @ConstructorProperties(value={"entries"})
        @SuppressFBWarnings(justification="generated code")
        public TableEntries(List<Map.Entry<TableKey, TableValue>> entries) {
            this.entries = entries;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<Map.Entry<TableKey, TableValue>> getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntries)) {
                return false;
            }
            TableEntries other = (TableEntries)o;
            List<Map.Entry<TableKey, TableValue>> this$entries = this.getEntries();
            List<Map.Entry<TableKey, TableValue>> other$entries = other.getEntries();
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Map.Entry<TableKey, TableValue>> $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableEntries(entries=" + this.getEntries() + ")";
        }
    }

    public static final class TableEntriesRead
    implements Reply,
    WireCommand {
        public static final Function<Integer, Integer> GET_HEADER_BYTES = entryCount -> 8 + TableEntries.GET_HEADER_BYTES.apply((Integer)entryCount) + 4;
        final WireCommandType type = WireCommandType.TABLE_ENTRIES_READ;
        final long requestId;
        final String segment;
        final TableEntries entries;
        final ByteBuf continuationToken;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableEntriesRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            this.entries.writeFields(out);
            out.writeInt(this.continuationToken.readableBytes());
            this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            int dataLength = in.readInt();
            if (length < dataLength + 8 + segment.getBytes(StandardCharsets.UTF_8).length + entries.size() + 4) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + dataLength);
            }
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new TableEntriesRead(requestId, segment, entries, Unpooled.wrappedBuffer((byte[])continuationToken));
        }

        @ConstructorProperties(value={"requestId", "segment", "entries", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        public TableEntriesRead(long requestId, String segment, TableEntries entries, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.entries = entries;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public TableEntries getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntriesRead)) {
                return false;
            }
            TableEntriesRead other = (TableEntriesRead)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            TableEntries this$entries = this.getEntries();
            TableEntries other$entries = other.getEntries();
            if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            TableEntries $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableEntriesRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", entries=" + this.getEntries() + ", continuationToken=" + this.getContinuationToken() + ")";
        }
    }

    public static final class ReadTableEntries
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE_ENTRIES;
        final long requestId;
        final String segment;
        final String delegationToken;
        final int suggestedEntryCount;
        final ByteBuf continuationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTableEntries(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.suggestedEntryCount);
            out.writeInt(this.continuationToken.readableBytes());
            if (this.continuationToken.readableBytes() != 0) {
                this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
            }
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int suggestedEntryCount = in.readInt();
            int dataLength = in.readInt();
            if (length < dataLength + 8 + segment.getBytes(StandardCharsets.UTF_8).length + delegationToken.getBytes(StandardCharsets.UTF_8).length + 8) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + dataLength);
            }
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new ReadTableEntries(requestId, segment, delegationToken, suggestedEntryCount, Unpooled.wrappedBuffer((byte[])continuationToken));
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "suggestedEntryCount", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        public ReadTableEntries(long requestId, String segment, String delegationToken, int suggestedEntryCount, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.suggestedEntryCount = suggestedEntryCount;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getSuggestedEntryCount() {
            return this.suggestedEntryCount;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTableEntries)) {
                return false;
            }
            ReadTableEntries other = (ReadTableEntries)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            if (this.getSuggestedEntryCount() != other.getSuggestedEntryCount()) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            result = result * 59 + this.getSuggestedEntryCount();
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ReadTableEntries(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", suggestedEntryCount=" + this.getSuggestedEntryCount() + ", continuationToken=" + this.getContinuationToken() + ")";
        }
    }

    public static final class TableKeysRead
    implements Reply,
    WireCommand {
        public static final Function<Integer, Integer> GET_HEADER_BYTES = keyCount -> 12 + 8 * keyCount + 4;
        final WireCommandType type = WireCommandType.TABLE_KEYS_READ;
        final long requestId;
        final String segment;
        final List<TableKey> keys;
        final ByteBuf continuationToken;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeysRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
            out.writeInt(this.continuationToken.readableBytes());
            this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            int keyByteCount = 0;
            for (int i = 0; i < numberOfKeys; ++i) {
                TableKey k = TableKey.readFrom((DataInput)in, in.available());
                keys.add(k);
                keyByteCount += 16 + k.getData().readableBytes();
            }
            int dataLength = in.readInt();
            if (length < dataLength + 8 + segment.getBytes(StandardCharsets.UTF_8).length + 4 + keyByteCount) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + dataLength);
            }
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new TableKeysRead(requestId, segment, keys, Unpooled.wrappedBuffer((byte[])continuationToken));
        }

        @ConstructorProperties(value={"requestId", "segment", "keys", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        public TableKeysRead(long requestId, String segment, List<TableKey> keys, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.keys = keys;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeysRead)) {
                return false;
            }
            TableKeysRead other = (TableKeysRead)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableKeysRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ", continuationToken=" + this.getContinuationToken() + ")";
        }
    }

    public static final class ReadTableKeys
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE_KEYS;
        final long requestId;
        final String segment;
        final String delegationToken;
        final int suggestedKeyCount;
        final ByteBuf continuationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTableKeys(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.suggestedKeyCount);
            out.writeInt(this.continuationToken.readableBytes());
            if (this.continuationToken.readableBytes() != 0) {
                this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
            }
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int suggestedKeyCount = in.readInt();
            int dataLength = in.readInt();
            if (length < dataLength + 8 + segment.getBytes(StandardCharsets.UTF_8).length + delegationToken.getBytes(StandardCharsets.UTF_8).length + 8) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + dataLength);
            }
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new ReadTableKeys(requestId, segment, delegationToken, suggestedKeyCount, Unpooled.wrappedBuffer((byte[])continuationToken));
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "suggestedKeyCount", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        public ReadTableKeys(long requestId, String segment, String delegationToken, int suggestedKeyCount, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.suggestedKeyCount = suggestedKeyCount;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getSuggestedKeyCount() {
            return this.suggestedKeyCount;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTableKeys)) {
                return false;
            }
            ReadTableKeys other = (ReadTableKeys)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            if (this.getSuggestedKeyCount() != other.getSuggestedKeyCount()) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            result = result * 59 + this.getSuggestedKeyCount();
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ReadTableKeys(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", suggestedKeyCount=" + this.getSuggestedKeyCount() + ", continuationToken=" + this.getContinuationToken() + ")";
        }
    }

    public static final class TableRead
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_READ;
        final long requestId;
        final String segment;
        final TableEntries entries;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            this.entries.writeFields(out);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            return new TableRead(requestId, segment, entries);
        }

        @ConstructorProperties(value={"requestId", "segment", "entries"})
        @SuppressFBWarnings(justification="generated code")
        public TableRead(long requestId, String segment, TableEntries entries) {
            this.requestId = requestId;
            this.segment = segment;
            this.entries = entries;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public TableEntries getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableRead)) {
                return false;
            }
            TableRead other = (TableRead)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            TableEntries this$entries = this.getEntries();
            TableEntries other$entries = other.getEntries();
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            TableEntries $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", entries=" + this.getEntries() + ")";
        }
    }

    public static final class ReadTable
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE;
        final long requestId;
        final String segment;
        final String delegationToken;
        final List<TableKey> keys;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTable(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                keys.add(TableKey.readFrom((DataInput)in, in.available()));
            }
            return new ReadTable(requestId, segment, delegationToken, keys);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "keys"})
        @SuppressFBWarnings(justification="generated code")
        public ReadTable(long requestId, String segment, String delegationToken, List<TableKey> keys) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.keys = keys;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTable)) {
                return false;
            }
            ReadTable other = (ReadTable)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ReadTable(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static final class TableKeysRemoved
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEYS_REMOVED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeysRemoved(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new TableKeysRemoved(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public TableKeysRemoved(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeysRemoved)) {
                return false;
            }
            TableKeysRemoved other = (TableKeysRemoved)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableKeysRemoved(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class RemoveTableKeys
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.REMOVE_TABLE_KEYS;
        final long requestId;
        final String segment;
        final String delegationToken;
        final List<TableKey> keys;

        @Override
        public void process(RequestProcessor cp) {
            cp.removeTableKeys(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                keys.add(TableKey.readFrom((DataInput)in, in.available()));
            }
            return new RemoveTableKeys(requestId, segment, delegationToken, keys);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "keys"})
        @SuppressFBWarnings(justification="generated code")
        public RemoveTableKeys(long requestId, String segment, String delegationToken, List<TableKey> keys) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.keys = keys;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveTableKeys)) {
                return false;
            }
            RemoveTableKeys other = (RemoveTableKeys)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.RemoveTableKeys(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ")";
        }
    }

    public static final class TableEntriesUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_ENTRIES_UPDATED;
        final long requestId;
        final List<Long> updatedVersions;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableEntriesUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeInt(this.updatedVersions.size());
            for (long version : this.updatedVersions) {
                out.writeLong(version);
            }
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            int numberOfEntries = in.readInt();
            ArrayList<Long> updatedVersions = new ArrayList<Long>(numberOfEntries);
            for (int i = 0; i < numberOfEntries; ++i) {
                updatedVersions.add(in.readLong());
            }
            return new TableEntriesUpdated(requestId, updatedVersions);
        }

        @ConstructorProperties(value={"requestId", "updatedVersions"})
        @SuppressFBWarnings(justification="generated code")
        public TableEntriesUpdated(long requestId, List<Long> updatedVersions) {
            this.requestId = requestId;
            this.updatedVersions = updatedVersions;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<Long> getUpdatedVersions() {
            return this.updatedVersions;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntriesUpdated)) {
                return false;
            }
            TableEntriesUpdated other = (TableEntriesUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            List<Long> this$updatedVersions = this.getUpdatedVersions();
            List<Long> other$updatedVersions = other.getUpdatedVersions();
            return !(this$updatedVersions == null ? other$updatedVersions != null : !((Object)this$updatedVersions).equals(other$updatedVersions));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            List<Long> $updatedVersions = this.getUpdatedVersions();
            result = result * 59 + ($updatedVersions == null ? 43 : ((Object)$updatedVersions).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TableEntriesUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", updatedVersions=" + this.getUpdatedVersions() + ")";
        }
    }

    public static final class UpdateTableEntries
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_TABLE_ENTRIES;
        final long requestId;
        final String segment;
        final String delegationToken;
        final TableEntries tableEntries;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateTableEntries(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            this.tableEntries.writeFields(out);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            return new UpdateTableEntries(requestId, segment, delegationToken, entries);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "tableEntries"})
        @SuppressFBWarnings(justification="generated code")
        public UpdateTableEntries(long requestId, String segment, String delegationToken, TableEntries tableEntries) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.tableEntries = tableEntries;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public TableEntries getTableEntries() {
            return this.tableEntries;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableEntries)) {
                return false;
            }
            UpdateTableEntries other = (UpdateTableEntries)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            TableEntries this$tableEntries = this.getTableEntries();
            TableEntries other$tableEntries = other.getTableEntries();
            return !(this$tableEntries == null ? other$tableEntries != null : !((Object)this$tableEntries).equals(other$tableEntries));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            TableEntries $tableEntries = this.getTableEntries();
            result = result * 59 + ($tableEntries == null ? 43 : ((Object)$tableEntries).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.UpdateTableEntries(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", tableEntries=" + this.getTableEntries() + ")";
        }
    }

    public static final class AuthTokenCheckFailed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.AUTH_TOKEN_CHECK_FAILED;
        final long requestId;
        final String serverStackTrace;
        final ErrorCode errorCode;

        public AuthTokenCheckFailed(long requestId, String serverStackTrace) {
            this(requestId, serverStackTrace, ErrorCode.UNSPECIFIED);
        }

        public AuthTokenCheckFailed(long requestId, String stackTrace, ErrorCode errorCode) {
            this.requestId = requestId;
            this.serverStackTrace = stackTrace;
            this.errorCode = errorCode;
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            int errorCode = in.available() >= 4 ? in.readInt() : -1;
            return new AuthTokenCheckFailed(requestId, serverStackTrace, ErrorCode.valueOf(errorCode));
        }

        public boolean isTokenExpired() {
            return this.errorCode == ErrorCode.TOKEN_EXPIRED;
        }

        @Override
        public void process(ReplyProcessor cp) {
            cp.authTokenCheckFailed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.serverStackTrace);
            out.writeInt(this.errorCode.getCode());
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthTokenCheckFailed)) {
                return false;
            }
            AuthTokenCheckFailed other = (AuthTokenCheckFailed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            ErrorCode this$errorCode = this.getErrorCode();
            ErrorCode other$errorCode = other.getErrorCode();
            return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            ErrorCode $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.AuthTokenCheckFailed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", serverStackTrace=" + this.getServerStackTrace() + ", errorCode=" + (Object)((Object)this.getErrorCode()) + ")";
        }

        public static enum ErrorCode {
            UNSPECIFIED(-1),
            TOKEN_CHECK_FAILED(0),
            TOKEN_EXPIRED(1);

            private static final Map<Integer, ErrorCode> OBJECTS_BY_CODE;
            private final int code;

            private ErrorCode(int code) {
                this.code = code;
            }

            public static ErrorCode valueOf(int code) {
                return OBJECTS_BY_CODE.getOrDefault(code, TOKEN_CHECK_FAILED);
            }

            public int getCode() {
                return this.code;
            }

            static {
                OBJECTS_BY_CODE = new HashMap<Integer, ErrorCode>();
                for (ErrorCode errorCode : ErrorCode.values()) {
                    OBJECTS_BY_CODE.put(errorCode.code, errorCode);
                }
            }
        }
    }

    public static final class KeepAlive
    implements Request,
    Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.KEEP_ALIVE;

        @Override
        public void process(ReplyProcessor cp) {
            cp.keepAlive(this);
        }

        @Override
        public void process(RequestProcessor cp) {
            cp.keepAlive(this);
        }

        @Override
        public void writeFields(DataOutput out) {
        }

        public static WireCommand readFrom(DataInput in, int length) {
            return new KeepAlive();
        }

        @Override
        public long getRequestId() {
            return -1L;
        }

        @Override
        public boolean mustLog() {
            return false;
        }

        @SuppressFBWarnings(justification="generated code")
        public KeepAlive() {
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeepAlive)) {
                return false;
            }
            KeepAlive other = (KeepAlive)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.KeepAlive(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static final class SegmentDeleted
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_DELETED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentDeleted(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentDeleted(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentDeleted(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentDeleted)) {
                return false;
            }
            SegmentDeleted other = (SegmentDeleted)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentDeleted(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class DeleteTableSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.DELETE_TABLE_SEGMENT;
        final long requestId;
        final String segment;
        final boolean mustBeEmpty;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.deleteTableSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeBoolean(this.mustBeEmpty);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            boolean mustBeEmpty = in.readBoolean();
            String delegationToken = in.readUTF();
            return new DeleteTableSegment(requestId, segment, mustBeEmpty, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "mustBeEmpty", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public DeleteTableSegment(long requestId, String segment, boolean mustBeEmpty, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.mustBeEmpty = mustBeEmpty;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isMustBeEmpty() {
            return this.mustBeEmpty;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteTableSegment)) {
                return false;
            }
            DeleteTableSegment other = (DeleteTableSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.isMustBeEmpty() != other.isMustBeEmpty()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + (this.isMustBeEmpty() ? 79 : 97);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.DeleteTableSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", mustBeEmpty=" + this.isMustBeEmpty() + ")";
        }
    }

    public static final class DeleteSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.DELETE_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.deleteSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new DeleteSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public DeleteSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteSegment)) {
                return false;
            }
            DeleteSegment other = (DeleteSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.DeleteSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SegmentTruncated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_TRUNCATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentTruncated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentTruncated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentTruncated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentTruncated)) {
                return false;
            }
            SegmentTruncated other = (SegmentTruncated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentTruncated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class TruncateSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.TRUNCATE_SEGMENT;
        final long requestId;
        final String segment;
        final long truncationOffset;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.truncateSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.truncationOffset);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            long truncationOffset = in.readLong();
            String delegationToken = in.readUTF();
            return new TruncateSegment(requestId, segment, truncationOffset, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "truncationOffset", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public TruncateSegment(long requestId, String segment, long truncationOffset, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.truncationOffset = truncationOffset;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getTruncationOffset() {
            return this.truncationOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TruncateSegment)) {
                return false;
            }
            TruncateSegment other = (TruncateSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getTruncationOffset() != other.getTruncationOffset()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $truncationOffset = this.getTruncationOffset();
            result = result * 59 + (int)($truncationOffset >>> 32 ^ $truncationOffset);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.TruncateSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", truncationOffset=" + this.getTruncationOffset() + ")";
        }
    }

    public static final class SegmentSealed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_SEALED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentSealed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentSealed(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentSealed(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentSealed)) {
                return false;
            }
            SegmentSealed other = (SegmentSealed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentSealed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SealTableSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.SEAL_TABLE_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.sealTableSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new SealTableSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public SealTableSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SealTableSegment)) {
                return false;
            }
            SealTableSegment other = (SealTableSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SealTableSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SealSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.SEAL_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.sealSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new SealSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public SealSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SealSegment)) {
                return false;
            }
            SealSegment other = (SealSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SealSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SegmentsMerged
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENTS_MERGED;
        final long requestId;
        final String target;
        final String source;
        final long newTargetWriteOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentsMerged(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.target);
            out.writeUTF(this.source);
            out.writeLong(this.newTargetWriteOffset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String target = in.readUTF();
            String source = in.readUTF();
            long newTargetWriteOffset = in.available() > 0 ? in.readLong() : -1L;
            return new SegmentsMerged(requestId, target, source, newTargetWriteOffset);
        }

        @ConstructorProperties(value={"requestId", "target", "source", "newTargetWriteOffset"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentsMerged(long requestId, String target, String source, long newTargetWriteOffset) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.newTargetWriteOffset = newTargetWriteOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getTarget() {
            return this.target;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getNewTargetWriteOffset() {
            return this.newTargetWriteOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentsMerged)) {
                return false;
            }
            SegmentsMerged other = (SegmentsMerged)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            return this.getNewTargetWriteOffset() == other.getNewTargetWriteOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            long $newTargetWriteOffset = this.getNewTargetWriteOffset();
            result = result * 59 + (int)($newTargetWriteOffset >>> 32 ^ $newTargetWriteOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentsMerged(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", target=" + this.getTarget() + ", source=" + this.getSource() + ", newTargetWriteOffset=" + this.getNewTargetWriteOffset() + ")";
        }
    }

    public static final class MergeTableSegments
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.MERGE_TABLE_SEGMENTS;
        final long requestId;
        final String target;
        final String source;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.mergeTableSegments(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.target);
            out.writeUTF(this.source);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String target = in.readUTF();
            String source = in.readUTF();
            String delegationToken = in.readUTF();
            return new MergeTableSegments(requestId, target, source, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "target", "source", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public MergeTableSegments(long requestId, String target, String source, String delegationToken) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getTarget() {
            return this.target;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeTableSegments)) {
                return false;
            }
            MergeTableSegments other = (MergeTableSegments)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.MergeTableSegments(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", target=" + this.getTarget() + ", source=" + this.getSource() + ")";
        }
    }

    public static final class MergeSegments
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.MERGE_SEGMENTS;
        final long requestId;
        final String target;
        final String source;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.mergeSegments(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.target);
            out.writeUTF(this.source);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String target = in.readUTF();
            String source = in.readUTF();
            String delegationToken = in.readUTF();
            return new MergeSegments(requestId, target, source, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "target", "source", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public MergeSegments(long requestId, String target, String source, String delegationToken) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getTarget() {
            return this.target;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeSegments)) {
                return false;
            }
            MergeSegments other = (MergeSegments)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.MergeSegments(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", target=" + this.getTarget() + ", source=" + this.getSource() + ")";
        }
    }

    public static final class SegmentPolicyUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_POLICY_UPDATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentPolicyUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentPolicyUpdated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentPolicyUpdated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentPolicyUpdated)) {
                return false;
            }
            SegmentPolicyUpdated other = (SegmentPolicyUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentPolicyUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class UpdateSegmentPolicy
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_SEGMENT_POLICY;
        final long requestId;
        final String segment;
        final byte scaleType;
        final int targetRate;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateSegmentPolicy(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.targetRate);
            out.writeByte(this.scaleType);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            int desiredRate = in.readInt();
            byte scaleType = in.readByte();
            String delegationToken = in.readUTF();
            return new UpdateSegmentPolicy(requestId, segment, scaleType, desiredRate, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "scaleType", "targetRate", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public UpdateSegmentPolicy(long requestId, String segment, byte scaleType, int targetRate, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.scaleType = scaleType;
            this.targetRate = targetRate;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte getScaleType() {
            return this.scaleType;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getTargetRate() {
            return this.targetRate;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSegmentPolicy)) {
                return false;
            }
            UpdateSegmentPolicy other = (UpdateSegmentPolicy)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getScaleType() != other.getScaleType()) {
                return false;
            }
            if (this.getTargetRate() != other.getTargetRate()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + this.getScaleType();
            result = result * 59 + this.getTargetRate();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.UpdateSegmentPolicy(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", scaleType=" + this.getScaleType() + ", targetRate=" + this.getTargetRate() + ")";
        }
    }

    public static final class SegmentCreated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_CREATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentCreated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentCreated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentCreated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentCreated)) {
                return false;
            }
            SegmentCreated other = (SegmentCreated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentCreated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class CreateTableSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.CREATE_TABLE_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.createTableSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new CreateTableSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public CreateTableSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateTableSegment)) {
                return false;
            }
            CreateTableSegment other = (CreateTableSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.CreateTableSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class CreateSegment
    implements Request,
    WireCommand {
        public static final byte NO_SCALE = ScaleType.NoScaling.getValue();
        public static final byte IN_KBYTES_PER_SEC = ScaleType.Throughput.getValue();
        public static final byte IN_EVENTS_PER_SEC = ScaleType.EventRate.getValue();
        final WireCommandType type = WireCommandType.CREATE_SEGMENT;
        final long requestId;
        final String segment;
        final byte scaleType;
        final int targetRate;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.createSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.targetRate);
            out.writeByte(this.scaleType);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            int desiredRate = in.readInt();
            byte scaleType = in.readByte();
            String delegationToken = in.readUTF();
            return new CreateSegment(requestId, segment, scaleType, desiredRate, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "scaleType", "targetRate", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public CreateSegment(long requestId, String segment, byte scaleType, int targetRate, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.scaleType = scaleType;
            this.targetRate = targetRate;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte getScaleType() {
            return this.scaleType;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getTargetRate() {
            return this.targetRate;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateSegment)) {
                return false;
            }
            CreateSegment other = (CreateSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getScaleType() != other.getScaleType()) {
                return false;
            }
            if (this.getTargetRate() != other.getTargetRate()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + this.getScaleType();
            result = result * 59 + this.getTargetRate();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.CreateSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", scaleType=" + this.getScaleType() + ", targetRate=" + this.getTargetRate() + ")";
        }
    }

    public static final class StreamSegmentInfo
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.STREAM_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final boolean exists;
        final boolean isSealed;
        final boolean isDeleted;
        final long lastModified;
        final long writeOffset;
        final long startOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.streamSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeBoolean(this.exists);
            out.writeBoolean(this.isSealed);
            out.writeBoolean(this.isDeleted);
            out.writeLong(this.lastModified);
            out.writeLong(this.writeOffset);
            out.writeLong(this.startOffset);
        }

        public static <T extends InputStream> WireCommand readFrom(T in, int length) throws IOException {
            long requestId = ((DataInput)((Object)in)).readLong();
            String segmentName = ((DataInput)((Object)in)).readUTF();
            boolean exists = ((DataInput)((Object)in)).readBoolean();
            boolean isSealed = ((DataInput)((Object)in)).readBoolean();
            boolean isDeleted = ((DataInput)((Object)in)).readBoolean();
            long lastModified = ((DataInput)((Object)in)).readLong();
            long segmentLength = ((DataInput)((Object)in)).readLong();
            long startOffset = 0L;
            if (in.available() >= 8) {
                startOffset = ((DataInput)((Object)in)).readLong();
            }
            return new StreamSegmentInfo(requestId, segmentName, exists, isSealed, isDeleted, lastModified, segmentLength, startOffset);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "exists", "isSealed", "isDeleted", "lastModified", "writeOffset", "startOffset"})
        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentInfo(long requestId, String segmentName, boolean exists, boolean isSealed, boolean isDeleted, long lastModified, long writeOffset, long startOffset) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.exists = exists;
            this.isSealed = isSealed;
            this.isDeleted = isDeleted;
            this.lastModified = lastModified;
            this.writeOffset = writeOffset;
            this.startOffset = startOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean exists() {
            return this.exists;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isSealed() {
            return this.isSealed;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastModified() {
            return this.lastModified;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getWriteOffset() {
            return this.writeOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StreamSegmentInfo)) {
                return false;
            }
            StreamSegmentInfo other = (StreamSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            if (this.exists() != other.exists()) {
                return false;
            }
            if (this.isSealed() != other.isSealed()) {
                return false;
            }
            if (this.isDeleted() != other.isDeleted()) {
                return false;
            }
            if (this.getLastModified() != other.getLastModified()) {
                return false;
            }
            if (this.getWriteOffset() != other.getWriteOffset()) {
                return false;
            }
            return this.getStartOffset() == other.getStartOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            result = result * 59 + (this.exists() ? 79 : 97);
            result = result * 59 + (this.isSealed() ? 79 : 97);
            result = result * 59 + (this.isDeleted() ? 79 : 97);
            long $lastModified = this.getLastModified();
            result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
            long $writeOffset = this.getWriteOffset();
            result = result * 59 + (int)($writeOffset >>> 32 ^ $writeOffset);
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.StreamSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", exists=" + this.exists() + ", isSealed=" + this.isSealed() + ", isDeleted=" + this.isDeleted() + ", lastModified=" + this.getLastModified() + ", writeOffset=" + this.getWriteOffset() + ", startOffset=" + this.getStartOffset() + ")";
        }
    }

    public static final class GetStreamSegmentInfo
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.GET_STREAM_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.getStreamSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new GetStreamSegmentInfo(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public GetStreamSegmentInfo(long requestId, String segmentName, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetStreamSegmentInfo)) {
                return false;
            }
            GetStreamSegmentInfo other = (GetStreamSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.GetStreamSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ")";
        }
    }

    public static final class SegmentAttributeUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ATTRIBUTE_UPDATED;
        final long requestId;
        final boolean success;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAttributeUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeBoolean(this.success);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            boolean success = in.readBoolean();
            return new SegmentAttributeUpdated(requestId, success);
        }

        @ConstructorProperties(value={"requestId", "success"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentAttributeUpdated(long requestId, boolean success) {
            this.requestId = requestId;
            this.success = success;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isSuccess() {
            return this.success;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAttributeUpdated)) {
                return false;
            }
            SegmentAttributeUpdated other = (SegmentAttributeUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            return this.isSuccess() == other.isSuccess();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentAttributeUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", success=" + this.isSuccess() + ")";
        }
    }

    public static final class UpdateSegmentAttribute
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_SEGMENT_ATTRIBUTE;
        final long requestId;
        final String segmentName;
        final UUID attributeId;
        final long newValue;
        final long expectedValue;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateSegmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeLong(this.attributeId.getMostSignificantBits());
            out.writeLong(this.attributeId.getLeastSignificantBits());
            out.writeLong(this.newValue);
            out.writeLong(this.expectedValue);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID attributeId = new UUID(in.readLong(), in.readLong());
            long newValue = in.readLong();
            long excpecteValue = in.readLong();
            String delegationToken = in.readUTF();
            return new UpdateSegmentAttribute(requestId, segment, attributeId, newValue, excpecteValue, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "attributeId", "newValue", "expectedValue", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public UpdateSegmentAttribute(long requestId, String segmentName, UUID attributeId, long newValue, long expectedValue, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.attributeId = attributeId;
            this.newValue = newValue;
            this.expectedValue = expectedValue;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getAttributeId() {
            return this.attributeId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getNewValue() {
            return this.newValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getExpectedValue() {
            return this.expectedValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSegmentAttribute)) {
                return false;
            }
            UpdateSegmentAttribute other = (UpdateSegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            UUID this$attributeId = this.getAttributeId();
            UUID other$attributeId = other.getAttributeId();
            if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
                return false;
            }
            if (this.getNewValue() != other.getNewValue()) {
                return false;
            }
            if (this.getExpectedValue() != other.getExpectedValue()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            UUID $attributeId = this.getAttributeId();
            result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
            long $newValue = this.getNewValue();
            result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
            long $expectedValue = this.getExpectedValue();
            result = result * 59 + (int)($expectedValue >>> 32 ^ $expectedValue);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.UpdateSegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", attributeId=" + this.getAttributeId() + ", newValue=" + this.getNewValue() + ", expectedValue=" + this.getExpectedValue() + ")";
        }
    }

    public static final class SegmentAttribute
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ATTRIBUTE;
        final long requestId;
        final long value;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeLong(this.value);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            long value = in.readLong();
            return new SegmentAttribute(requestId, value);
        }

        @ConstructorProperties(value={"requestId", "value"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentAttribute(long requestId, long value) {
            this.requestId = requestId;
            this.value = value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAttribute)) {
                return false;
            }
            SegmentAttribute other = (SegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            return this.getValue() == other.getValue();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            long $value = this.getValue();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class GetSegmentAttribute
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.GET_SEGMENT_ATTRIBUTE;
        final long requestId;
        final String segmentName;
        final UUID attributeId;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.getSegmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeLong(this.attributeId.getMostSignificantBits());
            out.writeLong(this.attributeId.getLeastSignificantBits());
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID attributeId = new UUID(in.readLong(), in.readLong());
            String delegationToken = in.readUTF();
            return new GetSegmentAttribute(requestId, segment, attributeId, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "attributeId", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public GetSegmentAttribute(long requestId, String segmentName, UUID attributeId, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.attributeId = attributeId;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getAttributeId() {
            return this.attributeId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetSegmentAttribute)) {
                return false;
            }
            GetSegmentAttribute other = (GetSegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            UUID this$attributeId = this.getAttributeId();
            UUID other$attributeId = other.getAttributeId();
            if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            UUID $attributeId = this.getAttributeId();
            result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.GetSegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", attributeId=" + this.getAttributeId() + ")";
        }
    }

    public static final class SegmentRead
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_READ;
        final String segment;
        final long offset;
        final boolean atTail;
        final boolean endOfSegment;
        final ByteBuffer data;
        final long requestId;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeUTF(this.segment);
            out.writeLong(this.offset);
            out.writeBoolean(this.atTail);
            out.writeBoolean(this.endOfSegment);
            int dataLength = this.data.remaining();
            out.writeInt(dataLength);
            out.write(this.data.array(), this.data.arrayOffset() + this.data.position(), this.data.remaining());
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            String segment = in.readUTF();
            long offset = in.readLong();
            boolean atTail = in.readBoolean();
            boolean endOfSegment = in.readBoolean();
            int dataLength = in.readInt();
            if (dataLength > length) {
                throw new BufferOverflowException();
            }
            byte[] data = new byte[dataLength];
            in.readFully(data);
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentRead(segment, offset, atTail, endOfSegment, ByteBuffer.wrap(data), requestId);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"segment", "offset", "atTail", "endOfSegment", "data", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentRead(String segment, long offset, boolean atTail, boolean endOfSegment, ByteBuffer data, long requestId) {
            this.segment = segment;
            this.offset = offset;
            this.atTail = atTail;
            this.endOfSegment = endOfSegment;
            this.data = data;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isAtTail() {
            return this.atTail;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean isEndOfSegment() {
            return this.endOfSegment;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuffer getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentRead)) {
                return false;
            }
            SegmentRead other = (SegmentRead)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.isAtTail() != other.isAtTail()) {
                return false;
            }
            if (this.isEndOfSegment() != other.isEndOfSegment()) {
                return false;
            }
            ByteBuffer this$data = this.getData();
            ByteBuffer other$data = other.getData();
            if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            result = result * 59 + (this.isAtTail() ? 79 : 97);
            result = result * 59 + (this.isEndOfSegment() ? 79 : 97);
            ByteBuffer $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentRead(type=" + (Object)((Object)this.getType()) + ", segment=" + this.getSegment() + ", offset=" + this.getOffset() + ", atTail=" + this.isAtTail() + ", endOfSegment=" + this.isEndOfSegment() + ", data=" + this.getData() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class ReadSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_SEGMENT;
        final String segment;
        final long offset;
        final int suggestedLength;
        final String delegationToken;
        final long requestId;

        @Override
        public void process(RequestProcessor cp) {
            cp.readSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeUTF(this.segment);
            out.writeLong(this.offset);
            out.writeInt(this.suggestedLength);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            String segment = in.readUTF();
            long offset = in.readLong();
            int suggestedLength = in.readInt();
            String delegationToken = in.readUTF();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ReadSegment(segment, offset, suggestedLength, delegationToken, requestId);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"segment", "offset", "suggestedLength", "delegationToken", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        public ReadSegment(String segment, long offset, int suggestedLength, String delegationToken, long requestId) {
            this.segment = segment;
            this.offset = offset;
            this.suggestedLength = suggestedLength;
            this.delegationToken = delegationToken;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getSuggestedLength() {
            return this.suggestedLength;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadSegment)) {
                return false;
            }
            ReadSegment other = (ReadSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.getSuggestedLength() != other.getSuggestedLength()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            result = result * 59 + this.getSuggestedLength();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ReadSegment(type=" + (Object)((Object)this.getType()) + ", segment=" + this.getSegment() + ", offset=" + this.getOffset() + ", suggestedLength=" + this.getSuggestedLength() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class ConditionalCheckFailed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.CONDITIONAL_CHECK_FAILED;
        final UUID writerId;
        final long eventNumber;
        final long requestId;

        @Override
        public void process(ReplyProcessor cp) {
            cp.conditionalCheckFailed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long offset = in.readLong();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ConditionalCheckFailed(writerId, offset, requestId);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        public ConditionalCheckFailed(UUID writerId, long eventNumber, long requestId) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalCheckFailed)) {
                return false;
            }
            ConditionalCheckFailed other = (ConditionalCheckFailed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ConditionalCheckFailed(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class DataAppended
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.DATA_APPENDED;
        final long requestId;
        final UUID writerId;
        final long eventNumber;
        final long previousEventNumber;
        final long currentSegmentWriteOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.dataAppended(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.previousEventNumber);
            out.writeLong(this.requestId);
            out.writeLong(this.currentSegmentWriteOffset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            long previousEventNumber = in.available() >= 8 ? in.readLong() : -1L;
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            long currentSegmentWriteOffset = in.available() >= 8 ? in.readLong() : -1L;
            return new DataAppended(requestId, writerId, eventNumber, previousEventNumber, currentSegmentWriteOffset);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"requestId", "writerId", "eventNumber", "previousEventNumber", "currentSegmentWriteOffset"})
        @SuppressFBWarnings(justification="generated code")
        public DataAppended(long requestId, UUID writerId, long eventNumber, long previousEventNumber, long currentSegmentWriteOffset) {
            this.requestId = requestId;
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.previousEventNumber = previousEventNumber;
            this.currentSegmentWriteOffset = currentSegmentWriteOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getPreviousEventNumber() {
            return this.previousEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getCurrentSegmentWriteOffset() {
            return this.currentSegmentWriteOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataAppended)) {
                return false;
            }
            DataAppended other = (DataAppended)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            if (this.getPreviousEventNumber() != other.getPreviousEventNumber()) {
                return false;
            }
            return this.getCurrentSegmentWriteOffset() == other.getCurrentSegmentWriteOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $previousEventNumber = this.getPreviousEventNumber();
            result = result * 59 + (int)($previousEventNumber >>> 32 ^ $previousEventNumber);
            long $currentSegmentWriteOffset = this.getCurrentSegmentWriteOffset();
            result = result * 59 + (int)($currentSegmentWriteOffset >>> 32 ^ $currentSegmentWriteOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.DataAppended(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", previousEventNumber=" + this.getPreviousEventNumber() + ", currentSegmentWriteOffset=" + this.getCurrentSegmentWriteOffset() + ")";
        }
    }

    public static final class AppendSetup
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.APPEND_SETUP;
        final long requestId;
        final String segment;
        final UUID writerId;
        final long lastEventNumber;

        @Override
        public void process(ReplyProcessor cp) {
            cp.appendSetup(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.lastEventNumber);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long lastEventNumber = in.readLong();
            return new AppendSetup(requestId, segment, writerId, lastEventNumber);
        }

        @ConstructorProperties(value={"requestId", "segment", "writerId", "lastEventNumber"})
        @SuppressFBWarnings(justification="generated code")
        public AppendSetup(long requestId, String segment, UUID writerId, long lastEventNumber) {
            this.requestId = requestId;
            this.segment = segment;
            this.writerId = writerId;
            this.lastEventNumber = lastEventNumber;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendSetup)) {
                return false;
            }
            AppendSetup other = (AppendSetup)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            return this.getLastEventNumber() == other.getLastEventNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.AppendSetup(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", writerId=" + this.getWriterId() + ", lastEventNumber=" + this.getLastEventNumber() + ")";
        }
    }

    public static final class ConditionalAppend
    implements WireCommand,
    Request {
        final WireCommandType type = WireCommandType.CONDITIONAL_APPEND;
        final UUID writerId;
        final long eventNumber;
        final long expectedOffset;
        final Event event;
        final long requestId;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.expectedOffset);
            this.event.writeFields(out);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            long expectedOffset = in.readLong();
            Event event = ConditionalAppend.readEvent(in, length);
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ConditionalAppend(writerId, eventNumber, expectedOffset, event, requestId);
        }

        private static Event readEvent(ByteBufInputStream in, int length) throws IOException {
            int typeCode = in.readInt();
            if (typeCode != WireCommandType.EVENT.getCode()) {
                throw new InvalidMessageException("Was expecting EVENT but found: " + typeCode);
            }
            int eventLength = in.readInt();
            if (eventLength > length - 8) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + eventLength);
            }
            byte[] msg = new byte[eventLength];
            in.readFully(msg);
            return new Event(Unpooled.wrappedBuffer((byte[])msg));
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public void process(RequestProcessor cp) {
            throw new UnsupportedOperationException();
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "expectedOffset", "event", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        public ConditionalAppend(UUID writerId, long eventNumber, long expectedOffset, Event event, long requestId) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.expectedOffset = expectedOffset;
            this.event = event;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getExpectedOffset() {
            return this.expectedOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public Event getEvent() {
            return this.event;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalAppend)) {
                return false;
            }
            ConditionalAppend other = (ConditionalAppend)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            if (this.getExpectedOffset() != other.getExpectedOffset()) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $expectedOffset = this.getExpectedOffset();
            result = result * 59 + (int)($expectedOffset >>> 32 ^ $expectedOffset);
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.ConditionalAppend(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", expectedOffset=" + this.getExpectedOffset() + ", event=" + this.getEvent() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class AppendBlockEnd
    implements WireCommand {
        final WireCommandType type = WireCommandType.APPEND_BLOCK_END;
        final UUID writerId;
        final int sizeOfWholeEvents;
        final ByteBuf data;
        final int numEvents;
        final long lastEventNumber;
        final long requestId;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeInt(this.sizeOfWholeEvents);
            if (this.data == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.data.readableBytes());
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
            }
            out.writeInt(this.numEvents);
            out.writeLong(this.lastEventNumber);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            byte[] data;
            UUID writerId = new UUID(in.readLong(), in.readLong());
            int sizeOfHeaderlessAppends = in.readInt();
            int dataLength = in.readInt();
            if (dataLength > 0) {
                data = new byte[dataLength];
                in.readFully(data);
            } else {
                data = new byte[]{};
            }
            int numEvents = in.readInt();
            long lastEventNumber = in.readLong();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new AppendBlockEnd(writerId, sizeOfHeaderlessAppends, Unpooled.wrappedBuffer((byte[])data), numEvents, lastEventNumber, requestId);
        }

        @ConstructorProperties(value={"writerId", "sizeOfWholeEvents", "data", "numEvents", "lastEventNumber", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        public AppendBlockEnd(UUID writerId, int sizeOfWholeEvents, ByteBuf data, int numEvents, long lastEventNumber, long requestId) {
            this.writerId = writerId;
            this.sizeOfWholeEvents = sizeOfWholeEvents;
            this.data = data;
            this.numEvents = numEvents;
            this.lastEventNumber = lastEventNumber;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getSizeOfWholeEvents() {
            return this.sizeOfWholeEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getNumEvents() {
            return this.numEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendBlockEnd)) {
                return false;
            }
            AppendBlockEnd other = (AppendBlockEnd)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getSizeOfWholeEvents() != other.getSizeOfWholeEvents()) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            if (this.getNumEvents() != other.getNumEvents()) {
                return false;
            }
            if (this.getLastEventNumber() != other.getLastEventNumber()) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            result = result * 59 + this.getSizeOfWholeEvents();
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            result = result * 59 + this.getNumEvents();
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.AppendBlockEnd(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", sizeOfWholeEvents=" + this.getSizeOfWholeEvents() + ", data=" + this.getData() + ", numEvents=" + this.getNumEvents() + ", lastEventNumber=" + this.getLastEventNumber() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class AppendBlock
    implements WireCommand {
        final WireCommandType type = WireCommandType.APPEND_BLOCK;
        final UUID writerId;
        final ByteBuf data;

        AppendBlock(UUID writerId) {
            this.writerId = writerId;
            this.data = Unpooled.EMPTY_BUFFER;
        }

        AppendBlock(UUID writerId, ByteBuf data) {
            this.writerId = writerId;
            this.data = data;
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            byte[] data = new byte[length - 16];
            in.readFully(data);
            return new AppendBlock(writerId, Unpooled.wrappedBuffer((byte[])data));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendBlock)) {
                return false;
            }
            AppendBlock other = (AppendBlock)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.AppendBlock(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", data=" + this.getData() + ")";
        }
    }

    public static final class SetupAppend
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.SETUP_APPEND;
        final long requestId;
        final UUID writerId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.setupAppend(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            UUID uuid = new UUID(in.readLong(), in.readLong());
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new SetupAppend(requestId, uuid, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "writerId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        public SetupAppend(long requestId, UUID writerId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.writerId = writerId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetupAppend)) {
                return false;
            }
            SetupAppend other = (SetupAppend)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SetupAppend(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", writerId=" + this.getWriterId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class Event
    implements WireCommand {
        final WireCommandType type = WireCommandType.EVENT;
        final ByteBuf data;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.type.getCode());
            out.writeInt(this.data.readableBytes());
            this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
        }

        public ByteBuf getAsByteBuf() {
            ByteBuf header = Unpooled.buffer((int)8, (int)8);
            header.writeInt(this.type.getCode());
            header.writeInt(this.data.readableBytes());
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, this.data});
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        public Event(ByteBuf data) {
            this.data = data;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event other = (Event)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.Event(type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
        }
    }

    public static final class PartialEvent
    implements WireCommand {
        final WireCommandType type = WireCommandType.PARTIAL_EVENT;
        final ByteBuf data;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            byte[] msg = new byte[length];
            in.readFully(msg);
            return new PartialEvent(Unpooled.wrappedBuffer((byte[])msg));
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        public PartialEvent(ByteBuf data) {
            this.data = data;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialEvent)) {
                return false;
            }
            PartialEvent other = (PartialEvent)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.PartialEvent(type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
        }
    }

    public static final class Padding
    implements WireCommand {
        final WireCommandType type = WireCommandType.PADDING;
        final int length;

        Padding(int length) {
            Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
            this.length = length;
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            int i;
            for (i = 0; i < this.length / 8; ++i) {
                out.writeLong(0L);
            }
            for (i = 0; i < this.length % 8; ++i) {
                out.writeByte(0);
            }
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            int skipBytes;
            for (int skipped = 0; skipped < length; skipped += skipBytes) {
                skipBytes = in.skipBytes(length - skipped);
                if (skipBytes >= 0) continue;
                throw new CorruptedFrameException("Not enough bytes in buffer. Was attempting to read: " + length);
            }
            return new Padding(length);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Padding)) {
                return false;
            }
            Padding other = (Padding)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            return this.getLength() == other.getLength();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + this.getLength();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.Padding(type=" + (Object)((Object)this.getType()) + ", length=" + this.getLength() + ")";
        }
    }

    public static final class OperationUnsupported
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.OPERATION_UNSUPPORTED;
        final long requestId;
        final String operationName;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.operationUnsupported(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.operationName);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String operationName = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new OperationUnsupported(requestId, operationName, serverStackTrace);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "operationName", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public OperationUnsupported(long requestId, String operationName, String serverStackTrace) {
            this.requestId = requestId;
            this.operationName = operationName;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getOperationName() {
            return this.operationName;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationUnsupported)) {
                return false;
            }
            OperationUnsupported other = (OperationUnsupported)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$operationName = this.getOperationName();
            String other$operationName = other.getOperationName();
            if (this$operationName == null ? other$operationName != null : !this$operationName.equals(other$operationName)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $operationName = this.getOperationName();
            result = result * 59 + ($operationName == null ? 43 : $operationName.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.OperationUnsupported(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", operationName=" + this.getOperationName() + ", serverStackTrace=" + this.getServerStackTrace() + ")";
        }
    }

    public static final class InvalidEventNumber
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.INVALID_EVENT_NUMBER;
        final UUID writerId;
        final long eventNumber;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.invalidEventNumber(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new InvalidEventNumber(writerId, eventNumber, serverStackTrace);
        }

        public String toString() {
            return "Invalid event number: " + this.eventNumber + " for writer: " + this.writerId;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public long getRequestId() {
            return this.eventNumber;
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public InvalidEventNumber(UUID writerId, long eventNumber, String serverStackTrace) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvalidEventNumber)) {
                return false;
            }
            InvalidEventNumber other = (InvalidEventNumber)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class TableSegmentNotEmpty
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_SEGMENT_NOT_EMPTY;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableSegmentNotEmpty(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableSegmentNotEmpty(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Table Segment is not empty: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public TableSegmentNotEmpty(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableSegmentNotEmpty)) {
                return false;
            }
            TableSegmentNotEmpty other = (TableSegmentNotEmpty)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class NoSuchSegment
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.NO_SUCH_SEGMENT;
        final long requestId;
        final String segment;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.noSuchSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new NoSuchSegment(requestId, segment, serverStackTrace, offset);
        }

        public String toString() {
            return "No such segment: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        public NoSuchSegment(long requestId, String segment, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NoSuchSegment)) {
                return false;
            }
            NoSuchSegment other = (NoSuchSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }
    }

    public static final class SegmentAlreadyExists
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ALREADY_EXISTS;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAlreadyExists(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new SegmentAlreadyExists(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Segment already exists: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentAlreadyExists(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAlreadyExists)) {
                return false;
            }
            SegmentAlreadyExists other = (SegmentAlreadyExists)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class SegmentIsTruncated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_IS_TRUNCATED;
        final long requestId;
        final String segment;
        final long startOffset;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentIsTruncated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.startOffset);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            long startOffset = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentIsTruncated(requestId, segment, startOffset, serverStackTrace, offset);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "startOffset", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentIsTruncated(long requestId, String segment, long startOffset, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.startOffset = startOffset;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentIsTruncated)) {
                return false;
            }
            SegmentIsTruncated other = (SegmentIsTruncated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentIsTruncated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", startOffset=" + this.getStartOffset() + ", serverStackTrace=" + this.getServerStackTrace() + ", offset=" + this.getOffset() + ")";
        }
    }

    public static final class SegmentIsSealed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_IS_SEALED;
        final long requestId;
        final String segment;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentIsSealed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentIsSealed(requestId, segment, serverStackTrace, offset);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        public SegmentIsSealed(long requestId, String segment, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentIsSealed)) {
                return false;
            }
            SegmentIsSealed other = (SegmentIsSealed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.SegmentIsSealed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", serverStackTrace=" + this.getServerStackTrace() + ", offset=" + this.getOffset() + ")";
        }
    }

    public static final class WrongHost
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.WRONG_HOST;
        final long requestId;
        final String segment;
        final String correctHost;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.wrongHost(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.correctHost);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String correctHost = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new WrongHost(requestId, segment, correctHost, serverStackTrace);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "correctHost", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        public WrongHost(long requestId, String segment, String correctHost, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.correctHost = correctHost;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getCorrectHost() {
            return this.correctHost;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrongHost)) {
                return false;
            }
            WrongHost other = (WrongHost)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$correctHost = this.getCorrectHost();
            String other$correctHost = other.getCorrectHost();
            if (this$correctHost == null ? other$correctHost != null : !this$correctHost.equals(other$correctHost)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $correctHost = this.getCorrectHost();
            result = result * 59 + ($correctHost == null ? 43 : $correctHost.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.WrongHost(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", correctHost=" + this.getCorrectHost() + ", serverStackTrace=" + this.getServerStackTrace() + ")";
        }
    }

    public static final class Hello
    implements Request,
    Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.HELLO;
        final int highVersion;
        final int lowVersion;

        @Override
        public void process(RequestProcessor cp) {
            cp.hello(this);
        }

        @Override
        public void process(ReplyProcessor cp) {
            cp.hello(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.highVersion);
            out.writeInt(this.lowVersion);
        }

        public static Hello readFrom(DataInput in, int length) throws IOException {
            int highVersion = in.readInt();
            int lowVersion = in.readInt();
            return new Hello(highVersion, lowVersion);
        }

        @Override
        public long getRequestId() {
            return 0L;
        }

        @ConstructorProperties(value={"highVersion", "lowVersion"})
        @SuppressFBWarnings(justification="generated code")
        public Hello(int highVersion, int lowVersion) {
            this.highVersion = highVersion;
            this.lowVersion = lowVersion;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getHighVersion() {
            return this.highVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getLowVersion() {
            return this.lowVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hello)) {
                return false;
            }
            Hello other = (Hello)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getHighVersion() != other.getHighVersion()) {
                return false;
            }
            return this.getLowVersion() == other.getLowVersion();
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + this.getHighVersion();
            result = result * 59 + this.getLowVersion();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WireCommands.Hello(type=" + (Object)((Object)this.getType()) + ", highVersion=" + this.getHighVersion() + ", lowVersion=" + this.getLowVersion() + ")";
        }
    }

    @FunctionalInterface
    static interface Constructor {
        public WireCommand readFrom(ByteBufInputStream var1, int var2) throws IOException;
    }
}

