/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.pravega.common.Exceptions;
import io.pravega.shared.NameUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public final class StreamSegmentNameUtils {
    static final String TAG_SCOPE = "scope";
    static final String TAG_STREAM = "stream";
    static final String TAG_SEGMENT = "segment";
    static final String TAG_EPOCH = "epoch";
    static final String TAG_DEFAULT = "default";
    static final String TAG_WRITER = "writer";
    private static final String ATTRIBUTE_SUFFIX = "$attributes.index";
    private static final String HEADER_SUFFIX = "$header";
    private static final String OFFSET_SUFFIX = "$offset.";
    private static final String TRANSACTION_DELIMITER = "#transaction.";
    private static final String EPOCH_DELIMITER = ".#epoch.";
    private static final String METADATA_SEGMENT_NAME_FORMAT = "_system/containers/metadata_%d";
    private static final int TRANSACTION_PART_LENGTH = 16;
    private static final int TRANSACTION_ID_LENGTH = 32;
    private static final String FULL_HEX_FORMAT = "%016x";
    private static final String TABLES = "_tables";
    private static final String MARK = "_MARK";

    public static String getTransactionNameFromId(String parentStreamSegmentName, UUID transactionId) {
        StringBuilder result = new StringBuilder();
        result.append(parentStreamSegmentName);
        result.append(TRANSACTION_DELIMITER);
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getMostSignificantBits()));
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getLeastSignificantBits()));
        return result.toString();
    }

    public static String getParentStreamSegmentName(String transactionName) {
        int endOfStreamNamePos = transactionName.lastIndexOf(TRANSACTION_DELIMITER);
        if (endOfStreamNamePos < 0 || endOfStreamNamePos + TRANSACTION_DELIMITER.length() + 32 > transactionName.length()) {
            return null;
        }
        return transactionName.substring(0, endOfStreamNamePos);
    }

    public static boolean isTransactionSegment(String streamSegmentName) {
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(TRANSACTION_DELIMITER);
        return endOfStreamNamePos >= 0 && endOfStreamNamePos + TRANSACTION_DELIMITER.length() + 32 <= streamSegmentName.length();
    }

    public static String extractPrimaryStreamSegmentName(String streamSegmentName) {
        if (StreamSegmentNameUtils.isTransactionSegment(streamSegmentName)) {
            return StreamSegmentNameUtils.extractPrimaryStreamSegmentName(StreamSegmentNameUtils.getParentStreamSegmentName(streamSegmentName));
        }
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(EPOCH_DELIMITER);
        if (endOfStreamNamePos < 0) {
            return streamSegmentName;
        }
        return streamSegmentName.substring(0, endOfStreamNamePos);
    }

    public static String getAttributeSegmentName(String segmentName) {
        Preconditions.checkArgument((!segmentName.endsWith(ATTRIBUTE_SUFFIX) ? 1 : 0) != 0, (Object)"segmentName is already an attribute segment name");
        return segmentName + ATTRIBUTE_SUFFIX;
    }

    public static String getHeaderSegmentName(String segmentName) {
        Preconditions.checkArgument((!segmentName.endsWith(HEADER_SUFFIX) ? 1 : 0) != 0, (Object)"segmentName is already a segment header name");
        return segmentName + HEADER_SUFFIX;
    }

    public static String getSegmentNameFromHeader(String headerSegmentName) {
        Preconditions.checkArgument((boolean)headerSegmentName.endsWith(HEADER_SUFFIX));
        return headerSegmentName.substring(0, headerSegmentName.length() - HEADER_SUFFIX.length());
    }

    public static String getSegmentChunkName(String segmentName, long offset) {
        Preconditions.checkArgument((!segmentName.contains(OFFSET_SUFFIX) ? 1 : 0) != 0, (Object)"segmentName is already a SegmentChunk name");
        return segmentName + OFFSET_SUFFIX + Long.toString(offset);
    }

    public static String getMetadataSegmentName(int containerId) {
        Preconditions.checkArgument((containerId >= 0 ? 1 : 0) != 0, (Object)"containerId must be a non-negative number.");
        return String.format(METADATA_SEGMENT_NAME_FORMAT, containerId);
    }

    public static long computeSegmentId(int segmentNumber, int epoch) {
        Preconditions.checkArgument((segmentNumber >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((epoch >= 0 ? 1 : 0) != 0);
        return (long)epoch << 32 | (long)segmentNumber & 0xFFFFFFFFL;
    }

    public static int getSegmentNumber(long segmentId) {
        return (int)segmentId;
    }

    public static int getEpoch(long segmentId) {
        return (int)(segmentId >> 32);
    }

    public static String getScopedStreamName(String scope, String streamName) {
        return StreamSegmentNameUtils.getScopedStreamNameInternal(scope, streamName).toString();
    }

    public static String getQualifiedStreamSegmentName(String scope, String streamName, long segmentId) {
        int segmentNumber = StreamSegmentNameUtils.getSegmentNumber(segmentId);
        int epoch = StreamSegmentNameUtils.getEpoch(segmentId);
        StringBuffer sb = StreamSegmentNameUtils.getScopedStreamNameInternal(scope, streamName);
        sb.append('/');
        sb.append(segmentNumber);
        sb.append(EPOCH_DELIMITER);
        sb.append(epoch);
        return sb.toString();
    }

    public static List<String> extractSegmentTokens(String qualifiedName) {
        long segmentId;
        int segmentIdIndex;
        Preconditions.checkNotNull((Object)qualifiedName);
        String originalSegmentName = StreamSegmentNameUtils.isTransactionSegment(qualifiedName) ? StreamSegmentNameUtils.getParentStreamSegmentName(qualifiedName) : qualifiedName;
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = originalSegmentName.split("[/]");
        int n = segmentIdIndex = tokens.length == 2 ? 1 : 2;
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            segmentId = StreamSegmentNameUtils.computeSegmentId(Integer.parseInt(segmentIdTokens[0]), Integer.parseInt(segmentIdTokens[1]));
        } else {
            segmentId = StreamSegmentNameUtils.computeSegmentId(Integer.parseInt(tokens[segmentIdIndex]), 0);
        }
        retVal.add(tokens[0]);
        if (tokens.length == 3) {
            retVal.add(tokens[1]);
        }
        retVal.add(Long.toString(segmentId));
        return retVal;
    }

    private static StringBuffer getScopedStreamNameInternal(String scope, String streamName) {
        StringBuffer sb = new StringBuffer();
        if (!Strings.isNullOrEmpty((String)scope)) {
            sb.append(scope);
            sb.append('/');
        }
        sb.append(streamName);
        return sb;
    }

    public static String getQualifiedTableName(String scope, String ... tokens) {
        Preconditions.checkArgument((tokens != null && tokens.length > 0 ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s/%s", scope, TABLES));
        for (String token : tokens) {
            sb.append('/');
            sb.append(token);
        }
        return sb.toString();
    }

    public static List<String> extractTableSegmentTokens(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName);
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = qualifiedName.split("[/]");
        Preconditions.checkArgument((tokens.length > 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)tokens[1].equals(TABLES));
        retVal.add(tokens[0]);
        for (int i = 2; i < tokens.length; ++i) {
            retVal.add(tokens[i]);
        }
        return retVal;
    }

    public static boolean isTableSegment(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName);
        String[] tokens = qualifiedName.split("[/]");
        Preconditions.checkArgument((tokens.length > 2 ? 1 : 0) != 0);
        return tokens[1].equals(TABLES);
    }

    public static String getMarkForStream(String stream) {
        return NameUtils.getMarkStreamForStream(stream);
    }

    public static String[] segmentTags(String qualifiedSegmentName) {
        Preconditions.checkNotNull((Object)qualifiedSegmentName);
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null};
        return StreamSegmentNameUtils.updateSegmentTags(qualifiedSegmentName, tags);
    }

    public static String[] segmentTags(String qualifiedSegmentName, String writerId) {
        Preconditions.checkNotNull((Object)qualifiedSegmentName);
        Exceptions.checkNotNullOrEmpty((String)writerId, (String)"writerId");
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null, TAG_WRITER, null};
        StreamSegmentNameUtils.updateSegmentTags(qualifiedSegmentName, tags);
        tags[9] = writerId;
        return tags;
    }

    private static String[] updateSegmentTags(String qualifiedSegmentName, String[] tags) {
        int segmentIdIndex;
        String segmentBaseName = StreamSegmentNameUtils.getSegmentBaseName(qualifiedSegmentName);
        String[] tokens = segmentBaseName.split("[/]");
        int n = tokens.length == 1 ? 0 : (segmentIdIndex = tokens.length == 2 ? 1 : 2);
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            tags[5] = segmentIdTokens[0];
            tags[7] = segmentIdTokens[1];
        } else {
            tags[5] = tokens[segmentIdIndex];
            tags[7] = "0";
        }
        if (tokens.length == 3) {
            tags[1] = tokens[0];
            tags[3] = tokens[1];
        } else if (tokens.length == 1) {
            tags[1] = TAG_DEFAULT;
            tags[3] = TAG_DEFAULT;
        } else {
            tags[1] = TAG_DEFAULT;
            tags[3] = tokens[0];
        }
        return tags;
    }

    public static String[] writerTags(String writerId) {
        Exceptions.checkNotNullOrEmpty((String)writerId, (String)"writerId");
        return new String[]{TAG_WRITER, writerId};
    }

    private static String getSegmentBaseName(String segmentQualifiedName) {
        String segmentBaseName = StreamSegmentNameUtils.getParentStreamSegmentName(segmentQualifiedName);
        return segmentBaseName == null ? segmentQualifiedName : segmentBaseName;
    }
}

