/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.pravega.common.Exceptions;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.BufferView;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@NotThreadSafe
public class ByteBufWrapper
extends AbstractBufferView
implements BufferView {
    private final ByteBuf buf;

    public ByteBufWrapper(@NonNull ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        this.buf = buf.asReadOnly();
    }

    public void retain() {
        this.buf.retain();
    }

    public void release() {
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        for (ByteBuffer bb : this.buf.duplicate().nioBuffers()) {
            bufferCollector.accept(bb);
        }
    }

    public Iterator<ByteBuffer> iterateBuffers() {
        ByteBuf bb = this.buf.duplicate();
        if (bb instanceof CompositeByteBuf) {
            return Iterators.transform((Iterator)((CompositeByteBuf)bb).iterator(), ByteBuf::nioBuffer);
        }
        if (bb.nioBufferCount() == 1) {
            return Iterators.singletonIterator((Object)bb.nioBuffer());
        }
        return Iterators.forArray((Object[])bb.nioBuffers());
    }

    public int getLength() {
        return this.buf.readableBytes();
    }

    public BufferView.Reader getBufferViewReader() {
        return new ByteBufReader(this.buf.duplicate());
    }

    public InputStream getReader() {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        return new ByteBufInputStream(this.buf.duplicate(), false);
    }

    public InputStream getReader(int offset, int length) {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        return new ByteBufInputStream(this.buf.slice(offset, length), false);
    }

    public BufferView slice(int offset, int length) {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        return new ByteBufWrapper(this.buf.slice(offset, length));
    }

    public byte[] getCopy() {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        ByteBuf buf = this.buf.duplicate();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    public void copyTo(OutputStream target) throws IOException {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        ByteBuf buf = this.buf.duplicate();
        buf.readBytes(target, buf.readableBytes());
    }

    public int copyTo(ByteBuffer byteBuffer) {
        Exceptions.checkNotClosed((this.buf.refCnt() == 0 ? 1 : 0) != 0, (Object)((Object)this));
        ByteBuf source = this.buf.duplicate();
        int length = byteBuffer.remaining();
        if (length > this.getLength()) {
            int origLimit = byteBuffer.limit();
            length = this.getLength();
            byteBuffer.limit(byteBuffer.position() + length);
            source.readBytes(byteBuffer);
            byteBuffer.limit(origLimit);
        } else {
            source.readBytes(byteBuffer);
        }
        return length;
    }

    public String toString() {
        return this.buf.toString();
    }

    private static class ByteBufReader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private final ByteBuf buf;

        public int available() {
            return this.buf.readableBytes();
        }

        public int readBytes(ByteBuffer byteBuffer) {
            int length = Math.min(byteBuffer.remaining(), this.buf.readableBytes());
            int origLimit = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + length);
            this.buf.readBytes(byteBuffer);
            byteBuffer.limit(origLimit);
            return length;
        }

        public byte readByte() {
            try {
                return this.buf.readByte();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        public int readInt() {
            try {
                return this.buf.readInt();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        public long readLong() {
            try {
                return this.buf.readLong();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        public BufferView readSlice(int length) {
            try {
                return new ByteBufWrapper(this.buf.readSlice(length));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @ConstructorProperties(value={"buf"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBufReader(ByteBuf buf) {
            this.buf = buf;
        }
    }
}

