/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.TimedOutTestsListener;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.util.BlockingThreadPoolExecutorService;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.functional.CommonCallableSupplier;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.junit.Assert;
import org.junit.Assume;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericTestUtils {
    public static final int EXECUTOR_THREAD_COUNT = 64;
    private static final Logger LOG = LoggerFactory.getLogger(GenericTestUtils.class);
    public static final String PREFIX = "file-";
    private static final AtomicInteger sequence = new AtomicInteger();
    public static final String SYSPROP_TEST_DATA_DIR = "test.build.data";
    public static final String DEFAULT_TEST_DATA_DIR = "target" + File.separator + "test" + File.separator + "data";
    public static final String DEFAULT_TEST_DATA_PATH = "target/test/data/";
    public static final String ERROR_MISSING_ARGUMENT = "Input supplier interface should be initailized";
    public static final String ERROR_INVALID_ARGUMENT = "Total wait time should be greater than check interval time";
    static final String E_NULL_THROWABLE = "Null Throwable";
    static final String E_NULL_THROWABLE_STRING = "Null Throwable.toString() value";
    static final String E_UNEXPECTED_EXCEPTION = "but got unexpected exception";
    private static final BlockingThreadPoolExecutorService EXECUTOR = BlockingThreadPoolExecutorService.newInstance((int)64, (int)128, (long)30L, (TimeUnit)TimeUnit.SECONDS, (String)"test-operations");

    @Deprecated
    public static void disableLog(Log log) {
        GenericTestUtils.disableLog((Log4JLogger)log);
    }

    @Deprecated
    public static org.apache.log4j.Logger toLog4j(Logger logger) {
        return LogManager.getLogger((String)logger.getName());
    }

    @Deprecated
    public static void disableLog(Log4JLogger log) {
        log.getLogger().setLevel(Level.OFF);
    }

    @Deprecated
    public static void disableLog(org.apache.log4j.Logger logger) {
        logger.setLevel(Level.OFF);
    }

    public static void disableLog(Logger logger) {
        GenericTestUtils.disableLog(GenericTestUtils.toLog4j(logger));
    }

    @Deprecated
    public static void setLogLevel(Log log, Level level) {
        GenericTestUtils.setLogLevel((Log4JLogger)log, level);
    }

    @Deprecated
    public static void setLogLevel(Log log, org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(log, Level.toLevel((String)level.toString()));
    }

    @Deprecated
    public static void setLogLevel(Log4JLogger log, Level level) {
        log.getLogger().setLevel(level);
    }

    @Deprecated
    public static void setLogLevel(org.apache.log4j.Logger logger, Level level) {
        logger.setLevel(level);
    }

    @Deprecated
    public static void setLogLevel(Logger logger, Level level) {
        GenericTestUtils.setLogLevel(GenericTestUtils.toLog4j(logger), level);
    }

    public static void setLogLevel(Logger logger, org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(GenericTestUtils.toLog4j(logger), Level.toLevel((String)level.toString()));
    }

    public static void setRootLogLevel(org.slf4j.event.Level level) {
        GenericTestUtils.setLogLevel(LogManager.getRootLogger(), Level.toLevel((String)level.toString()));
    }

    public static void setCurrentLoggersLogLevel(org.slf4j.event.Level level) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)loggers.nextElement();
            logger.setLevel(Level.toLevel((String)level.toString()));
        }
    }

    public static org.slf4j.event.Level toLevel(String level) {
        return GenericTestUtils.toLevel(level, org.slf4j.event.Level.DEBUG);
    }

    public static org.slf4j.event.Level toLevel(String level, org.slf4j.event.Level defaultLevel) {
        try {
            return org.slf4j.event.Level.valueOf((String)level);
        }
        catch (IllegalArgumentException e) {
            return defaultLevel;
        }
    }

    public static String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    public static int uniqueSequenceId() {
        return sequence.incrementAndGet();
    }

    public static File setupTestRootDir(Class<?> testClass) {
        File testRootDir = GenericTestUtils.getTestDir(testClass.getSimpleName());
        if (testRootDir.exists()) {
            FileUtil.fullyDelete((File)testRootDir);
        }
        testRootDir.mkdirs();
        return testRootDir;
    }

    public static File getTestDir() {
        String prop = System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_DIR);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_DIR;
        }
        File dir = new File(prop).getAbsoluteFile();
        dir.mkdirs();
        GenericTestUtils.assertExists(dir);
        return dir;
    }

    public static File getTestDir(String subdir) {
        return new File(GenericTestUtils.getTestDir(), subdir).getAbsoluteFile();
    }

    public static File getRandomizedTestDir() {
        return new File(GenericTestUtils.getRandomizedTempPath());
    }

    public static String getTempPath(String subpath) {
        String prop;
        String string = prop = Path.WINDOWS ? DEFAULT_TEST_DATA_PATH : System.getProperty(SYSPROP_TEST_DATA_DIR, DEFAULT_TEST_DATA_PATH);
        if (prop.isEmpty()) {
            prop = DEFAULT_TEST_DATA_PATH;
        }
        if (!prop.endsWith("/")) {
            prop = prop + "/";
        }
        return prop + subpath;
    }

    public static String getRandomizedTempPath() {
        return GenericTestUtils.getTempPath(RandomStringUtils.randomAlphanumeric((int)10));
    }

    public static void assertExists(File f) {
        Assert.assertTrue((String)("File " + f + " should exist"), (boolean)f.exists());
    }

    public static void assertGlobEquals(File dir, String pattern, String ... expectedMatches) throws IOException {
        TreeSet found = Sets.newTreeSet();
        for (File f : FileUtil.listFiles((File)dir)) {
            if (!f.getName().matches(pattern)) continue;
            found.add(f.getName());
        }
        TreeSet expectedSet = Sets.newTreeSet(Arrays.asList(expectedMatches));
        Assert.assertEquals((String)("Bad files matching " + pattern + " in " + dir), (Object)Joiner.on((String)",").join((Iterable)expectedSet), (Object)Joiner.on((String)",").join((Iterable)found));
    }

    public static void assertExceptionContains(String expectedText, Throwable t) {
        GenericTestUtils.assertExceptionContains(expectedText, t, "");
    }

    public static void assertExceptionContains(String expectedText, Throwable t, String message) {
        Assert.assertNotNull((String)E_NULL_THROWABLE, (Object)t);
        String msg = t.toString();
        if (msg == null) {
            throw new AssertionError(E_NULL_THROWABLE_STRING, t);
        }
        if (expectedText != null && !msg.contains(expectedText)) {
            String prefix = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)message) ? "" : message + ": ";
            throw new AssertionError(String.format("%s Expected to find '%s' %s: %s", prefix, expectedText, E_UNEXPECTED_EXCEPTION, StringUtils.stringifyException((Throwable)t)), t);
        }
    }

    public static void waitFor(Supplier<Boolean> check, long checkEveryMillis, long waitForMillis) throws TimeoutException, InterruptedException {
        Objects.requireNonNull(check, ERROR_MISSING_ARGUMENT);
        if (waitForMillis < checkEveryMillis) {
            throw new IllegalArgumentException(ERROR_INVALID_ARGUMENT);
        }
        long st = Time.monotonicNow();
        boolean result = check.get();
        while (!result && Time.monotonicNow() - st < waitForMillis) {
            Thread.sleep(checkEveryMillis);
            result = check.get();
        }
        if (!result) {
            throw new TimeoutException("Timed out waiting for condition. Thread diagnostics:\n" + TimedOutTestsListener.buildThreadDiagnosticString());
        }
    }

    public static void assertDoesNotMatch(String output, String pattern) {
        Assert.assertFalse((String)("Expected output to match /" + pattern + "/ but got:\n" + output), (boolean)Pattern.compile(pattern).matcher(output).find());
    }

    public static void assertMatches(String output, String pattern) {
        Assert.assertTrue((String)("Expected output to match /" + pattern + "/ but got:\n" + output), (boolean)Pattern.compile(pattern).matcher(output).find());
    }

    public static void assertValueNear(long expected, long actual, long allowedError) {
        GenericTestUtils.assertValueWithinRange(expected - allowedError, expected + allowedError, actual);
    }

    public static void assertValueWithinRange(long expectedMin, long expectedMax, long actual) {
        Assert.assertTrue((String)("Expected " + actual + " to be in range (" + expectedMin + "," + expectedMax + ")"), (expectedMin <= actual && actual <= expectedMax ? 1 : 0) != 0);
    }

    public static boolean anyThreadMatching(Pattern pattern) {
        ThreadInfo[] infos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 20)) {
            if (info == null || !pattern.matcher(info.getThreadName()).matches()) continue;
            return true;
        }
        return false;
    }

    public static void assertNoThreadsMatching(String regex) {
        Pattern pattern = Pattern.compile(regex);
        if (GenericTestUtils.anyThreadMatching(pattern)) {
            Assert.fail((String)("Leaked thread matches " + regex));
        }
    }

    public static void waitForThreadTermination(String regex, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        final Pattern pattern = Pattern.compile(regex);
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !GenericTestUtils.anyThreadMatching(pattern);
            }
        }, checkEveryMillis, waitForMillis);
    }

    public static void assumeInNativeProfile() {
        Assume.assumeTrue((boolean)Boolean.parseBoolean(System.getProperty("runningWithNative", "false")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFilesDiff(File a, File b) throws IOException {
        StringBuilder bld = new StringBuilder();
        BufferedReader ra = null;
        BufferedReader rb = null;
        try {
            ra = new BufferedReader(new InputStreamReader(new FileInputStream(a)));
            rb = new BufferedReader(new InputStreamReader(new FileInputStream(b)));
            while (true) {
                String la = ra.readLine();
                String lb = rb.readLine();
                if (la == null) {
                    if (lb != null) {
                        GenericTestUtils.addPlusses(bld, ra);
                    }
                    break;
                }
                if (lb == null) {
                    if (la != null) {
                        GenericTestUtils.addPlusses(bld, rb);
                    }
                    break;
                }
                if (la.equals(lb)) continue;
                bld.append(" - ").append(la).append("\n");
                bld.append(" + ").append(lb).append("\n");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ra);
            IOUtils.closeQuietly(rb);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)ra);
        IOUtils.closeQuietly((Reader)rb);
        return bld.toString();
    }

    private static void addPlusses(StringBuilder bld, BufferedReader r) throws IOException {
        String l;
        while ((l = r.readLine()) != null) {
            bld.append(" + ").append(l).append("\n");
        }
    }

    public static void failf(String format, Object ... args) {
        String message = String.format(Locale.ENGLISH, format, args);
        AssertionError error = new AssertionError((Object)message);
        int len = args.length;
        if (len > 0 && args[len - 1] instanceof Throwable) {
            ((Throwable)((Object)error)).initCause((Throwable)args[len - 1]);
        }
        throw error;
    }

    public static void failif(boolean condition, String format, Object ... args) {
        if (condition) {
            GenericTestUtils.failf(format, args);
        }
    }

    public static int getTestsThreadCount() {
        String propString = System.getProperty("testsThreadCount", "1");
        int threadCount = 1;
        if (propString != null) {
            double multiplier;
            double calculated;
            String trimProp = propString.trim();
            threadCount = trimProp.endsWith("C") ? ((calculated = (multiplier = Double.parseDouble(trimProp.substring(0, trimProp.length() - 1))) * (double)Runtime.getRuntime().availableProcessors()) > 0.0 ? Math.max((int)calculated, 1) : 0) : Integer.parseInt(trimProp);
        }
        return threadCount;
    }

    private static CompletableFuture<Path> put(FileSystem fs, Path path, String text) {
        return CommonCallableSupplier.submit((Executor)EXECUTOR, () -> {
            try (DurationInfo ignore = new DurationInfo(LOG, false, "Creating %s", new Object[]{path});){
                ContractTestUtils.createFile(fs, path, true, text.getBytes(StandardCharsets.UTF_8));
                Path path2 = path;
                return path2;
            }
        });
    }

    public static List<Path> createFiles(FileSystem fs, Path destDir, int depth, int fileCount, int dirCount) throws IOException {
        return GenericTestUtils.createDirsAndFiles(fs, destDir, depth, fileCount, dirCount, new ArrayList<Path>(fileCount), new ArrayList<Path>(dirCount));
    }

    public static List<Path> createDirsAndFiles(FileSystem fs, Path destDir, int depth, int fileCount, int dirCount, List<Path> paths, List<Path> dirs) throws IOException {
        GenericTestUtils.buildPaths(paths, dirs, destDir, depth, fileCount, dirCount);
        ArrayList<CompletableFuture<Path>> futures = new ArrayList<CompletableFuture<Path>>(paths.size() + dirs.size());
        try (DurationInfo ignore = new DurationInfo(LOG, "Creating %d directories", new Object[]{dirs.size()});){
            for (Path path : dirs) {
                futures.add(CommonCallableSupplier.submit((Executor)EXECUTOR, () -> {
                    fs.mkdirs(path);
                    return path;
                }));
            }
            CommonCallableSupplier.waitForCompletion(futures);
        }
        ignore = new DurationInfo(LOG, "Creating %d files", new Object[]{paths.size()});
        var9_9 = null;
        try {
            for (Path path : paths) {
                futures.add(GenericTestUtils.put(fs, path, path.getName()));
            }
            CommonCallableSupplier.waitForCompletion(futures);
            List<Path> list = paths;
            return list;
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ignore != null) {
                if (var9_9 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ignore.close();
                }
            }
        }
    }

    public static void buildPaths(List<Path> filePaths, List<Path> dirPaths, Path destDir, int depth, int fileCount, int dirCount) {
        Path p;
        String name;
        int i;
        if (depth <= 0) {
            return;
        }
        for (i = 0; i < fileCount; ++i) {
            name = GenericTestUtils.filenameOfIndex(i);
            p = new Path(destDir, name);
            filePaths.add(p);
        }
        for (i = 0; i < dirCount; ++i) {
            name = String.format("dir-%03d", i);
            p = new Path(destDir, name);
            dirPaths.add(p);
            GenericTestUtils.buildPaths(filePaths, dirPaths, p, depth - 1, fileCount, dirCount);
        }
    }

    public static String filenameOfIndex(int i) {
        return String.format("%s%03d", PREFIX, i);
    }

    public static class SleepAnswer
    implements Answer<Object> {
        private final int minSleepTime;
        private final int maxSleepTime;
        private static Random r = new Random();

        public SleepAnswer(int maxSleepTime) {
            this(0, maxSleepTime);
        }

        public SleepAnswer(int minSleepTime, int maxSleepTime) {
            this.minSleepTime = minSleepTime;
            this.maxSleepTime = maxSleepTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object answer(InvocationOnMock invocation) throws Throwable {
            boolean interrupted = false;
            try {
                Thread.sleep(r.nextInt(this.maxSleepTime - this.minSleepTime) + this.minSleepTime);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
            try {
                Object object = invocation.callRealMethod();
                return object;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static class DelegateAnswer
    implements Answer<Object> {
        private final Object delegate;
        private final Logger log;

        public DelegateAnswer(Object delegate) {
            this(null, delegate);
        }

        public DelegateAnswer(Logger log, Object delegate) {
            this.log = log;
            this.delegate = delegate;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            try {
                if (this.log != null) {
                    this.log.info("Call to " + invocation + " on " + this.delegate, (Throwable)new Exception("TRACE"));
                }
                return invocation.getMethod().invoke(this.delegate, invocation.getArguments());
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    public static class DelayAnswer
    implements Answer<Object> {
        private final Logger LOG;
        private final CountDownLatch fireLatch = new CountDownLatch(1);
        private final CountDownLatch waitLatch = new CountDownLatch(1);
        private final CountDownLatch resultLatch = new CountDownLatch(1);
        private final AtomicInteger fireCounter = new AtomicInteger(0);
        private final AtomicInteger resultCounter = new AtomicInteger(0);
        private volatile Throwable thrown;
        private volatile Object returnValue;

        public DelayAnswer(Logger log) {
            this.LOG = log;
        }

        public void waitForCall() throws InterruptedException {
            this.fireLatch.await();
        }

        public void proceed() {
            this.waitLatch.countDown();
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            this.LOG.info("DelayAnswer firing fireLatch");
            this.fireCounter.getAndIncrement();
            this.fireLatch.countDown();
            try {
                this.LOG.info("DelayAnswer waiting on waitLatch");
                this.waitLatch.await();
                this.LOG.info("DelayAnswer delay complete");
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted waiting on latch", ie);
            }
            return this.passThrough(invocation);
        }

        protected Object passThrough(InvocationOnMock invocation) throws Throwable {
            try {
                Object ret;
                this.returnValue = ret = invocation.callRealMethod();
                Object object = ret;
                return object;
            }
            catch (Throwable t) {
                this.thrown = t;
                throw t;
            }
            finally {
                this.resultCounter.incrementAndGet();
                this.resultLatch.countDown();
            }
        }

        public void waitForResult() throws InterruptedException {
            this.resultLatch.await();
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public int getFireCount() {
            return this.fireCounter.get();
        }

        public int getResultCount() {
            return this.resultCounter.get();
        }
    }

    public static class LogCapturer {
        private StringWriter sw = new StringWriter();
        private WriterAppender appender;
        private org.apache.log4j.Logger logger;

        public static LogCapturer captureLogs(Log l) {
            org.apache.log4j.Logger logger = ((Log4JLogger)l).getLogger();
            return new LogCapturer(logger);
        }

        public static LogCapturer captureLogs(Logger logger) {
            return new LogCapturer(GenericTestUtils.toLog4j(logger));
        }

        private LogCapturer(org.apache.log4j.Logger logger) {
            this.logger = logger;
            Appender defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("stdout");
            if (defaultAppender == null) {
                defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("console");
            }
            PatternLayout layout = defaultAppender == null ? new PatternLayout() : defaultAppender.getLayout();
            this.appender = new WriterAppender((Layout)layout, (Writer)this.sw);
            logger.addAppender((Appender)this.appender);
        }

        public String getOutput() {
            return this.sw.toString();
        }

        public void stopCapturing() {
            this.logger.removeAppender((Appender)this.appender);
        }

        public void clearOutput() {
            this.sw.getBuffer().setLength(0);
        }
    }

    public static class SystemErrCapturer
    implements AutoCloseable {
        private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        private final PrintStream bytesPrintStream = new PrintStream(this.bytes);
        private final PrintStream oldErr = System.err;

        public SystemErrCapturer() {
            System.setErr(new TeePrintStream((OutputStream)this.oldErr, this.bytesPrintStream));
        }

        public String getOutput() {
            return this.bytes.toString();
        }

        @Override
        public void close() throws Exception {
            IOUtils.closeQuietly((OutputStream)this.bytesPrintStream);
            System.setErr(this.oldErr);
        }
    }

    public static class TeePrintStream
    extends PrintStream {
        private final PrintStream other;

        public TeePrintStream(OutputStream main, PrintStream other) {
            super(main);
            this.other = other;
        }

        @Override
        public void flush() {
            super.flush();
            this.other.flush();
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            super.write(buf, off, len);
            this.other.write(buf, off, len);
        }
    }
}

