/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.pravega.shared.protocol.netty.AdminRequestProcessor;
import io.pravega.shared.protocol.netty.EnhancedByteBufInputStream;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.RequestProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommandType;
import io.pravega.shared.segment.ScaleType;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

public final class WireCommands {
    public static final int WIRE_VERSION = 14;
    public static final int OLDEST_COMPATIBLE_VERSION = 5;
    public static final int TYPE_SIZE = 4;
    public static final int TYPE_PLUS_LENGTH_SIZE = 8;
    public static final int MAX_WIRECOMMAND_SIZE = 0xFFFFFF;
    public static final long NULL_ATTRIBUTE_VALUE = Long.MIN_VALUE;
    public static final long NULL_TABLE_SEGMENT_OFFSET = -1L;
    private static final Map<Integer, WireCommandType> MAPPING;
    private static final String EMPTY_STACK_TRACE = "";

    public static WireCommandType getType(int value) {
        return MAPPING.get(value);
    }

    static {
        HashMap<Integer, WireCommandType> map = new HashMap<Integer, WireCommandType>();
        for (WireCommandType t : WireCommandType.values()) {
            map.put(t.getCode(), t);
        }
        MAPPING = Collections.unmodifiableMap(map);
    }

    public static final class ConditionalAttributeUpdate {
        public static final byte REPLACE = 1;
        public static final byte REPLACE_IF_EQUALS = 4;
        public static final int LENGTH = 33;
        private final UUID attributeId;
        private final byte attributeUpdateType;
        private final long newValue;
        private final long oldValue;

        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.attributeId.getMostSignificantBits());
            out.writeLong(this.attributeId.getLeastSignificantBits());
            out.writeByte(this.attributeUpdateType);
            out.writeLong(this.newValue);
            out.writeLong(this.oldValue);
        }

        public static ConditionalAttributeUpdate readFrom(DataInput in, int length) throws IOException {
            UUID attributeId = new UUID(in.readLong(), in.readLong());
            byte attributeUpdateType = in.readByte();
            long newValue = in.readLong();
            long oldValue = in.readLong();
            return new ConditionalAttributeUpdate(attributeId, attributeUpdateType, newValue, oldValue);
        }

        public int size() {
            return 33;
        }

        @ConstructorProperties(value={"attributeId", "attributeUpdateType", "newValue", "oldValue"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConditionalAttributeUpdate(UUID attributeId, byte attributeUpdateType, long newValue, long oldValue) {
            this.attributeId = attributeId;
            this.attributeUpdateType = attributeUpdateType;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getAttributeId() {
            return this.attributeId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte getAttributeUpdateType() {
            return this.attributeUpdateType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getNewValue() {
            return this.newValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOldValue() {
            return this.oldValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalAttributeUpdate)) {
                return false;
            }
            ConditionalAttributeUpdate other = (ConditionalAttributeUpdate)o;
            UUID this$attributeId = this.getAttributeId();
            UUID other$attributeId = other.getAttributeId();
            if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
                return false;
            }
            if (this.getAttributeUpdateType() != other.getAttributeUpdateType()) {
                return false;
            }
            if (this.getNewValue() != other.getNewValue()) {
                return false;
            }
            return this.getOldValue() == other.getOldValue();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $attributeId = this.getAttributeId();
            result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
            result = result * 59 + this.getAttributeUpdateType();
            long $newValue = this.getNewValue();
            result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
            long $oldValue = this.getOldValue();
            result = result * 59 + (int)($oldValue >>> 32 ^ $oldValue);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ConditionalAttributeUpdate(attributeId=" + this.getAttributeId() + ", attributeUpdateType=" + this.getAttributeUpdateType() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ")";
        }
    }

    public static abstract class ReleasableCommand
    implements WireCommand {
        private boolean released = true;

        WireCommand requireRelease() {
            this.released = false;
            return this;
        }

        public void release() {
            if (!this.released) {
                this.releaseInternal();
                this.released = true;
            }
        }

        abstract void releaseInternal();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ReleasableCommand() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isReleased() {
            return this.released;
        }
    }

    public static final class ConditionalBlockEnd
    extends ReleasableCommand
    implements Request {
        final WireCommandType type = WireCommandType.CONDITIONAL_BLOCK_END;
        final UUID writerId;
        final long eventNumber;
        final long expectedOffset;
        final ByteBuf data;
        final long requestId;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.expectedOffset);
            if (this.data == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.data.readableBytes());
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
            }
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            long expectedOffset = in.readLong();
            int dataLength = in.readInt();
            ByteBuf data = dataLength > 0 ? in.readFully(dataLength) : Unpooled.EMPTY_BUFFER;
            long requestId = in.readLong();
            return new ConditionalBlockEnd(writerId, eventNumber, expectedOffset, data.retain(), requestId).requireRelease();
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public void process(RequestProcessor cp) {
            throw new UnsupportedOperationException();
        }

        @Override
        void releaseInternal() {
            this.data.release();
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "expectedOffset", "data", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConditionalBlockEnd(UUID writerId, long eventNumber, long expectedOffset, ByteBuf data, long requestId) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.expectedOffset = expectedOffset;
            this.data = data;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getExpectedOffset() {
            return this.expectedOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ConditionalBlockEnd(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", expectedOffset=" + this.getExpectedOffset() + ", data=" + this.getData() + ", requestId=" + this.getRequestId() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalBlockEnd)) {
                return false;
            }
            ConditionalBlockEnd other = (ConditionalBlockEnd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            if (this.getExpectedOffset() != other.getExpectedOffset()) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConditionalBlockEnd;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $expectedOffset = this.getExpectedOffset();
            result = result * 59 + (int)($expectedOffset >>> 32 ^ $expectedOffset);
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }
    }

    public static final class TableEntriesDeltaRead
    extends ReleasableCommand
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_ENTRIES_DELTA_READ;
        final long requestId;
        final String segment;
        final TableEntries entries;
        final boolean shouldClear;
        final boolean reachedEnd;
        final long lastPosition;

        @Override
        public void process(ReplyProcessor cp) throws UnsupportedOperationException {
            cp.tableEntriesDeltaRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            this.entries.writeFields(out);
            out.writeBoolean(this.shouldClear);
            out.writeBoolean(this.reachedEnd);
            out.writeLong(this.lastPosition);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            boolean shouldClear = in.readBoolean();
            boolean reachedEnd = in.readBoolean();
            long lastPosition = in.readLong();
            return new TableEntriesDeltaRead(requestId, segment, entries, shouldClear, reachedEnd, lastPosition).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.entries.release();
        }

        @ConstructorProperties(value={"requestId", "segment", "entries", "shouldClear", "reachedEnd", "lastPosition"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntriesDeltaRead(long requestId, String segment, TableEntries entries, boolean shouldClear, boolean reachedEnd, long lastPosition) {
            this.requestId = requestId;
            this.segment = segment;
            this.entries = entries;
            this.shouldClear = shouldClear;
            this.reachedEnd = reachedEnd;
            this.lastPosition = lastPosition;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntries getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isShouldClear() {
            return this.shouldClear;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isReachedEnd() {
            return this.reachedEnd;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastPosition() {
            return this.lastPosition;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableEntriesDeltaRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", entries=" + this.getEntries() + ", shouldClear=" + this.isShouldClear() + ", reachedEnd=" + this.isReachedEnd() + ", lastPosition=" + this.getLastPosition() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntriesDeltaRead)) {
                return false;
            }
            TableEntriesDeltaRead other = (TableEntriesDeltaRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            TableEntries this$entries = this.getEntries();
            TableEntries other$entries = other.getEntries();
            if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
                return false;
            }
            if (this.isShouldClear() != other.isShouldClear()) {
                return false;
            }
            if (this.isReachedEnd() != other.isReachedEnd()) {
                return false;
            }
            return this.getLastPosition() == other.getLastPosition();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableEntriesDeltaRead;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            TableEntries $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            result = result * 59 + (this.isShouldClear() ? 79 : 97);
            result = result * 59 + (this.isReachedEnd() ? 79 : 97);
            long $lastPosition = this.getLastPosition();
            result = result * 59 + (int)($lastPosition >>> 32 ^ $lastPosition);
            return result;
        }
    }

    public static final class ReadTableEntriesDelta
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE_ENTRIES_DELTA;
        final long requestId;
        final String segment;
        final String delegationToken;
        final long fromPosition;
        final int suggestedEntryCount;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTableEntriesDelta(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeLong(this.fromPosition);
            out.writeInt(this.suggestedEntryCount);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            long fromPosition = in.readLong();
            int suggestedEntryCount = in.readInt();
            return new ReadTableEntriesDelta(requestId, segment, delegationToken, fromPosition, suggestedEntryCount);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "fromPosition", "suggestedEntryCount"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadTableEntriesDelta(long requestId, String segment, String delegationToken, long fromPosition, int suggestedEntryCount) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.fromPosition = fromPosition;
            this.suggestedEntryCount = suggestedEntryCount;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getFromPosition() {
            return this.fromPosition;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getSuggestedEntryCount() {
            return this.suggestedEntryCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTableEntriesDelta)) {
                return false;
            }
            ReadTableEntriesDelta other = (ReadTableEntriesDelta)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            if (this.getFromPosition() != other.getFromPosition()) {
                return false;
            }
            return this.getSuggestedEntryCount() == other.getSuggestedEntryCount();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $fromPosition = this.getFromPosition();
            result = result * 59 + (int)($fromPosition >>> 32 ^ $fromPosition);
            result = result * 59 + this.getSuggestedEntryCount();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ReadTableEntriesDelta(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", fromPosition=" + this.getFromPosition() + ", suggestedEntryCount=" + this.getSuggestedEntryCount() + ")";
        }
    }

    public static final class TableKeyBadVersion
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEY_BAD_VERSION;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeyBadVersion(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableKeyBadVersion(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Conditional table update failed since the key version is incorrect : " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKeyBadVersion(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeyBadVersion)) {
                return false;
            }
            TableKeyBadVersion other = (TableKeyBadVersion)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class TableKeyDoesNotExist
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEY_DOES_NOT_EXIST;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeyDoesNotExist(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableKeyDoesNotExist(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Conditional table update failed since the key does not exist : " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKeyDoesNotExist(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeyDoesNotExist)) {
                return false;
            }
            TableKeyDoesNotExist other = (TableKeyDoesNotExist)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class TableValue {
        public static final TableValue EMPTY = new TableValue(Unpooled.EMPTY_BUFFER);
        public static final int HEADER_BYTES = 8;
        final ByteBuf data;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(4 + this.data.readableBytes());
            out.writeInt(this.data.readableBytes());
            if (this.data.readableBytes() != 0) {
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
            }
        }

        public static TableValue readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            int payloadSize = in.readInt();
            int valueLength = in.readInt();
            if (valueLength == 0) {
                return EMPTY;
            }
            if (length < payloadSize) {
                throw new InvalidMessageException("Was expecting length of at least : " + payloadSize + " but found: " + length);
            }
            ByteBuf msg = in.readFully(valueLength);
            return new TableValue(msg.retain());
        }

        public int size() {
            return 8 + this.data.readableBytes();
        }

        void release() {
            this.data.release();
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableValue(ByteBuf data) {
            this.data = data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableValue)) {
                return false;
            }
            TableValue other = (TableValue)o;
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableValue(data=" + this.getData() + ")";
        }
    }

    public static final class TableKey {
        public static final long NO_VERSION = Long.MIN_VALUE;
        public static final long NOT_EXISTS = -1L;
        public static final int HEADER_BYTES = 8;
        public static final TableKey EMPTY = new TableKey(Unpooled.EMPTY_BUFFER, Long.MIN_VALUE);
        final ByteBuf data;
        final long keyVersion;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(4 + this.data.readableBytes() + 8);
            out.writeInt(this.data.readableBytes());
            if (this.data.readableBytes() != 0) {
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
                out.writeLong(this.keyVersion);
            }
        }

        public static TableKey readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            int payLoadSize = in.readInt();
            int dataLength = in.readInt();
            if (dataLength == 0) {
                return EMPTY;
            }
            if (length < payLoadSize) {
                throw new InvalidMessageException("Was expecting length of at least : " + payLoadSize + " but found: " + length);
            }
            ByteBuf msg = in.readFully(dataLength);
            long keyVersion = in.readLong();
            return new TableKey(msg.retain(), keyVersion);
        }

        public int size() {
            return 8 + this.data.readableBytes() + 8;
        }

        void release() {
            this.data.release();
        }

        @ConstructorProperties(value={"data", "keyVersion"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKey(ByteBuf data, long keyVersion) {
            this.data = data;
            this.keyVersion = keyVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getKeyVersion() {
            return this.keyVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKey)) {
                return false;
            }
            TableKey other = (TableKey)o;
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            return this.getKeyVersion() == other.getKeyVersion();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            long $keyVersion = this.getKeyVersion();
            result = result * 59 + (int)($keyVersion >>> 32 ^ $keyVersion);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableKey(data=" + this.getData() + ", keyVersion=" + this.getKeyVersion() + ")";
        }
    }

    public static final class TableEntries {
        public static final int HEADER_BYTES = 4;
        final List<Map.Entry<TableKey, TableValue>> entries;

        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.entries.size());
            for (Map.Entry<TableKey, TableValue> ent : this.entries) {
                ent.getKey().writeFields(out);
                ent.getValue().writeFields(out);
            }
        }

        public static TableEntries readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            int numberOfEntries = in.readInt();
            ArrayList<Map.Entry<TableKey, TableValue>> entries = new ArrayList<Map.Entry<TableKey, TableValue>>();
            for (int i = 0; i < numberOfEntries; ++i) {
                entries.add(new AbstractMap.SimpleImmutableEntry<TableKey, TableValue>(TableKey.readFrom(in, in.available()), TableValue.readFrom(in, in.available())));
            }
            return new TableEntries(entries);
        }

        void release() {
            this.entries.forEach(e -> {
                ((TableKey)e.getKey()).release();
                ((TableValue)e.getValue()).release();
            });
        }

        @ConstructorProperties(value={"entries"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntries(List<Map.Entry<TableKey, TableValue>> entries) {
            this.entries = entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<Map.Entry<TableKey, TableValue>> getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntries)) {
                return false;
            }
            TableEntries other = (TableEntries)o;
            List<Map.Entry<TableKey, TableValue>> this$entries = this.getEntries();
            List<Map.Entry<TableKey, TableValue>> other$entries = other.getEntries();
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Map.Entry<TableKey, TableValue>> $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableEntries(entries=" + this.getEntries() + ")";
        }
    }

    public static final class TableEntriesRead
    extends ReleasableCommand
    implements Reply,
    WireCommand {
        public static final int HEADER_BYTES = 8;
        final WireCommandType type = WireCommandType.TABLE_ENTRIES_READ;
        final long requestId;
        final String segment;
        final TableEntries entries;
        final ByteBuf continuationToken;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableEntriesRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            this.entries.writeFields(out);
            out.writeInt(this.continuationToken.readableBytes());
            this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            int dataLength = in.readInt();
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new TableEntriesRead(requestId, segment, entries, Unpooled.wrappedBuffer((byte[])continuationToken)).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.entries.release();
        }

        @ConstructorProperties(value={"requestId", "segment", "entries", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntriesRead(long requestId, String segment, TableEntries entries, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.entries = entries;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntries getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableEntriesRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", entries=" + this.getEntries() + ", continuationToken=" + this.getContinuationToken() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntriesRead)) {
                return false;
            }
            TableEntriesRead other = (TableEntriesRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            TableEntries this$entries = this.getEntries();
            TableEntries other$entries = other.getEntries();
            if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableEntriesRead;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            TableEntries $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }
    }

    public static final class ReadTableEntries
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE_ENTRIES;
        final long requestId;
        final String segment;
        final String delegationToken;
        final int suggestedEntryCount;
        final TableIteratorArgs args;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTableEntries(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.suggestedEntryCount);
            this.args.writeFields(out);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int suggestedEntryCount = in.readInt();
            TableIteratorArgs args = new TableIteratorArgs(in);
            return new ReadTableEntries(requestId, segment, delegationToken, suggestedEntryCount, args);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "suggestedEntryCount", "args"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadTableEntries(long requestId, String segment, String delegationToken, int suggestedEntryCount, TableIteratorArgs args) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.suggestedEntryCount = suggestedEntryCount;
            this.args = args;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getSuggestedEntryCount() {
            return this.suggestedEntryCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableIteratorArgs getArgs() {
            return this.args;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTableEntries)) {
                return false;
            }
            ReadTableEntries other = (ReadTableEntries)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            if (this.getSuggestedEntryCount() != other.getSuggestedEntryCount()) {
                return false;
            }
            TableIteratorArgs this$args = this.getArgs();
            TableIteratorArgs other$args = other.getArgs();
            return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            result = result * 59 + this.getSuggestedEntryCount();
            TableIteratorArgs $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ReadTableEntries(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", suggestedEntryCount=" + this.getSuggestedEntryCount() + ", args=" + this.getArgs() + ")";
        }
    }

    public static final class TableKeysRead
    extends ReleasableCommand
    implements Reply,
    WireCommand {
        public static final int HEADER_BYTES = 8;
        final WireCommandType type = WireCommandType.TABLE_KEYS_READ;
        final long requestId;
        final String segment;
        final List<TableKey> keys;
        final ByteBuf continuationToken;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeysRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
            out.writeInt(this.continuationToken.readableBytes());
            this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            int initialAvailable = in.available();
            long requestId = in.readLong();
            String segment = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                TableKey k = TableKey.readFrom(in, in.available());
                keys.add(k);
            }
            int dataLength = in.readInt();
            byte[] continuationToken = new byte[dataLength];
            in.readFully(continuationToken);
            return new TableKeysRead(requestId, segment, keys, Unpooled.wrappedBuffer((byte[])continuationToken)).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.keys.forEach(TableKey::release);
        }

        @ConstructorProperties(value={"requestId", "segment", "keys", "continuationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKeysRead(long requestId, String segment, List<TableKey> keys, ByteBuf continuationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.keys = keys;
            this.continuationToken = continuationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableKeysRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ", continuationToken=" + this.getContinuationToken() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeysRead)) {
                return false;
            }
            TableKeysRead other = (TableKeysRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            return !(this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableKeysRead;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            return result;
        }
    }

    public static final class TableIteratorArgs {
        final ByteBuf continuationToken;
        final ByteBuf prefixFilter;
        final ByteBuf fromKey;
        final ByteBuf toKey;

        TableIteratorArgs(ByteBufInputStream in) throws IOException {
            this(TableIteratorArgs.readBuffer(in), TableIteratorArgs.readBuffer(in), TableIteratorArgs.readBuffer(in), TableIteratorArgs.readBuffer(in));
        }

        private static ByteBuf readBuffer(ByteBufInputStream in) throws IOException {
            int dataLength = in.available() >= 4 ? in.readInt() : 0;
            byte[] data = new byte[dataLength];
            if (dataLength > 0) {
                in.readFully(data);
            }
            return Unpooled.wrappedBuffer((byte[])data);
        }

        void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.continuationToken.readableBytes());
            if (this.continuationToken.readableBytes() != 0) {
                this.continuationToken.getBytes(this.continuationToken.readerIndex(), (OutputStream)((Object)out), this.continuationToken.readableBytes());
            }
            out.writeInt(0);
            out.writeInt(this.fromKey.readableBytes());
            if (this.fromKey.readableBytes() != 0) {
                this.fromKey.getBytes(this.fromKey.readerIndex(), (OutputStream)((Object)out), this.fromKey.readableBytes());
            }
            out.writeInt(this.toKey.readableBytes());
            if (this.toKey.readableBytes() != 0) {
                this.toKey.getBytes(this.toKey.readerIndex(), (OutputStream)((Object)out), this.toKey.readableBytes());
            }
        }

        @ConstructorProperties(value={"continuationToken", "prefixFilter", "fromKey", "toKey"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableIteratorArgs(ByteBuf continuationToken, ByteBuf prefixFilter, ByteBuf fromKey, ByteBuf toKey) {
            this.continuationToken = continuationToken;
            this.prefixFilter = prefixFilter;
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getContinuationToken() {
            return this.continuationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getPrefixFilter() {
            return this.prefixFilter;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getFromKey() {
            return this.fromKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getToKey() {
            return this.toKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableIteratorArgs)) {
                return false;
            }
            TableIteratorArgs other = (TableIteratorArgs)o;
            ByteBuf this$continuationToken = this.getContinuationToken();
            ByteBuf other$continuationToken = other.getContinuationToken();
            if (this$continuationToken == null ? other$continuationToken != null : !this$continuationToken.equals(other$continuationToken)) {
                return false;
            }
            ByteBuf this$prefixFilter = this.getPrefixFilter();
            ByteBuf other$prefixFilter = other.getPrefixFilter();
            if (this$prefixFilter == null ? other$prefixFilter != null : !this$prefixFilter.equals(other$prefixFilter)) {
                return false;
            }
            ByteBuf this$fromKey = this.getFromKey();
            ByteBuf other$fromKey = other.getFromKey();
            if (this$fromKey == null ? other$fromKey != null : !this$fromKey.equals(other$fromKey)) {
                return false;
            }
            ByteBuf this$toKey = this.getToKey();
            ByteBuf other$toKey = other.getToKey();
            return !(this$toKey == null ? other$toKey != null : !this$toKey.equals(other$toKey));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ByteBuf $continuationToken = this.getContinuationToken();
            result = result * 59 + ($continuationToken == null ? 43 : $continuationToken.hashCode());
            ByteBuf $prefixFilter = this.getPrefixFilter();
            result = result * 59 + ($prefixFilter == null ? 43 : $prefixFilter.hashCode());
            ByteBuf $fromKey = this.getFromKey();
            result = result * 59 + ($fromKey == null ? 43 : $fromKey.hashCode());
            ByteBuf $toKey = this.getToKey();
            result = result * 59 + ($toKey == null ? 43 : $toKey.hashCode());
            return result;
        }
    }

    public static final class ReadTableKeys
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE_KEYS;
        final long requestId;
        final String segment;
        final String delegationToken;
        final int suggestedKeyCount;
        final TableIteratorArgs args;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTableKeys(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.suggestedKeyCount);
            this.args.writeFields(out);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int suggestedKeyCount = in.readInt();
            TableIteratorArgs args = new TableIteratorArgs(in);
            return new ReadTableKeys(requestId, segment, delegationToken, suggestedKeyCount, args);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "suggestedKeyCount", "args"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadTableKeys(long requestId, String segment, String delegationToken, int suggestedKeyCount, TableIteratorArgs args) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.suggestedKeyCount = suggestedKeyCount;
            this.args = args;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getSuggestedKeyCount() {
            return this.suggestedKeyCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableIteratorArgs getArgs() {
            return this.args;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTableKeys)) {
                return false;
            }
            ReadTableKeys other = (ReadTableKeys)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            if (this.getSuggestedKeyCount() != other.getSuggestedKeyCount()) {
                return false;
            }
            TableIteratorArgs this$args = this.getArgs();
            TableIteratorArgs other$args = other.getArgs();
            return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            result = result * 59 + this.getSuggestedKeyCount();
            TableIteratorArgs $args = this.getArgs();
            result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ReadTableKeys(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", suggestedKeyCount=" + this.getSuggestedKeyCount() + ", args=" + this.getArgs() + ")";
        }
    }

    public static final class TableRead
    extends ReleasableCommand
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_READ;
        final long requestId;
        final String segment;
        final TableEntries entries;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            this.entries.writeFields(out);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            return new TableRead(requestId, segment, entries).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.entries.release();
        }

        @ConstructorProperties(value={"requestId", "segment", "entries"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableRead(long requestId, String segment, TableEntries entries) {
            this.requestId = requestId;
            this.segment = segment;
            this.entries = entries;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntries getEntries() {
            return this.entries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableRead(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", entries=" + this.getEntries() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableRead)) {
                return false;
            }
            TableRead other = (TableRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            TableEntries this$entries = this.getEntries();
            TableEntries other$entries = other.getEntries();
            return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TableRead;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            TableEntries $entries = this.getEntries();
            result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
            return result;
        }
    }

    public static final class ReadTable
    extends ReleasableCommand
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_TABLE;
        final long requestId;
        final String segment;
        final String delegationToken;
        final List<TableKey> keys;

        @Override
        public void process(RequestProcessor cp) {
            cp.readTable(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                keys.add(TableKey.readFrom(in, in.available()));
            }
            return new ReadTable(requestId, segment, delegationToken, keys).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.keys.forEach(TableKey::release);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "keys"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadTable(long requestId, String segment, String delegationToken, List<TableKey> keys) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.keys = keys;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ReadTable(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadTable)) {
                return false;
            }
            ReadTable other = (ReadTable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadTable;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }
    }

    public static final class TableKeysRemoved
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_KEYS_REMOVED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableKeysRemoved(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new TableKeysRemoved(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableKeysRemoved(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableKeysRemoved)) {
                return false;
            }
            TableKeysRemoved other = (TableKeysRemoved)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableKeysRemoved(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class RemoveTableKeys
    extends ReleasableCommand
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.REMOVE_TABLE_KEYS;
        final long requestId;
        final String segment;
        final String delegationToken;
        final List<TableKey> keys;
        final long tableSegmentOffset;

        @Override
        public void process(RequestProcessor cp) {
            cp.removeTableKeys(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.keys.size());
            for (TableKey key : this.keys) {
                key.writeFields(out);
            }
            out.writeLong(this.tableSegmentOffset);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            int numberOfKeys = in.readInt();
            ArrayList<TableKey> keys = new ArrayList<TableKey>(numberOfKeys);
            for (int i = 0; i < numberOfKeys; ++i) {
                keys.add(TableKey.readFrom(in, in.available()));
            }
            long tableSegmentOffset = in.available() > 0 ? in.readLong() : -1L;
            return new RemoveTableKeys(requestId, segment, delegationToken, keys, tableSegmentOffset).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.keys.forEach(TableKey::release);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "keys", "tableSegmentOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RemoveTableKeys(long requestId, String segment, String delegationToken, List<TableKey> keys, long tableSegmentOffset) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.keys = keys;
            this.tableSegmentOffset = tableSegmentOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<TableKey> getKeys() {
            return this.keys;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTableSegmentOffset() {
            return this.tableSegmentOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.RemoveTableKeys(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", keys=" + this.getKeys() + ", tableSegmentOffset=" + this.getTableSegmentOffset() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveTableKeys)) {
                return false;
            }
            RemoveTableKeys other = (RemoveTableKeys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            List<TableKey> this$keys = this.getKeys();
            List<TableKey> other$keys = other.getKeys();
            if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
                return false;
            }
            return this.getTableSegmentOffset() == other.getTableSegmentOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RemoveTableKeys;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            List<TableKey> $keys = this.getKeys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            long $tableSegmentOffset = this.getTableSegmentOffset();
            result = result * 59 + (int)($tableSegmentOffset >>> 32 ^ $tableSegmentOffset);
            return result;
        }
    }

    public static final class TableEntriesUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_ENTRIES_UPDATED;
        final long requestId;
        final List<Long> updatedVersions;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableEntriesUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeInt(this.updatedVersions.size());
            for (long version : this.updatedVersions) {
                out.writeLong(version);
            }
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            int numberOfEntries = in.readInt();
            ArrayList<Long> updatedVersions = new ArrayList<Long>(numberOfEntries);
            for (int i = 0; i < numberOfEntries; ++i) {
                updatedVersions.add(in.readLong());
            }
            return new TableEntriesUpdated(requestId, updatedVersions);
        }

        @ConstructorProperties(value={"requestId", "updatedVersions"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntriesUpdated(long requestId, List<Long> updatedVersions) {
            this.requestId = requestId;
            this.updatedVersions = updatedVersions;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<Long> getUpdatedVersions() {
            return this.updatedVersions;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableEntriesUpdated)) {
                return false;
            }
            TableEntriesUpdated other = (TableEntriesUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            List<Long> this$updatedVersions = this.getUpdatedVersions();
            List<Long> other$updatedVersions = other.getUpdatedVersions();
            return !(this$updatedVersions == null ? other$updatedVersions != null : !((Object)this$updatedVersions).equals(other$updatedVersions));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            List<Long> $updatedVersions = this.getUpdatedVersions();
            result = result * 59 + ($updatedVersions == null ? 43 : ((Object)$updatedVersions).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableEntriesUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", updatedVersions=" + this.getUpdatedVersions() + ")";
        }
    }

    public static final class UpdateTableEntries
    extends ReleasableCommand
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_TABLE_ENTRIES;
        final long requestId;
        final String segment;
        final String delegationToken;
        final TableEntries tableEntries;
        final long tableSegmentOffset;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateTableEntries(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            this.tableEntries.writeFields(out);
            out.writeLong(this.tableSegmentOffset);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            TableEntries entries = TableEntries.readFrom(in, in.available());
            long tableSegmentOffset = in.available() > 0 ? in.readLong() : -1L;
            return new UpdateTableEntries(requestId, segment, delegationToken, entries, tableSegmentOffset).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.tableEntries.release();
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken", "tableEntries", "tableSegmentOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateTableEntries(long requestId, String segment, String delegationToken, TableEntries tableEntries, long tableSegmentOffset) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
            this.tableEntries = tableEntries;
            this.tableSegmentOffset = tableSegmentOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableEntries getTableEntries() {
            return this.tableEntries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTableSegmentOffset() {
            return this.tableSegmentOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.UpdateTableEntries(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", tableEntries=" + this.getTableEntries() + ", tableSegmentOffset=" + this.getTableSegmentOffset() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateTableEntries)) {
                return false;
            }
            UpdateTableEntries other = (UpdateTableEntries)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            TableEntries this$tableEntries = this.getTableEntries();
            TableEntries other$tableEntries = other.getTableEntries();
            if (this$tableEntries == null ? other$tableEntries != null : !((Object)this$tableEntries).equals(other$tableEntries)) {
                return false;
            }
            return this.getTableSegmentOffset() == other.getTableSegmentOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdateTableEntries;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            TableEntries $tableEntries = this.getTableEntries();
            result = result * 59 + ($tableEntries == null ? 43 : ((Object)$tableEntries).hashCode());
            long $tableSegmentOffset = this.getTableSegmentOffset();
            result = result * 59 + (int)($tableSegmentOffset >>> 32 ^ $tableSegmentOffset);
            return result;
        }
    }

    public static final class ErrorMessage
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.ERROR_MESSAGE;
        final long requestId;
        final String segment;
        final String message;
        final ErrorCode errorCode;

        @Override
        public void process(ReplyProcessor cp) throws UnsupportedOperationException {
            cp.errorMessage(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment == null ? WireCommands.EMPTY_STACK_TRACE : this.segment);
            out.writeUTF(this.message == null ? WireCommands.EMPTY_STACK_TRACE : this.message);
            out.writeInt(this.errorCode.getCode());
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            return new ErrorMessage(in.readLong(), in.readUTF(), in.readUTF(), ErrorCode.valueOf(in.readInt()));
        }

        public RuntimeException getThrowableException() {
            switch (this.errorCode) {
                case ILLEGAL_ARGUMENT_EXCEPTION: {
                    return new IllegalArgumentException(this.message);
                }
            }
            return new RuntimeException(this.message);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "message", "errorCode"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ErrorMessage(long requestId, String segment, String message, ErrorCode errorCode) {
            this.requestId = requestId;
            this.segment = segment;
            this.message = message;
            this.errorCode = errorCode;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getMessage() {
            return this.message;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorMessage)) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            ErrorCode this$errorCode = this.getErrorCode();
            ErrorCode other$errorCode = other.getErrorCode();
            return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            ErrorCode $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ErrorMessage(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", message=" + this.getMessage() + ", errorCode=" + (Object)((Object)this.getErrorCode()) + ")";
        }

        public static enum ErrorCode {
            UNSPECIFIED(-1, RuntimeException.class),
            ILLEGAL_ARGUMENT_EXCEPTION(0, IllegalArgumentException.class);

            private static final Map<Integer, ErrorCode> OBJECTS_BY_CODE;
            private static final Map<Class, ErrorCode> OBJECTS_BY_CLASS;
            private final int code;
            private final Class<? extends Throwable> exception;

            private ErrorCode(int code, Class<? extends Exception> exception) {
                this.code = code;
                this.exception = exception;
            }

            public static ErrorCode valueOf(int code) {
                return OBJECTS_BY_CODE.getOrDefault(code, UNSPECIFIED);
            }

            public static ErrorCode valueOf(Class<? extends Throwable> exception) {
                return OBJECTS_BY_CLASS.getOrDefault(exception, UNSPECIFIED);
            }

            public int getCode() {
                return this.code;
            }

            public Class<? extends Throwable> getExceptionType() {
                return this.exception;
            }

            static {
                OBJECTS_BY_CODE = new HashMap<Integer, ErrorCode>();
                OBJECTS_BY_CLASS = new HashMap<Class, ErrorCode>();
                for (ErrorCode errorCode : ErrorCode.values()) {
                    OBJECTS_BY_CODE.put(errorCode.code, errorCode);
                    OBJECTS_BY_CLASS.put(errorCode.exception, errorCode);
                }
            }
        }
    }

    public static final class AuthTokenCheckFailed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.AUTH_TOKEN_CHECK_FAILED;
        final long requestId;
        final String serverStackTrace;
        final ErrorCode errorCode;

        public AuthTokenCheckFailed(long requestId, String serverStackTrace) {
            this(requestId, serverStackTrace, ErrorCode.UNSPECIFIED);
        }

        public AuthTokenCheckFailed(long requestId, String stackTrace, ErrorCode errorCode) {
            this.requestId = requestId;
            this.serverStackTrace = stackTrace;
            this.errorCode = errorCode;
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            int errorCode = in.available() >= 4 ? in.readInt() : -1;
            return new AuthTokenCheckFailed(requestId, serverStackTrace, ErrorCode.valueOf(errorCode));
        }

        public boolean isTokenExpired() {
            return this.errorCode == ErrorCode.TOKEN_EXPIRED;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public void process(ReplyProcessor cp) {
            cp.authTokenCheckFailed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.serverStackTrace);
            out.writeInt(this.errorCode.getCode());
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthTokenCheckFailed)) {
                return false;
            }
            AuthTokenCheckFailed other = (AuthTokenCheckFailed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            ErrorCode this$errorCode = this.getErrorCode();
            ErrorCode other$errorCode = other.getErrorCode();
            return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            ErrorCode $errorCode = this.getErrorCode();
            result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.AuthTokenCheckFailed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", serverStackTrace=" + this.getServerStackTrace() + ", errorCode=" + (Object)((Object)this.getErrorCode()) + ")";
        }

        public static enum ErrorCode {
            UNSPECIFIED(-1),
            TOKEN_CHECK_FAILED(0),
            TOKEN_EXPIRED(1);

            private static final Map<Integer, ErrorCode> OBJECTS_BY_CODE;
            private final int code;

            private ErrorCode(int code) {
                this.code = code;
            }

            public static ErrorCode valueOf(int code) {
                return OBJECTS_BY_CODE.getOrDefault(code, TOKEN_CHECK_FAILED);
            }

            public int getCode() {
                return this.code;
            }

            static {
                OBJECTS_BY_CODE = new HashMap<Integer, ErrorCode>();
                for (ErrorCode errorCode : ErrorCode.values()) {
                    OBJECTS_BY_CODE.put(errorCode.code, errorCode);
                }
            }
        }
    }

    public static final class KeepAlive
    implements Request,
    Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.KEEP_ALIVE;

        @Override
        public void process(ReplyProcessor cp) {
            cp.keepAlive(this);
        }

        @Override
        public void process(RequestProcessor cp) {
            cp.keepAlive(this);
        }

        @Override
        public void writeFields(DataOutput out) {
        }

        public static WireCommand readFrom(DataInput in, int length) {
            return new KeepAlive();
        }

        @Override
        public long getRequestId() {
            return -1L;
        }

        @Override
        public boolean mustLog() {
            return false;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeepAlive() {
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeepAlive)) {
                return false;
            }
            KeepAlive other = (KeepAlive)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.KeepAlive(type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static final class SegmentDeleted
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_DELETED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentDeleted(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentDeleted(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentDeleted(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentDeleted)) {
                return false;
            }
            SegmentDeleted other = (SegmentDeleted)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentDeleted(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class DeleteTableSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.DELETE_TABLE_SEGMENT;
        final long requestId;
        final String segment;
        final boolean mustBeEmpty;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.deleteTableSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeBoolean(this.mustBeEmpty);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            boolean mustBeEmpty = in.readBoolean();
            String delegationToken = in.readUTF();
            return new DeleteTableSegment(requestId, segment, mustBeEmpty, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "mustBeEmpty", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteTableSegment(long requestId, String segment, boolean mustBeEmpty, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.mustBeEmpty = mustBeEmpty;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isMustBeEmpty() {
            return this.mustBeEmpty;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteTableSegment)) {
                return false;
            }
            DeleteTableSegment other = (DeleteTableSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.isMustBeEmpty() != other.isMustBeEmpty()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + (this.isMustBeEmpty() ? 79 : 97);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.DeleteTableSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", mustBeEmpty=" + this.isMustBeEmpty() + ")";
        }
    }

    public static final class DeleteSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.DELETE_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.deleteSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new DeleteSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteSegment)) {
                return false;
            }
            DeleteSegment other = (DeleteSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.DeleteSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SegmentTruncated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_TRUNCATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentTruncated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentTruncated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentTruncated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentTruncated)) {
                return false;
            }
            SegmentTruncated other = (SegmentTruncated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentTruncated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class TruncateSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.TRUNCATE_SEGMENT;
        final long requestId;
        final String segment;
        final long truncationOffset;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.truncateSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.truncationOffset);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            long truncationOffset = in.readLong();
            String delegationToken = in.readUTF();
            return new TruncateSegment(requestId, segment, truncationOffset, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "truncationOffset", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TruncateSegment(long requestId, String segment, long truncationOffset, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.truncationOffset = truncationOffset;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTruncationOffset() {
            return this.truncationOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TruncateSegment)) {
                return false;
            }
            TruncateSegment other = (TruncateSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getTruncationOffset() != other.getTruncationOffset()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $truncationOffset = this.getTruncationOffset();
            result = result * 59 + (int)($truncationOffset >>> 32 ^ $truncationOffset);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TruncateSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", truncationOffset=" + this.getTruncationOffset() + ")";
        }
    }

    public static final class SegmentSealed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_SEALED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentSealed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentSealed(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentSealed(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentSealed)) {
                return false;
            }
            SegmentSealed other = (SegmentSealed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentSealed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SealSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.SEAL_SEGMENT;
        final long requestId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.sealSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new SealSegment(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SealSegment(long requestId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SealSegment)) {
                return false;
            }
            SealSegment other = (SealSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SealSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class SegmentsMerged
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENTS_MERGED;
        final long requestId;
        final String target;
        final String source;
        final long newTargetWriteOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentsMerged(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.target);
            out.writeUTF(this.source);
            out.writeLong(this.newTargetWriteOffset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String target = in.readUTF();
            String source = in.readUTF();
            long newTargetWriteOffset = in.available() > 0 ? in.readLong() : -1L;
            return new SegmentsMerged(requestId, target, source, newTargetWriteOffset);
        }

        @ConstructorProperties(value={"requestId", "target", "source", "newTargetWriteOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentsMerged(long requestId, String target, String source, long newTargetWriteOffset) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.newTargetWriteOffset = newTargetWriteOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTarget() {
            return this.target;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getNewTargetWriteOffset() {
            return this.newTargetWriteOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentsMerged)) {
                return false;
            }
            SegmentsMerged other = (SegmentsMerged)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            return this.getNewTargetWriteOffset() == other.getNewTargetWriteOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            long $newTargetWriteOffset = this.getNewTargetWriteOffset();
            result = result * 59 + (int)($newTargetWriteOffset >>> 32 ^ $newTargetWriteOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentsMerged(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", target=" + this.getTarget() + ", source=" + this.getSource() + ", newTargetWriteOffset=" + this.getNewTargetWriteOffset() + ")";
        }
    }

    public static final class MergeSegments
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.MERGE_SEGMENTS;
        final long requestId;
        final String target;
        final String source;
        final String delegationToken;
        final List<ConditionalAttributeUpdate> attributeUpdates;

        public MergeSegments(long requestId, String target, String source, String delegationToken) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.delegationToken = delegationToken;
            this.attributeUpdates = Collections.emptyList();
        }

        @Override
        public void process(RequestProcessor cp) {
            cp.mergeSegments(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.target);
            out.writeUTF(this.source);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeInt(this.attributeUpdates.size());
            for (ConditionalAttributeUpdate entry : this.attributeUpdates) {
                entry.writeFields(out);
            }
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String target = in.readUTF();
            String source = in.readUTF();
            String delegationToken = in.readUTF();
            ArrayList<ConditionalAttributeUpdate> attributeUpdates = new ArrayList<ConditionalAttributeUpdate>();
            if (in.available() <= 0) {
                return new MergeSegments(requestId, target, source, delegationToken, attributeUpdates);
            }
            int numberOfEntries = in.readInt();
            for (int i = 0; i < numberOfEntries; ++i) {
                attributeUpdates.add(ConditionalAttributeUpdate.readFrom((DataInput)in, length));
            }
            return new MergeSegments(requestId, target, source, delegationToken, attributeUpdates);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTarget() {
            return this.target;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<ConditionalAttributeUpdate> getAttributeUpdates() {
            return this.attributeUpdates;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeSegments)) {
                return false;
            }
            MergeSegments other = (MergeSegments)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            List<ConditionalAttributeUpdate> this$attributeUpdates = this.getAttributeUpdates();
            List<ConditionalAttributeUpdate> other$attributeUpdates = other.getAttributeUpdates();
            return !(this$attributeUpdates == null ? other$attributeUpdates != null : !((Object)this$attributeUpdates).equals(other$attributeUpdates));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            List<ConditionalAttributeUpdate> $attributeUpdates = this.getAttributeUpdates();
            result = result * 59 + ($attributeUpdates == null ? 43 : ((Object)$attributeUpdates).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.MergeSegments(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", target=" + this.getTarget() + ", source=" + this.getSource() + ", attributeUpdates=" + this.getAttributeUpdates() + ")";
        }

        @ConstructorProperties(value={"requestId", "target", "source", "delegationToken", "attributeUpdates"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MergeSegments(long requestId, String target, String source, String delegationToken, List<ConditionalAttributeUpdate> attributeUpdates) {
            this.requestId = requestId;
            this.target = target;
            this.source = source;
            this.delegationToken = delegationToken;
            this.attributeUpdates = attributeUpdates;
        }
    }

    public static final class SegmentPolicyUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_POLICY_UPDATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentPolicyUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentPolicyUpdated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentPolicyUpdated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentPolicyUpdated)) {
                return false;
            }
            SegmentPolicyUpdated other = (SegmentPolicyUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentPolicyUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class UpdateSegmentPolicy
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_SEGMENT_POLICY;
        final long requestId;
        final String segment;
        final byte scaleType;
        final int targetRate;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateSegmentPolicy(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.targetRate);
            out.writeByte(this.scaleType);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            int desiredRate = in.readInt();
            byte scaleType = in.readByte();
            String delegationToken = in.readUTF();
            return new UpdateSegmentPolicy(requestId, segment, scaleType, desiredRate, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segment", "scaleType", "targetRate", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateSegmentPolicy(long requestId, String segment, byte scaleType, int targetRate, String delegationToken) {
            this.requestId = requestId;
            this.segment = segment;
            this.scaleType = scaleType;
            this.targetRate = targetRate;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte getScaleType() {
            return this.scaleType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getTargetRate() {
            return this.targetRate;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSegmentPolicy)) {
                return false;
            }
            UpdateSegmentPolicy other = (UpdateSegmentPolicy)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getScaleType() != other.getScaleType()) {
                return false;
            }
            if (this.getTargetRate() != other.getTargetRate()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + this.getScaleType();
            result = result * 59 + this.getTargetRate();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.UpdateSegmentPolicy(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", scaleType=" + this.getScaleType() + ", targetRate=" + this.getTargetRate() + ")";
        }
    }

    public static final class SegmentCreated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_CREATED;
        final long requestId;
        final String segment;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentCreated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            return new SegmentCreated(requestId, segment);
        }

        @ConstructorProperties(value={"requestId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentCreated(long requestId, String segment) {
            this.requestId = requestId;
            this.segment = segment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentCreated)) {
                return false;
            }
            SegmentCreated other = (SegmentCreated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !this$segment.equals(other$segment));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentCreated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class CreateTableSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.CREATE_TABLE_SEGMENT;
        final long requestId;
        final String segment;
        final boolean sortedDeprecated;
        final int keyLength;
        final String delegationToken;
        final long rolloverSizeBytes;

        @Override
        public void process(RequestProcessor cp) {
            cp.createTableSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeBoolean(this.sortedDeprecated);
            out.writeInt(this.keyLength);
            out.writeLong(this.rolloverSizeBytes);
        }

        public static <T extends InputStream> WireCommand readFrom(T in, int length) throws IOException {
            long requestId = ((DataInput)((Object)in)).readLong();
            String segment = ((DataInput)((Object)in)).readUTF();
            String delegationToken = ((DataInput)((Object)in)).readUTF();
            boolean sorted = false;
            int keyLength = 0;
            long rolloverSizeBytes = 0L;
            if (in.available() >= 1) {
                sorted = ((DataInput)((Object)in)).readBoolean();
            }
            if (in.available() >= 4) {
                keyLength = ((DataInput)((Object)in)).readInt();
            }
            if (in.available() >= 8) {
                rolloverSizeBytes = ((DataInput)((Object)in)).readLong();
            }
            return new CreateTableSegment(requestId, segment, sorted, keyLength, delegationToken, rolloverSizeBytes);
        }

        @ConstructorProperties(value={"requestId", "segment", "sortedDeprecated", "keyLength", "delegationToken", "rolloverSizeBytes"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateTableSegment(long requestId, String segment, boolean sortedDeprecated, int keyLength, String delegationToken, long rolloverSizeBytes) {
            this.requestId = requestId;
            this.segment = segment;
            this.sortedDeprecated = sortedDeprecated;
            this.keyLength = keyLength;
            this.delegationToken = delegationToken;
            this.rolloverSizeBytes = rolloverSizeBytes;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isSortedDeprecated() {
            return this.sortedDeprecated;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getKeyLength() {
            return this.keyLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRolloverSizeBytes() {
            return this.rolloverSizeBytes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateTableSegment)) {
                return false;
            }
            CreateTableSegment other = (CreateTableSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.isSortedDeprecated() != other.isSortedDeprecated()) {
                return false;
            }
            if (this.getKeyLength() != other.getKeyLength()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            return this.getRolloverSizeBytes() == other.getRolloverSizeBytes();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + (this.isSortedDeprecated() ? 79 : 97);
            result = result * 59 + this.getKeyLength();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $rolloverSizeBytes = this.getRolloverSizeBytes();
            result = result * 59 + (int)($rolloverSizeBytes >>> 32 ^ $rolloverSizeBytes);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.CreateTableSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", sortedDeprecated=" + this.isSortedDeprecated() + ", keyLength=" + this.getKeyLength() + ", rolloverSizeBytes=" + this.getRolloverSizeBytes() + ")";
        }
    }

    public static final class TableSegmentInfo
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final long startOffset;
        final long length;
        final long entryCount;
        final int keyLength;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeLong(this.startOffset);
            out.writeLong(this.length);
            out.writeLong(this.entryCount);
            out.writeInt(this.keyLength);
        }

        public static <T extends InputStream> WireCommand readFrom(T in, int length) throws IOException {
            long requestId = ((DataInput)((Object)in)).readLong();
            String segmentName = ((DataInput)((Object)in)).readUTF();
            long startOffset = ((DataInput)((Object)in)).readLong();
            long segmentLength = ((DataInput)((Object)in)).readLong();
            long entryCount = ((DataInput)((Object)in)).readLong();
            int keyLength = ((DataInput)((Object)in)).readInt();
            return new TableSegmentInfo(requestId, segmentName, startOffset, segmentLength, entryCount, keyLength);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "startOffset", "length", "entryCount", "keyLength"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableSegmentInfo(long requestId, String segmentName, long startOffset, long length, long entryCount, int keyLength) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.startOffset = startOffset;
            this.length = length;
            this.entryCount = entryCount;
            this.keyLength = keyLength;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEntryCount() {
            return this.entryCount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getKeyLength() {
            return this.keyLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableSegmentInfo)) {
                return false;
            }
            TableSegmentInfo other = (TableSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            if (this.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.getEntryCount() != other.getEntryCount()) {
                return false;
            }
            return this.getKeyLength() == other.getKeyLength();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            long $length = this.getLength();
            result = result * 59 + (int)($length >>> 32 ^ $length);
            long $entryCount = this.getEntryCount();
            result = result * 59 + (int)($entryCount >>> 32 ^ $entryCount);
            result = result * 59 + this.getKeyLength();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.TableSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", startOffset=" + this.getStartOffset() + ", length=" + this.getLength() + ", entryCount=" + this.getEntryCount() + ", keyLength=" + this.getKeyLength() + ")";
        }
    }

    public static final class GetTableSegmentInfo
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.GET_TABLE_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.getTableSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new GetTableSegmentInfo(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GetTableSegmentInfo(long requestId, String segmentName, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetTableSegmentInfo)) {
                return false;
            }
            GetTableSegmentInfo other = (GetTableSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.GetTableSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ")";
        }
    }

    public static final class CreateSegment
    implements Request,
    WireCommand {
        public static final byte NO_SCALE = ScaleType.NoScaling.getValue();
        public static final byte IN_KBYTES_PER_SEC = ScaleType.Throughput.getValue();
        public static final byte IN_EVENTS_PER_SEC = ScaleType.EventRate.getValue();
        final WireCommandType type = WireCommandType.CREATE_SEGMENT;
        final long requestId;
        final String segment;
        final byte scaleType;
        final int targetRate;
        final String delegationToken;
        final long rolloverSizeBytes;

        @Override
        public void process(RequestProcessor cp) {
            cp.createSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeInt(this.targetRate);
            out.writeByte(this.scaleType);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeLong(this.rolloverSizeBytes);
        }

        public static <T extends InputStream> WireCommand readFrom(T in, int length) throws IOException {
            long requestId = ((DataInput)((Object)in)).readLong();
            String segment = ((DataInput)((Object)in)).readUTF();
            int desiredRate = ((DataInput)((Object)in)).readInt();
            byte scaleType = ((DataInput)((Object)in)).readByte();
            String delegationToken = ((DataInput)((Object)in)).readUTF();
            long rolloverSizeBytes = 0L;
            if (in.available() >= 8) {
                rolloverSizeBytes = ((DataInput)((Object)in)).readLong();
            }
            return new CreateSegment(requestId, segment, scaleType, desiredRate, delegationToken, rolloverSizeBytes);
        }

        @ConstructorProperties(value={"requestId", "segment", "scaleType", "targetRate", "delegationToken", "rolloverSizeBytes"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateSegment(long requestId, String segment, byte scaleType, int targetRate, String delegationToken, long rolloverSizeBytes) {
            this.requestId = requestId;
            this.segment = segment;
            this.scaleType = scaleType;
            this.targetRate = targetRate;
            this.delegationToken = delegationToken;
            this.rolloverSizeBytes = rolloverSizeBytes;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte getScaleType() {
            return this.scaleType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getTargetRate() {
            return this.targetRate;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRolloverSizeBytes() {
            return this.rolloverSizeBytes;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateSegment)) {
                return false;
            }
            CreateSegment other = (CreateSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getScaleType() != other.getScaleType()) {
                return false;
            }
            if (this.getTargetRate() != other.getTargetRate()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            return this.getRolloverSizeBytes() == other.getRolloverSizeBytes();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            result = result * 59 + this.getScaleType();
            result = result * 59 + this.getTargetRate();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $rolloverSizeBytes = this.getRolloverSizeBytes();
            result = result * 59 + (int)($rolloverSizeBytes >>> 32 ^ $rolloverSizeBytes);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.CreateSegment(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", scaleType=" + this.getScaleType() + ", targetRate=" + this.getTargetRate() + ", rolloverSizeBytes=" + this.getRolloverSizeBytes() + ")";
        }
    }

    public static final class StreamSegmentInfo
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.STREAM_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final boolean exists;
        final boolean isSealed;
        final boolean isDeleted;
        final long lastModified;
        final long writeOffset;
        final long startOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.streamSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeBoolean(this.exists);
            out.writeBoolean(this.isSealed);
            out.writeBoolean(this.isDeleted);
            out.writeLong(this.lastModified);
            out.writeLong(this.writeOffset);
            out.writeLong(this.startOffset);
        }

        public static <T extends InputStream> WireCommand readFrom(T in, int length) throws IOException {
            long requestId = ((DataInput)((Object)in)).readLong();
            String segmentName = ((DataInput)((Object)in)).readUTF();
            boolean exists = ((DataInput)((Object)in)).readBoolean();
            boolean isSealed = ((DataInput)((Object)in)).readBoolean();
            boolean isDeleted = ((DataInput)((Object)in)).readBoolean();
            long lastModified = ((DataInput)((Object)in)).readLong();
            long segmentLength = ((DataInput)((Object)in)).readLong();
            long startOffset = 0L;
            if (in.available() >= 8) {
                startOffset = ((DataInput)((Object)in)).readLong();
            }
            return new StreamSegmentInfo(requestId, segmentName, exists, isSealed, isDeleted, lastModified, segmentLength, startOffset);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "exists", "isSealed", "isDeleted", "lastModified", "writeOffset", "startOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentInfo(long requestId, String segmentName, boolean exists, boolean isSealed, boolean isDeleted, long lastModified, long writeOffset, long startOffset) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.exists = exists;
            this.isSealed = isSealed;
            this.isDeleted = isDeleted;
            this.lastModified = lastModified;
            this.writeOffset = writeOffset;
            this.startOffset = startOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean exists() {
            return this.exists;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isSealed() {
            return this.isSealed;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastModified() {
            return this.lastModified;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getWriteOffset() {
            return this.writeOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StreamSegmentInfo)) {
                return false;
            }
            StreamSegmentInfo other = (StreamSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            if (this.exists() != other.exists()) {
                return false;
            }
            if (this.isSealed() != other.isSealed()) {
                return false;
            }
            if (this.isDeleted() != other.isDeleted()) {
                return false;
            }
            if (this.getLastModified() != other.getLastModified()) {
                return false;
            }
            if (this.getWriteOffset() != other.getWriteOffset()) {
                return false;
            }
            return this.getStartOffset() == other.getStartOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            result = result * 59 + (this.exists() ? 79 : 97);
            result = result * 59 + (this.isSealed() ? 79 : 97);
            result = result * 59 + (this.isDeleted() ? 79 : 97);
            long $lastModified = this.getLastModified();
            result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
            long $writeOffset = this.getWriteOffset();
            result = result * 59 + (int)($writeOffset >>> 32 ^ $writeOffset);
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.StreamSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", exists=" + this.exists() + ", isSealed=" + this.isSealed() + ", isDeleted=" + this.isDeleted() + ", lastModified=" + this.getLastModified() + ", writeOffset=" + this.getWriteOffset() + ", startOffset=" + this.getStartOffset() + ")";
        }
    }

    public static final class GetStreamSegmentInfo
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.GET_STREAM_SEGMENT_INFO;
        final long requestId;
        final String segmentName;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.getStreamSegmentInfo(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new GetStreamSegmentInfo(requestId, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GetStreamSegmentInfo(long requestId, String segmentName, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetStreamSegmentInfo)) {
                return false;
            }
            GetStreamSegmentInfo other = (GetStreamSegmentInfo)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.GetStreamSegmentInfo(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ")";
        }
    }

    public static final class SegmentAttributeUpdated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ATTRIBUTE_UPDATED;
        final long requestId;
        final boolean success;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAttributeUpdated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeBoolean(this.success);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            boolean success = in.readBoolean();
            return new SegmentAttributeUpdated(requestId, success);
        }

        @ConstructorProperties(value={"requestId", "success"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentAttributeUpdated(long requestId, boolean success) {
            this.requestId = requestId;
            this.success = success;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAttributeUpdated)) {
                return false;
            }
            SegmentAttributeUpdated other = (SegmentAttributeUpdated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            return this.isSuccess() == other.isSuccess();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentAttributeUpdated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", success=" + this.isSuccess() + ")";
        }
    }

    public static final class UpdateSegmentAttribute
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.UPDATE_SEGMENT_ATTRIBUTE;
        final long requestId;
        final String segmentName;
        final UUID attributeId;
        final long newValue;
        final long expectedValue;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.updateSegmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeLong(this.attributeId.getMostSignificantBits());
            out.writeLong(this.attributeId.getLeastSignificantBits());
            out.writeLong(this.newValue);
            out.writeLong(this.expectedValue);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID attributeId = new UUID(in.readLong(), in.readLong());
            long newValue = in.readLong();
            long excpecteValue = in.readLong();
            String delegationToken = in.readUTF();
            return new UpdateSegmentAttribute(requestId, segment, attributeId, newValue, excpecteValue, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "attributeId", "newValue", "expectedValue", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UpdateSegmentAttribute(long requestId, String segmentName, UUID attributeId, long newValue, long expectedValue, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.attributeId = attributeId;
            this.newValue = newValue;
            this.expectedValue = expectedValue;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getAttributeId() {
            return this.attributeId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getNewValue() {
            return this.newValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getExpectedValue() {
            return this.expectedValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateSegmentAttribute)) {
                return false;
            }
            UpdateSegmentAttribute other = (UpdateSegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            UUID this$attributeId = this.getAttributeId();
            UUID other$attributeId = other.getAttributeId();
            if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
                return false;
            }
            if (this.getNewValue() != other.getNewValue()) {
                return false;
            }
            if (this.getExpectedValue() != other.getExpectedValue()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            UUID $attributeId = this.getAttributeId();
            result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
            long $newValue = this.getNewValue();
            result = result * 59 + (int)($newValue >>> 32 ^ $newValue);
            long $expectedValue = this.getExpectedValue();
            result = result * 59 + (int)($expectedValue >>> 32 ^ $expectedValue);
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.UpdateSegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", attributeId=" + this.getAttributeId() + ", newValue=" + this.getNewValue() + ", expectedValue=" + this.getExpectedValue() + ")";
        }
    }

    public static final class SegmentAttribute
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ATTRIBUTE;
        final long requestId;
        final long value;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeLong(this.value);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            long value = in.readLong();
            return new SegmentAttribute(requestId, value);
        }

        @ConstructorProperties(value={"requestId", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentAttribute(long requestId, long value) {
            this.requestId = requestId;
            this.value = value;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAttribute)) {
                return false;
            }
            SegmentAttribute other = (SegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            return this.getValue() == other.getValue();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            long $value = this.getValue();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", value=" + this.getValue() + ")";
        }
    }

    public static final class GetSegmentAttribute
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.GET_SEGMENT_ATTRIBUTE;
        final long requestId;
        final String segmentName;
        final UUID attributeId;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.getSegmentAttribute(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segmentName);
            out.writeLong(this.attributeId.getMostSignificantBits());
            out.writeLong(this.attributeId.getLeastSignificantBits());
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID attributeId = new UUID(in.readLong(), in.readLong());
            String delegationToken = in.readUTF();
            return new GetSegmentAttribute(requestId, segment, attributeId, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "segmentName", "attributeId", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GetSegmentAttribute(long requestId, String segmentName, UUID attributeId, String delegationToken) {
            this.requestId = requestId;
            this.segmentName = segmentName;
            this.attributeId = attributeId;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegmentName() {
            return this.segmentName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getAttributeId() {
            return this.attributeId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetSegmentAttribute)) {
                return false;
            }
            GetSegmentAttribute other = (GetSegmentAttribute)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segmentName = this.getSegmentName();
            String other$segmentName = other.getSegmentName();
            if (this$segmentName == null ? other$segmentName != null : !this$segmentName.equals(other$segmentName)) {
                return false;
            }
            UUID this$attributeId = this.getAttributeId();
            UUID other$attributeId = other.getAttributeId();
            if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segmentName = this.getSegmentName();
            result = result * 59 + ($segmentName == null ? 43 : $segmentName.hashCode());
            UUID $attributeId = this.getAttributeId();
            result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.GetSegmentAttribute(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segmentName=" + this.getSegmentName() + ", attributeId=" + this.getAttributeId() + ")";
        }
    }

    @NotThreadSafe
    public static final class SegmentRead
    extends ReleasableCommand
    implements Reply {
        final WireCommandType type = WireCommandType.SEGMENT_READ;
        final String segment;
        final long offset;
        final boolean atTail;
        final boolean endOfSegment;
        final ByteBuf data;
        final long requestId;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentRead(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeUTF(this.segment);
            out.writeLong(this.offset);
            out.writeBoolean(this.atTail);
            out.writeBoolean(this.endOfSegment);
            int dataLength = this.data.readableBytes();
            out.writeInt(dataLength);
            this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), dataLength);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            String segment = in.readUTF();
            long offset = in.readLong();
            boolean atTail = in.readBoolean();
            boolean endOfSegment = in.readBoolean();
            int dataLength = in.readInt();
            if (dataLength > length) {
                throw new BufferOverflowException();
            }
            ByteBuf data = in.readFully(dataLength).retain();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentRead(segment, offset, atTail, endOfSegment, data, requestId).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.data.release();
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"segment", "offset", "atTail", "endOfSegment", "data", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentRead(String segment, long offset, boolean atTail, boolean endOfSegment, ByteBuf data, long requestId) {
            this.segment = segment;
            this.offset = offset;
            this.atTail = atTail;
            this.endOfSegment = endOfSegment;
            this.data = data;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isAtTail() {
            return this.atTail;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isEndOfSegment() {
            return this.endOfSegment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentRead(type=" + (Object)((Object)this.getType()) + ", segment=" + this.getSegment() + ", offset=" + this.getOffset() + ", atTail=" + this.isAtTail() + ", endOfSegment=" + this.isEndOfSegment() + ", data=" + this.getData() + ", requestId=" + this.getRequestId() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentRead)) {
                return false;
            }
            SegmentRead other = (SegmentRead)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.isAtTail() != other.isAtTail()) {
                return false;
            }
            if (this.isEndOfSegment() != other.isEndOfSegment()) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SegmentRead;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            result = result * 59 + (this.isAtTail() ? 79 : 97);
            result = result * 59 + (this.isEndOfSegment() ? 79 : 97);
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }
    }

    public static final class ReadSegment
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.READ_SEGMENT;
        final String segment;
        final long offset;
        final int suggestedLength;
        final String delegationToken;
        final long requestId;

        @Override
        public void process(RequestProcessor cp) {
            cp.readSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeUTF(this.segment);
            out.writeLong(this.offset);
            out.writeInt(this.suggestedLength);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            String segment = in.readUTF();
            long offset = in.readLong();
            int suggestedLength = in.readInt();
            String delegationToken = in.readUTF();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ReadSegment(segment, offset, suggestedLength, delegationToken, requestId);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"segment", "offset", "suggestedLength", "delegationToken", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReadSegment(String segment, long offset, int suggestedLength, String delegationToken, long requestId) {
            this.segment = segment;
            this.offset = offset;
            this.suggestedLength = suggestedLength;
            this.delegationToken = delegationToken;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getSuggestedLength() {
            return this.suggestedLength;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadSegment)) {
                return false;
            }
            ReadSegment other = (ReadSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.getSuggestedLength() != other.getSuggestedLength()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            result = result * 59 + this.getSuggestedLength();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ReadSegment(type=" + (Object)((Object)this.getType()) + ", segment=" + this.getSegment() + ", offset=" + this.getOffset() + ", suggestedLength=" + this.getSuggestedLength() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class StorageFlushed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.FLUSHED_TO_STORAGE;
        final long requestId;

        @Override
        public void process(ReplyProcessor cp) {
            cp.storageFlushed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            return new StorageFlushed(requestId);
        }

        @ConstructorProperties(value={"requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StorageFlushed(long requestId) {
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StorageFlushed)) {
                return false;
            }
            StorageFlushed other = (StorageFlushed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.StorageFlushed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class FlushToStorage
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.FLUSH_TO_STORAGE;
        final int containerId;
        final String delegationToken;
        final long requestId;

        @Override
        public void process(RequestProcessor cp) {
            ((AdminRequestProcessor)cp).flushToStorage(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.containerId);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            int containerId = in.readInt();
            String delegationToken = in.readUTF();
            long requestId = in.readLong();
            return new FlushToStorage(containerId, delegationToken, requestId);
        }

        @ConstructorProperties(value={"containerId", "delegationToken", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlushToStorage(int containerId, String delegationToken, long requestId) {
            this.containerId = containerId;
            this.delegationToken = delegationToken;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getContainerId() {
            return this.containerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlushToStorage)) {
                return false;
            }
            FlushToStorage other = (FlushToStorage)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getContainerId() != other.getContainerId()) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            if (this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + this.getContainerId();
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.FlushToStorage(type=" + (Object)((Object)this.getType()) + ", containerId=" + this.getContainerId() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class ConditionalCheckFailed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.CONDITIONAL_CHECK_FAILED;
        final UUID writerId;
        final long eventNumber;
        final long requestId;

        @Override
        public void process(ReplyProcessor cp) {
            cp.conditionalCheckFailed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long offset = in.readLong();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ConditionalCheckFailed(writerId, offset, requestId);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConditionalCheckFailed(UUID writerId, long eventNumber, long requestId) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalCheckFailed)) {
                return false;
            }
            ConditionalCheckFailed other = (ConditionalCheckFailed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ConditionalCheckFailed(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", requestId=" + this.getRequestId() + ")";
        }
    }

    public static final class DataAppended
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.DATA_APPENDED;
        final long requestId;
        final UUID writerId;
        final long eventNumber;
        final long previousEventNumber;
        final long currentSegmentWriteOffset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.dataAppended(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.previousEventNumber);
            out.writeLong(this.requestId);
            out.writeLong(this.currentSegmentWriteOffset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            long previousEventNumber = in.available() >= 8 ? in.readLong() : -1L;
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            long currentSegmentWriteOffset = in.available() >= 8 ? in.readLong() : -1L;
            return new DataAppended(requestId, writerId, eventNumber, previousEventNumber, currentSegmentWriteOffset);
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @ConstructorProperties(value={"requestId", "writerId", "eventNumber", "previousEventNumber", "currentSegmentWriteOffset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DataAppended(long requestId, UUID writerId, long eventNumber, long previousEventNumber, long currentSegmentWriteOffset) {
            this.requestId = requestId;
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.previousEventNumber = previousEventNumber;
            this.currentSegmentWriteOffset = currentSegmentWriteOffset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getPreviousEventNumber() {
            return this.previousEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getCurrentSegmentWriteOffset() {
            return this.currentSegmentWriteOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataAppended)) {
                return false;
            }
            DataAppended other = (DataAppended)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            if (this.getPreviousEventNumber() != other.getPreviousEventNumber()) {
                return false;
            }
            return this.getCurrentSegmentWriteOffset() == other.getCurrentSegmentWriteOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $previousEventNumber = this.getPreviousEventNumber();
            result = result * 59 + (int)($previousEventNumber >>> 32 ^ $previousEventNumber);
            long $currentSegmentWriteOffset = this.getCurrentSegmentWriteOffset();
            result = result * 59 + (int)($currentSegmentWriteOffset >>> 32 ^ $currentSegmentWriteOffset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.DataAppended(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", previousEventNumber=" + this.getPreviousEventNumber() + ", currentSegmentWriteOffset=" + this.getCurrentSegmentWriteOffset() + ")";
        }
    }

    public static final class AppendSetup
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.APPEND_SETUP;
        final long requestId;
        final String segment;
        final UUID writerId;
        final long lastEventNumber;

        @Override
        public void process(ReplyProcessor cp) {
            cp.appendSetup(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.lastEventNumber);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long lastEventNumber = in.readLong();
            return new AppendSetup(requestId, segment, writerId, lastEventNumber);
        }

        @ConstructorProperties(value={"requestId", "segment", "writerId", "lastEventNumber"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendSetup(long requestId, String segment, UUID writerId, long lastEventNumber) {
            this.requestId = requestId;
            this.segment = segment;
            this.writerId = writerId;
            this.lastEventNumber = lastEventNumber;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendSetup)) {
                return false;
            }
            AppendSetup other = (AppendSetup)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            return this.getLastEventNumber() == other.getLastEventNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.AppendSetup(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", writerId=" + this.getWriterId() + ", lastEventNumber=" + this.getLastEventNumber() + ")";
        }
    }

    public static final class ConditionalAppend
    extends ReleasableCommand
    implements Request {
        final WireCommandType type = WireCommandType.CONDITIONAL_APPEND;
        final UUID writerId;
        final long eventNumber;
        final long expectedOffset;
        final Event event;
        final long requestId;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeLong(this.expectedOffset);
            this.event.writeFields(out);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            long expectedOffset = in.readLong();
            Event event = ConditionalAppend.readEvent(in, length);
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new ConditionalAppend(writerId, eventNumber, expectedOffset, event, requestId).requireRelease();
        }

        private static Event readEvent(EnhancedByteBufInputStream in, int length) throws IOException {
            int typeCode = in.readInt();
            if (typeCode != WireCommandType.EVENT.getCode()) {
                throw new InvalidMessageException("Was expecting EVENT but found: " + typeCode);
            }
            int eventLength = in.readInt();
            if (eventLength > length - 8) {
                throw new InvalidMessageException("Was expecting length: " + length + " but found: " + eventLength);
            }
            return new Event(in.readFully(eventLength).retain());
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        @Override
        public void process(RequestProcessor cp) {
            throw new UnsupportedOperationException();
        }

        @Override
        void releaseInternal() {
            this.event.data.release();
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "expectedOffset", "event", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConditionalAppend(UUID writerId, long eventNumber, long expectedOffset, Event event, long requestId) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.expectedOffset = expectedOffset;
            this.event = event;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getExpectedOffset() {
            return this.expectedOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Event getEvent() {
            return this.event;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.ConditionalAppend(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", eventNumber=" + this.getEventNumber() + ", expectedOffset=" + this.getExpectedOffset() + ", event=" + this.getEvent() + ", requestId=" + this.getRequestId() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalAppend)) {
                return false;
            }
            ConditionalAppend other = (ConditionalAppend)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getEventNumber() != other.getEventNumber()) {
                return false;
            }
            if (this.getExpectedOffset() != other.getExpectedOffset()) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConditionalAppend;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            long $expectedOffset = this.getExpectedOffset();
            result = result * 59 + (int)($expectedOffset >>> 32 ^ $expectedOffset);
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }
    }

    public static final class AppendBlockEnd
    extends ReleasableCommand {
        final WireCommandType type = WireCommandType.APPEND_BLOCK_END;
        final UUID writerId;
        final int sizeOfWholeEvents;
        final ByteBuf data;
        final int numEvents;
        final long lastEventNumber;
        final long requestId;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeInt(this.sizeOfWholeEvents);
            if (this.data == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.data.readableBytes());
                this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
            }
            out.writeInt(this.numEvents);
            out.writeLong(this.lastEventNumber);
            out.writeLong(this.requestId);
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            int sizeOfHeaderlessAppends = in.readInt();
            int dataLength = in.readInt();
            ByteBuf data = dataLength > 0 ? in.readFully(dataLength) : Unpooled.EMPTY_BUFFER;
            int numEvents = in.readInt();
            long lastEventNumber = in.readLong();
            long requestId = in.available() >= 8 ? in.readLong() : -1L;
            return new AppendBlockEnd(writerId, sizeOfHeaderlessAppends, data.retain(), numEvents, lastEventNumber, requestId).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.data.release();
        }

        @ConstructorProperties(value={"writerId", "sizeOfWholeEvents", "data", "numEvents", "lastEventNumber", "requestId"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendBlockEnd(UUID writerId, int sizeOfWholeEvents, ByteBuf data, int numEvents, long lastEventNumber, long requestId) {
            this.writerId = writerId;
            this.sizeOfWholeEvents = sizeOfWholeEvents;
            this.data = data;
            this.numEvents = numEvents;
            this.lastEventNumber = lastEventNumber;
            this.requestId = requestId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getSizeOfWholeEvents() {
            return this.sizeOfWholeEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getNumEvents() {
            return this.numEvents;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getLastEventNumber() {
            return this.lastEventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.AppendBlockEnd(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", sizeOfWholeEvents=" + this.getSizeOfWholeEvents() + ", data=" + this.getData() + ", numEvents=" + this.getNumEvents() + ", lastEventNumber=" + this.getLastEventNumber() + ", requestId=" + this.getRequestId() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendBlockEnd)) {
                return false;
            }
            AppendBlockEnd other = (AppendBlockEnd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            if (this.getSizeOfWholeEvents() != other.getSizeOfWholeEvents()) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            if (this.getNumEvents() != other.getNumEvents()) {
                return false;
            }
            if (this.getLastEventNumber() != other.getLastEventNumber()) {
                return false;
            }
            return this.getRequestId() == other.getRequestId();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppendBlockEnd;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            result = result * 59 + this.getSizeOfWholeEvents();
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            result = result * 59 + this.getNumEvents();
            long $lastEventNumber = this.getLastEventNumber();
            result = result * 59 + (int)($lastEventNumber >>> 32 ^ $lastEventNumber);
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            return result;
        }
    }

    public static final class AppendBlock
    extends ReleasableCommand {
        final WireCommandType type = WireCommandType.APPEND_BLOCK;
        final UUID writerId;
        final ByteBuf data;

        public AppendBlock(UUID writerId) {
            this.writerId = writerId;
            this.data = Unpooled.EMPTY_BUFFER;
        }

        @VisibleForTesting
        public AppendBlock(UUID writerId, ByteBuf data) {
            this.writerId = writerId;
            this.data = data;
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            ByteBuf data = in.readFully(length - 16).retain();
            return new AppendBlock(writerId, data).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.data.release();
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.AppendBlock(type=" + (Object)((Object)this.getType()) + ", writerId=" + this.getWriterId() + ", data=" + this.getData() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppendBlock)) {
                return false;
            }
            AppendBlock other = (AppendBlock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppendBlock;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }
    }

    public static final class SetupAppend
    implements Request,
    WireCommand {
        final WireCommandType type = WireCommandType.SETUP_APPEND;
        final long requestId;
        final UUID writerId;
        final String segment;
        final String delegationToken;

        @Override
        public void process(RequestProcessor cp) {
            cp.setupAppend(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeUTF(this.segment);
            out.writeUTF(this.delegationToken == null ? WireCommands.EMPTY_STACK_TRACE : this.delegationToken);
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            long requestId = in.readLong();
            UUID uuid = new UUID(in.readLong(), in.readLong());
            String segment = in.readUTF();
            String delegationToken = in.readUTF();
            return new SetupAppend(requestId, uuid, segment, delegationToken);
        }

        @ConstructorProperties(value={"requestId", "writerId", "segment", "delegationToken"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SetupAppend(long requestId, UUID writerId, String segment, String delegationToken) {
            this.requestId = requestId;
            this.writerId = writerId;
            this.segment = segment;
            this.delegationToken = delegationToken;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDelegationToken() {
            return this.delegationToken;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetupAppend)) {
                return false;
            }
            SetupAppend other = (SetupAppend)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$delegationToken = this.getDelegationToken();
            String other$delegationToken = other.getDelegationToken();
            return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $delegationToken = this.getDelegationToken();
            result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SetupAppend(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", writerId=" + this.getWriterId() + ", segment=" + this.getSegment() + ")";
        }
    }

    public static final class Event
    implements WireCommand {
        final WireCommandType type = WireCommandType.EVENT;
        final ByteBuf data;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.type.getCode());
            out.writeInt(this.data.readableBytes());
            this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
        }

        public ByteBuf getAsByteBuf() {
            ByteBuf header = Unpooled.buffer((int)8, (int)8);
            header.writeInt(this.type.getCode());
            header.writeInt(this.data.readableBytes());
            return Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])new ByteBuf[]{header, this.data});
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Event(ByteBuf data) {
            this.data = data;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event other = (Event)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.Event(type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
        }
    }

    public static final class PartialEvent
    extends ReleasableCommand {
        final WireCommandType type = WireCommandType.PARTIAL_EVENT;
        final ByteBuf data;

        @Override
        public void writeFields(DataOutput out) throws IOException {
            this.data.getBytes(this.data.readerIndex(), (OutputStream)((Object)out), this.data.readableBytes());
        }

        public static WireCommand readFrom(EnhancedByteBufInputStream in, int length) throws IOException {
            return new PartialEvent(in.readFully(length).retain()).requireRelease();
        }

        @Override
        void releaseInternal() {
            this.data.release();
        }

        @ConstructorProperties(value={"data"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PartialEvent(ByteBuf data) {
            this.data = data;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ByteBuf getData() {
            return this.data;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.PartialEvent(type=" + (Object)((Object)this.getType()) + ", data=" + this.getData() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialEvent)) {
                return false;
            }
            PartialEvent other = (PartialEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            ByteBuf this$data = this.getData();
            ByteBuf other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartialEvent;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            ByteBuf $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }
    }

    public static final class Padding
    implements WireCommand {
        final WireCommandType type = WireCommandType.PADDING;
        final int length;

        Padding(int length) {
            Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
            this.length = length;
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            int i;
            for (i = 0; i < this.length / 8; ++i) {
                out.writeLong(0L);
            }
            for (i = 0; i < this.length % 8; ++i) {
                out.writeByte(0);
            }
        }

        public static WireCommand readFrom(DataInput in, int length) throws IOException {
            int skipBytes;
            for (int skipped = 0; skipped < length; skipped += skipBytes) {
                skipBytes = in.skipBytes(length - skipped);
                if (skipBytes >= 0) continue;
                throw new CorruptedFrameException("Not enough bytes in buffer. Was attempting to read: " + length);
            }
            return new Padding(length);
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getLength() {
            return this.length;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Padding)) {
                return false;
            }
            Padding other = (Padding)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            return this.getLength() == other.getLength();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + this.getLength();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.Padding(type=" + (Object)((Object)this.getType()) + ", length=" + this.getLength() + ")";
        }
    }

    public static final class OperationUnsupported
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.OPERATION_UNSUPPORTED;
        final long requestId;
        final String operationName;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.operationUnsupported(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.operationName);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String operationName = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new OperationUnsupported(requestId, operationName, serverStackTrace);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "operationName", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public OperationUnsupported(long requestId, String operationName, String serverStackTrace) {
            this.requestId = requestId;
            this.operationName = operationName;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationUnsupported)) {
                return false;
            }
            OperationUnsupported other = (OperationUnsupported)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$operationName = this.getOperationName();
            String other$operationName = other.getOperationName();
            if (this$operationName == null ? other$operationName != null : !this$operationName.equals(other$operationName)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $operationName = this.getOperationName();
            result = result * 59 + ($operationName == null ? 43 : $operationName.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.OperationUnsupported(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", operationName=" + this.getOperationName() + ", serverStackTrace=" + this.getServerStackTrace() + ")";
        }
    }

    public static final class InvalidEventNumber
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.INVALID_EVENT_NUMBER;
        final UUID writerId;
        final long eventNumber;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.invalidEventNumber(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.writerId.getMostSignificantBits());
            out.writeLong(this.writerId.getLeastSignificantBits());
            out.writeLong(this.eventNumber);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            UUID writerId = new UUID(in.readLong(), in.readLong());
            long eventNumber = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new InvalidEventNumber(writerId, eventNumber, serverStackTrace);
        }

        public String toString() {
            return "Invalid event number: " + this.eventNumber + " for writer: " + this.writerId;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public long getRequestId() {
            return this.eventNumber;
        }

        @ConstructorProperties(value={"writerId", "eventNumber", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InvalidEventNumber(UUID writerId, long eventNumber, String serverStackTrace) {
            this.writerId = writerId;
            this.eventNumber = eventNumber;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public UUID getWriterId() {
            return this.writerId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getEventNumber() {
            return this.eventNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvalidEventNumber)) {
                return false;
            }
            InvalidEventNumber other = (InvalidEventNumber)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            UUID this$writerId = this.getWriterId();
            UUID other$writerId = other.getWriterId();
            if (this$writerId == null ? other$writerId != null : !((Object)this$writerId).equals(other$writerId)) {
                return false;
            }
            return this.getEventNumber() == other.getEventNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            UUID $writerId = this.getWriterId();
            result = result * 59 + ($writerId == null ? 43 : ((Object)$writerId).hashCode());
            long $eventNumber = this.getEventNumber();
            result = result * 59 + (int)($eventNumber >>> 32 ^ $eventNumber);
            return result;
        }
    }

    public static final class TableSegmentNotEmpty
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.TABLE_SEGMENT_NOT_EMPTY;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.tableSegmentNotEmpty(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.readUTF();
            return new TableSegmentNotEmpty(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Table Segment is not empty: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableSegmentNotEmpty(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableSegmentNotEmpty)) {
                return false;
            }
            TableSegmentNotEmpty other = (TableSegmentNotEmpty)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class NoSuchSegment
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.NO_SUCH_SEGMENT;
        final long requestId;
        final String segment;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.noSuchSegment(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new NoSuchSegment(requestId, segment, serverStackTrace, offset);
        }

        public String toString() {
            return "No such segment: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public NoSuchSegment(long requestId, String segment, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NoSuchSegment)) {
                return false;
            }
            NoSuchSegment other = (NoSuchSegment)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }
    }

    public static final class SegmentAlreadyExists
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_ALREADY_EXISTS;
        final long requestId;
        final String segment;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentAlreadyExists(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new SegmentAlreadyExists(requestId, segment, serverStackTrace);
        }

        public String toString() {
            return "Segment already exists: " + this.segment;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentAlreadyExists(long requestId, String segment, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentAlreadyExists)) {
                return false;
            }
            SegmentAlreadyExists other = (SegmentAlreadyExists)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }
    }

    public static final class SegmentIsTruncated
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_IS_TRUNCATED;
        final long requestId;
        final String segment;
        final long startOffset;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentIsTruncated(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeLong(this.startOffset);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            long startOffset = in.readLong();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentIsTruncated(requestId, segment, startOffset, serverStackTrace, offset);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "startOffset", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIsTruncated(long requestId, String segment, long startOffset, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.startOffset = startOffset;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getStartOffset() {
            return this.startOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentIsTruncated)) {
                return false;
            }
            SegmentIsTruncated other = (SegmentIsTruncated)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            if (this.getStartOffset() != other.getStartOffset()) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            long $startOffset = this.getStartOffset();
            result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentIsTruncated(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", startOffset=" + this.getStartOffset() + ", serverStackTrace=" + this.getServerStackTrace() + ", offset=" + this.getOffset() + ")";
        }
    }

    public static final class SegmentIsSealed
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.SEGMENT_IS_SEALED;
        final long requestId;
        final String segment;
        final String serverStackTrace;
        final long offset;

        @Override
        public void process(ReplyProcessor cp) {
            cp.segmentIsSealed(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.serverStackTrace);
            out.writeLong(this.offset);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            long offset = in.available() >= 8 ? in.readLong() : -1L;
            return new SegmentIsSealed(requestId, segment, serverStackTrace, offset);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "serverStackTrace", "offset"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentIsSealed(long requestId, String segment, String serverStackTrace, long offset) {
            this.requestId = requestId;
            this.segment = segment;
            this.serverStackTrace = serverStackTrace;
            this.offset = offset;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentIsSealed)) {
                return false;
            }
            SegmentIsSealed other = (SegmentIsSealed)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            if (this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.SegmentIsSealed(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", serverStackTrace=" + this.getServerStackTrace() + ", offset=" + this.getOffset() + ")";
        }
    }

    public static final class WrongHost
    implements Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.WRONG_HOST;
        final long requestId;
        final String segment;
        final String correctHost;
        final String serverStackTrace;

        @Override
        public void process(ReplyProcessor cp) {
            cp.wrongHost(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeLong(this.requestId);
            out.writeUTF(this.segment);
            out.writeUTF(this.correctHost);
            out.writeUTF(this.serverStackTrace);
        }

        public static WireCommand readFrom(ByteBufInputStream in, int length) throws IOException {
            long requestId = in.readLong();
            String segment = in.readUTF();
            String correctHost = in.readUTF();
            String serverStackTrace = in.available() > 0 ? in.readUTF() : WireCommands.EMPTY_STACK_TRACE;
            return new WrongHost(requestId, segment, correctHost, serverStackTrace);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @ConstructorProperties(value={"requestId", "segment", "correctHost", "serverStackTrace"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WrongHost(long requestId, String segment, String correctHost, String serverStackTrace) {
            this.requestId = requestId;
            this.segment = segment;
            this.correctHost = correctHost;
            this.serverStackTrace = serverStackTrace;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getRequestId() {
            return this.requestId;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getCorrectHost() {
            return this.correctHost;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getServerStackTrace() {
            return this.serverStackTrace;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrongHost)) {
                return false;
            }
            WrongHost other = (WrongHost)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getRequestId() != other.getRequestId()) {
                return false;
            }
            String this$segment = this.getSegment();
            String other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !this$segment.equals(other$segment)) {
                return false;
            }
            String this$correctHost = this.getCorrectHost();
            String other$correctHost = other.getCorrectHost();
            if (this$correctHost == null ? other$correctHost != null : !this$correctHost.equals(other$correctHost)) {
                return false;
            }
            String this$serverStackTrace = this.getServerStackTrace();
            String other$serverStackTrace = other.getServerStackTrace();
            return !(this$serverStackTrace == null ? other$serverStackTrace != null : !this$serverStackTrace.equals(other$serverStackTrace));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            long $requestId = this.getRequestId();
            result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
            String $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : $segment.hashCode());
            String $correctHost = this.getCorrectHost();
            result = result * 59 + ($correctHost == null ? 43 : $correctHost.hashCode());
            String $serverStackTrace = this.getServerStackTrace();
            result = result * 59 + ($serverStackTrace == null ? 43 : $serverStackTrace.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.WrongHost(type=" + (Object)((Object)this.getType()) + ", requestId=" + this.getRequestId() + ", segment=" + this.getSegment() + ", correctHost=" + this.getCorrectHost() + ", serverStackTrace=" + this.getServerStackTrace() + ")";
        }
    }

    public static final class Hello
    implements Request,
    Reply,
    WireCommand {
        final WireCommandType type = WireCommandType.HELLO;
        final int highVersion;
        final int lowVersion;

        @Override
        public void process(RequestProcessor cp) {
            cp.hello(this);
        }

        @Override
        public void process(ReplyProcessor cp) {
            cp.hello(this);
        }

        @Override
        public void writeFields(DataOutput out) throws IOException {
            out.writeInt(this.highVersion);
            out.writeInt(this.lowVersion);
        }

        public static Hello readFrom(DataInput in, int length) throws IOException {
            int highVersion = in.readInt();
            int lowVersion = in.readInt();
            return new Hello(highVersion, lowVersion);
        }

        @Override
        public long getRequestId() {
            return 0L;
        }

        @ConstructorProperties(value={"highVersion", "lowVersion"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Hello(int highVersion, int lowVersion) {
            this.highVersion = highVersion;
            this.lowVersion = lowVersion;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WireCommandType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getHighVersion() {
            return this.highVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getLowVersion() {
            return this.lowVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hello)) {
                return false;
            }
            Hello other = (Hello)o;
            WireCommandType this$type = this.getType();
            WireCommandType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.getHighVersion() != other.getHighVersion()) {
                return false;
            }
            return this.getLowVersion() == other.getLowVersion();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            WireCommandType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + this.getHighVersion();
            result = result * 59 + this.getLowVersion();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "WireCommands.Hello(type=" + (Object)((Object)this.getType()) + ", highVersion=" + this.getHighVersion() + ", lowVersion=" + this.getLowVersion() + ")";
        }
    }

    @FunctionalInterface
    static interface Constructor {
        public WireCommand readFrom(EnhancedByteBufInputStream var1, int var2) throws IOException;
    }
}

