/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.scheduler;

import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.scheduler.ExecutorServiceWorker;
import io.micrometer.shaded.reactor.core.scheduler.ReactorThreadFactory;
import io.micrometer.shaded.reactor.core.scheduler.Scheduler;
import io.micrometer.shaded.reactor.core.scheduler.Schedulers;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

final class SingleScheduler
implements Scheduler,
Supplier<ScheduledExecutorService>,
Scannable {
    static final AtomicLong COUNTER = new AtomicLong();
    final ThreadFactory factory;
    volatile ScheduledExecutorService executor;
    static final AtomicReferenceFieldUpdater<SingleScheduler, ScheduledExecutorService> EXECUTORS = AtomicReferenceFieldUpdater.newUpdater(SingleScheduler.class, ScheduledExecutorService.class, "executor");
    static final ScheduledExecutorService TERMINATED = Executors.newSingleThreadScheduledExecutor();

    SingleScheduler(ThreadFactory factory) {
        this.factory = factory;
        this.init();
    }

    @Override
    public ScheduledExecutorService get() {
        ScheduledThreadPoolExecutor e = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, this.factory);
        e.setRemoveOnCancelPolicy(true);
        e.setMaximumPoolSize(1);
        return e;
    }

    private void init() {
        EXECUTORS.lazySet(this, Schedulers.decorateExecutorService(this, this.get()));
    }

    @Override
    public boolean isDisposed() {
        return this.executor == TERMINATED;
    }

    @Override
    public void start() {
        ScheduledExecutorService a;
        ExecutorService b = null;
        do {
            if ((a = this.executor) != TERMINATED) {
                if (b != null) {
                    b.shutdownNow();
                }
                return;
            }
            if (b != null) continue;
            b = Schedulers.decorateExecutorService(this, this.get());
        } while (!EXECUTORS.compareAndSet(this, a, (ScheduledExecutorService)b));
    }

    @Override
    public void dispose() {
        ScheduledExecutorService a = this.executor;
        if (a != TERMINATED && (a = EXECUTORS.getAndSet(this, TERMINATED)) != TERMINATED) {
            a.shutdownNow();
        }
    }

    @Override
    public Disposable schedule(Runnable task) {
        return Schedulers.directSchedule(this.executor, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return Schedulers.directSchedule(this.executor, task, delay, unit);
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return Schedulers.directSchedulePeriodically(this.executor, task, initialDelay, period, unit);
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("single").append('(');
        if (this.factory instanceof ReactorThreadFactory) {
            ts.append('\"').append(((ReactorThreadFactory)this.factory).get()).append('\"');
        }
        return ts.append(')').toString();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
            return this.isDisposed();
        }
        if (key == Scannable.Attr.NAME) {
            return this.toString();
        }
        if (key == Scannable.Attr.CAPACITY || key == Scannable.Attr.BUFFERED) {
            return 1;
        }
        return Schedulers.scanExecutor(this.executor, key);
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorServiceWorker(this.executor);
    }

    static {
        TERMINATED.shutdownNow();
    }
}

