/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.handler.codec.haproxy.HAProxyMessage;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.tcp.InetSocketAddressUtil;
import java.net.InetSocketAddress;

final class HAProxyMessageReader
extends ChannelInboundHandlerAdapter {
    private static final boolean hasProxyProtocol;

    HAProxyMessageReader() {
    }

    public static boolean hasProxyProtocol() {
        return hasProxyProtocol;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage = (HAProxyMessage)msg;
            if (proxyMessage.sourceAddress() != null && proxyMessage.sourcePort() != 0) {
                InetSocketAddress remoteAddress = InetSocketAddressUtil.createUnresolved(proxyMessage.sourceAddress(), proxyMessage.sourcePort());
                ctx.channel().attr(ConnectionInfo.REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).set(remoteAddress);
            }
            ctx.channel().pipeline().remove(this);
            ctx.read();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    static {
        boolean proxyProtocolCheck = true;
        try {
            Class.forName("io.micrometer.shaded.io.netty.handler.codec.haproxy.HAProxyMessageDecoder");
        }
        catch (ClassNotFoundException cnfe) {
            proxyProtocolCheck = false;
        }
        hasProxyProtocol = proxyProtocolCheck;
    }
}

