/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.lang.Nullable;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class StatsdDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder amount = new DoubleAdder();
    private final TimeWindowMax max;
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> subscriber;
    private volatile boolean shutdown = false;

    StatsdDistributionSummary(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> subscriber, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, distributionStatisticConfig, scale, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.lineBuilder = lineBuilder;
        this.subscriber = subscriber;
    }

    protected void recordNonNegative(double amount) {
        if (!this.shutdown && amount >= 0.0) {
            this.count.increment();
            this.amount.add(amount);
            this.max.record(amount);
            this.subscriber.onNext(this.lineBuilder.histogram(amount));
        }
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }

    void shutdown() {
        this.shutdown = true;
    }
}

