/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.bindings.generated.api;

import io.pravega.shared.health.bindings.generated.api.HealthApiService;
import io.pravega.shared.health.bindings.generated.api.NotFoundException;
import io.pravega.shared.health.bindings.generated.api.factories.HealthApiServiceFactory;
import io.pravega.shared.health.bindings.generated.model.HealthDetails;
import io.pravega.shared.health.bindings.generated.model.HealthResult;
import io.pravega.shared.health.bindings.generated.model.HealthStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/health")
@Api(description="the health API")
public class HealthApi {
    private final HealthApiService delegate;

    public HealthApi(@Context ServletConfig servletContext) {
        String implClass;
        HealthApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("HealthApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (HealthApiService)Class.forName(implClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = HealthApiServiceFactory.getHealthApi();
        }
        this.delegate = delegate;
    }

    @GET
    @Path(value="/details/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the details of a specific health contributor.", response=HealthDetails.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of details for the health contributor with a given id.", response=HealthDetails.class), @ApiResponse(code=404, message="The health details for the contributor with given id was not found.", response=HealthDetails.class), @ApiResponse(code=500, message="Internal server error while fetching the health details for a given health contributor.", response=HealthDetails.class)})
    public Response getContributorDetails(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String id, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getContributorDetails(id, securityContext);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Return the Health of a health contributor with a given id.", response=HealthResult.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Health result of the Controller.", response=HealthResult.class), @ApiResponse(code=404, message="A health provider for the given id could not be found.", response=HealthResult.class), @ApiResponse(code=500, message="Internal server error while fetching the health for a given contributor.", response=HealthResult.class)})
    public Response getContributorHealth(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String id, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getContributorHealth(id, securityContext);
    }

    @GET
    @Path(value="/liveness/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the liveness state of the specified health contributor.", response=Boolean.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The alive status for the specified health contributor.", response=Boolean.class), @ApiResponse(code=404, message="The liveness status for the contributor with given id was not found.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the liveness state for a given health contributor.", response=Boolean.class)})
    public Response getContributorLiveness(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String id, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getContributorLiveness(id, securityContext);
    }

    @GET
    @Path(value="/readiness/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the ready state of the health contributor.", response=Boolean.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The readiness status for the health contributor with given id.", response=Boolean.class), @ApiResponse(code=404, message="The readiness status for the contributor with given id was not found.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the ready state for a given health contributor.", response=Boolean.class)})
    public Response getContributorReadiness(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String id, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getContributorReadiness(id, securityContext);
    }

    @GET
    @Path(value="/status/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the status of a specific health contributor.", response=HealthStatus.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The health status of the Controller.", response=HealthStatus.class), @ApiResponse(code=404, message="The health status for the contributor with given id was not found.", response=HealthStatus.class), @ApiResponse(code=500, message="Internal server error while fetching the health status of a given health contributor.", response=HealthStatus.class)})
    public Response getContributorStatus(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String id, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getContributorStatus(id, securityContext);
    }

    @GET
    @Path(value="/details")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the details of the Controller service.", response=HealthDetails.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of details.", response=HealthDetails.class), @ApiResponse(code=500, message="Internal server error while fetching the health details of the Controller.", response=HealthDetails.class)})
    public Response getDetails(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getDetails(securityContext);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Return the Health of the Controller service.", response=HealthResult.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The Health result of the Controller.", response=HealthResult.class), @ApiResponse(code=500, message="Internal server error while fetching the Health.", response=HealthResult.class)})
    public Response getHealth(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getHealth(securityContext);
    }

    @GET
    @Path(value="/liveness")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the liveness state of the Controller service.", response=Boolean.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The alive status.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the liveness state of the Controller.", response=Boolean.class)})
    public Response getLiveness(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getLiveness(securityContext);
    }

    @GET
    @Path(value="/readiness")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the ready state of the Controller service.", response=Boolean.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The ready status.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the ready state of the Controller.", response=Boolean.class)})
    public Response getReadiness(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getReadiness(securityContext);
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="Fetch the status of the Controller service.", response=HealthStatus.class, tags={"Health"})
    @ApiResponses(value={@ApiResponse(code=200, message="The health status of the Controller.", response=HealthStatus.class), @ApiResponse(code=500, message="Internal server error while fetching the health status of the Controller.", response=HealthStatus.class)})
    public Response getStatus(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.getStatus(securityContext);
    }
}

