/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.bindings.resources;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthException;
import io.pravega.auth.AuthHandler;
import io.pravega.common.LoggerHelpers;
import io.pravega.shared.health.ContributorNotFoundException;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthEndpoint;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.bindings.generated.api.NotFoundException;
import io.pravega.shared.health.bindings.generated.model.HealthDetails;
import io.pravega.shared.health.bindings.generated.model.HealthResult;
import io.pravega.shared.health.bindings.generated.model.HealthStatus;
import io.pravega.shared.health.bindings.v1.ApiV1;
import io.pravega.shared.rest.security.AuthHandlerManager;
import io.pravega.shared.rest.security.RESTAuthHelper;
import io.pravega.shared.security.auth.AuthorizationResource;
import io.pravega.shared.security.auth.AuthorizationResourceImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthImpl
implements ApiV1.HealthApi {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthImpl.class);
    @Context
    HttpHeaders headers;
    private final HealthEndpoint endpoint;
    private final RESTAuthHelper restAuthHelper;
    private final AuthorizationResource authorizationResource = new AuthorizationResourceImpl();

    public HealthImpl(AuthHandlerManager pravegaAuthManager, HealthEndpoint endpoint) {
        this.endpoint = endpoint;
        this.restAuthHelper = new RESTAuthHelper(pravegaAuthManager);
    }

    @Override
    public void getContributorHealth(String id, SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getHealth(id, securityContext, asyncResponse, "getContributorHealth");
    }

    @Override
    public void getHealth(SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getHealth(null, securityContext, asyncResponse, "getHealth");
    }

    private void getHealth(String id, SecurityContext securityContext, AsyncResponse asyncResponse, String method) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)method, (Object[])new Object[0]);
        this.processRequest(() -> {
            Health health = this.endpoint.getHealth(id);
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)HealthImpl.adapter(health)).build();
            asyncResponse.resume((Object)response);
        }, asyncResponse, method, traceId, id);
    }

    @Override
    public void getContributorLiveness(String id, SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getLiveness(id, securityContext, asyncResponse, "getContributorLiveness");
    }

    @Override
    public void getLiveness(SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getLiveness(null, securityContext, asyncResponse, "getLiveness");
    }

    private void getLiveness(String id, SecurityContext securityContext, AsyncResponse asyncResponse, String method) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)method, (Object[])new Object[0]);
        this.processRequest(() -> {
            boolean alive = this.endpoint.isAlive(id);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)alive).build());
        }, asyncResponse, method, traceId, id);
    }

    @Override
    public void getContributorDetails(String id, SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getDetails(id, securityContext, asyncResponse, "getDetails");
    }

    @Override
    public void getDetails(SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getDetails(null, securityContext, asyncResponse, "getDetails");
    }

    private void getDetails(String id, SecurityContext securityContext, AsyncResponse asyncResponse, String method) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)method, (Object[])new Object[0]);
        this.processRequest(() -> {
            this.restAuthHelper.authenticateAuthorize(this.getAuthorizationHeader(), this.authorizationResource.ofScopes(), AuthHandler.Permissions.READ_UPDATE);
            Map details = this.endpoint.getDetails(id);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)HealthImpl.adapter(details)).build());
        }, asyncResponse, method, traceId, id);
    }

    @Override
    public void getContributorReadiness(String id, SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getReadiness(id, securityContext, asyncResponse, "getContributorReadiness");
    }

    @Override
    public void getReadiness(SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getReadiness(null, securityContext, asyncResponse, "getReadiness");
    }

    private void getReadiness(String id, SecurityContext securityContext, AsyncResponse asyncResponse, String method) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)method, (Object[])new Object[0]);
        this.processRequest(() -> {
            boolean ready = this.endpoint.isReady(id);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)ready).build());
        }, asyncResponse, method, traceId, id);
    }

    @Override
    public void getContributorStatus(String id, SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getStatus(id, securityContext, asyncResponse, "getContributorStatus");
    }

    @Override
    public void getStatus(SecurityContext securityContext, AsyncResponse asyncResponse) throws NotFoundException {
        this.getStatus(null, securityContext, asyncResponse, "getStatus");
    }

    private void getStatus(String id, SecurityContext securityContext, AsyncResponse asyncResponse, String method) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)method, (Object[])new Object[0]);
        this.processRequest(() -> {
            Status status = this.endpoint.getStatus(id);
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)HealthImpl.adapter(status)).build());
        }, asyncResponse, method, traceId, id);
    }

    private List<String> getAuthorizationHeader() {
        return this.headers.getRequestHeader("Authorization");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(Runnable request, AsyncResponse response, String method, long traceId, String id) {
        try {
            request.run();
        }
        catch (AuthException e) {
            log.warn("Failed to complete Health request for '{}' due to authentication failure.", (Object)id);
            response.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)method, (long)traceId, (Object[])new Object[0]);
        }
        catch (ContributorNotFoundException e) {
            log.warn("No HealthContributor found with name '{}'.", (Object)id);
            response.resume((Object)Response.status((Response.Status)Response.Status.fromStatusCode((int)e.getResponseCode())).build());
            LoggerHelpers.traceLeave((Logger)log, (String)method, (long)traceId, (Object[])new Object[0]);
        }
        finally {
            LoggerHelpers.traceLeave((Logger)log, (String)method, (long)traceId, (Object[])new Object[0]);
        }
    }

    private static HealthResult adapter(Health health) {
        return new HealthResult().name(health.getName()).status(HealthImpl.adapter(health.getStatus())).liveness(health.isAlive()).readiness(health.isReady()).details(HealthImpl.adapter(health.getDetails())).children(health.getChildren().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> HealthImpl.adapter((Health)entry.getValue()))));
    }

    private static HealthDetails adapter(Map<String, Object> details) {
        HealthDetails result = new HealthDetails();
        details.forEach((key, val) -> result.put(key, val.toString()));
        return result;
    }

    private static HealthStatus adapter(Status status) {
        return HealthStatus.fromValue(status.name());
    }
}

