/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.health.bindings.v1;

import io.pravega.shared.health.bindings.generated.api.NotFoundException;
import io.pravega.shared.health.bindings.generated.model.HealthDetails;
import io.pravega.shared.health.bindings.generated.model.HealthResult;
import io.pravega.shared.health.bindings.generated.model.HealthStatus;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

public final class ApiV1 {

    @Path(value="/v1/health")
    public static interface HealthApi {
        @GET
        @Path(value="/details/{id}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the details of a specific health contributor.", response=HealthDetails.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The list of details for the health contributor with a given id.", response=HealthDetails.class), @ApiResponse(code=404, message="The health details for the contributor with given id was not found.", response=HealthDetails.class), @ApiResponse(code=500, message="Internal server error while fetching the health details for a given health contributor.", response=HealthDetails.class)})
        public void getContributorDetails(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3) throws NotFoundException;

        @GET
        @Path(value="/{id}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Return the Health of a health contributor with a given id.", response=HealthResult.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The Health result of the Controller.", response=HealthResult.class), @ApiResponse(code=404, message="A health provider for the given id could not be found.", response=HealthResult.class), @ApiResponse(code=500, message="Internal server error while fetching the health for a given contributor.", response=HealthResult.class)})
        public void getContributorHealth(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3) throws NotFoundException;

        @GET
        @Path(value="/liveness/{id}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the liveness state of the specified health contributor.", response=Boolean.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The alive status for the specified health contributor.", response=Boolean.class), @ApiResponse(code=404, message="The liveness status for the contributor with given id was not found.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the liveness state for a given health contributor.", response=Boolean.class)})
        public void getContributorLiveness(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3) throws NotFoundException;

        @GET
        @Path(value="/readiness/{id}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the ready state of the health contributor.", response=Boolean.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The readiness status for the health contributor with given id.", response=Boolean.class), @ApiResponse(code=404, message="The readiness status for the contributor with given id was not found.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the ready state for a given health contributor.", response=Boolean.class)})
        public void getContributorReadiness(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3) throws NotFoundException;

        @GET
        @Path(value="/status/{id}")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the status of a specific health contributor.", response=HealthStatus.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The health status of the Controller.", response=HealthStatus.class), @ApiResponse(code=404, message="The health status for the contributor with given id was not found.", response=HealthStatus.class), @ApiResponse(code=500, message="Internal server error while fetching the health status of a given health contributor.", response=HealthStatus.class)})
        public void getContributorStatus(@ApiParam(value="The id of an existing health contributor.", required=true) @PathParam(value="id") String var1, @Context SecurityContext var2, @Suspended AsyncResponse var3) throws NotFoundException;

        @GET
        @Path(value="/details")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the details of the Controller service.", response=HealthDetails.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The list of details.", response=HealthDetails.class), @ApiResponse(code=500, message="Internal server error while fetching the health details of the Controller.", response=HealthDetails.class)})
        public void getDetails(@Context SecurityContext var1, @Suspended AsyncResponse var2) throws NotFoundException;

        @GET
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Return the Health of the Controller service.", response=HealthResult.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The Health result of the Controller.", response=HealthResult.class), @ApiResponse(code=500, message="Internal server error while fetching the Health.", response=HealthResult.class)})
        public void getHealth(@Context SecurityContext var1, @Suspended AsyncResponse var2) throws NotFoundException;

        @GET
        @Path(value="/liveness")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the liveness state of the Controller service.", response=Boolean.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The alive status.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the liveness state of the Controller.", response=Boolean.class)})
        public void getLiveness(@Context SecurityContext var1, @Suspended AsyncResponse var2) throws NotFoundException;

        @GET
        @Path(value="/readiness")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the ready state of the Controller service.", response=Boolean.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The ready status.", response=Boolean.class), @ApiResponse(code=500, message="Internal server error while fetching the ready state of the Controller.", response=Boolean.class)})
        public void getReadiness(@Context SecurityContext var1, @Suspended AsyncResponse var2) throws NotFoundException;

        @GET
        @Path(value="/status")
        @Produces(value={"application/json"})
        @ApiOperation(value="", notes="Fetch the status of the Controller service.", response=HealthStatus.class, tags={"Health"})
        @ApiResponses(value={@ApiResponse(code=200, message="The health status of the Controller.", response=HealthStatus.class), @ApiResponse(code=500, message="Internal server error while fetching the health status of the Controller.", response=HealthStatus.class)})
        public void getStatus(@Context SecurityContext var1, @Suspended AsyncResponse var2) throws NotFoundException;
    }
}

