/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.ServerConfig;
import io.pravega.common.Exceptions;
import io.pravega.common.cluster.Host;
import io.pravega.common.security.JKSHelper;
import io.pravega.common.security.ZKTLSUtils;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.CacheManager;
import io.pravega.segmentstore.server.host.StorageLoader;
import io.pravega.segmentstore.server.host.ZKSegmentContainerManager;
import io.pravega.segmentstore.server.host.delegationtoken.TokenVerifierImpl;
import io.pravega.segmentstore.server.host.handler.AdminConnectionListener;
import io.pravega.segmentstore.server.host.handler.PravegaConnectionListener;
import io.pravega.segmentstore.server.host.health.SegmentContainerRegistryHealthContributor;
import io.pravega.segmentstore.server.host.health.ZKHealthContributor;
import io.pravega.segmentstore.server.host.stat.AutoScaleMonitor;
import io.pravega.segmentstore.server.host.stat.AutoScalerConfig;
import io.pravega.segmentstore.server.store.ServiceBuilder;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import io.pravega.segmentstore.server.store.ServiceConfig;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.BookKeeperLogFactory;
import io.pravega.segmentstore.storage.mocks.InMemoryDurableDataLogFactory;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.HealthServiceManager;
import io.pravega.shared.health.bindings.resources.HealthImpl;
import io.pravega.shared.metrics.MetricsConfig;
import io.pravega.shared.metrics.MetricsProvider;
import io.pravega.shared.metrics.StatsProvider;
import io.pravega.shared.rest.RESTServer;
import io.pravega.shared.rest.security.AuthHandlerManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceStarter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceStarter.class);
    @VisibleForTesting
    private HealthServiceManager healthServiceManager;
    @VisibleForTesting
    private final ServiceBuilder serviceBuilder;
    private final ServiceBuilderConfig builderConfig;
    private final ServiceConfig serviceConfig;
    private StatsProvider statsProvider;
    private PravegaConnectionListener listener;
    private AdminConnectionListener adminListener;
    private AutoScaleMonitor autoScaleMonitor;
    private CuratorFramework zkClient;
    private RESTServer restServer;
    private boolean closed;

    public ServiceStarter(ServiceBuilderConfig config) {
        this.builderConfig = config;
        this.serviceConfig = (ServiceConfig)this.builderConfig.getConfig(ServiceConfig::builder);
        this.serviceBuilder = this.createServiceBuilder();
    }

    private ServiceBuilder createServiceBuilder() {
        ServiceBuilder builder = ServiceBuilder.newInMemoryBuilder((ServiceBuilderConfig)this.builderConfig);
        this.attachDataLogFactory(builder);
        this.attachStorage(builder);
        this.attachZKSegmentManager(builder);
        return builder;
    }

    public void start() throws Exception {
        Exceptions.checkNotClosed((boolean)this.closed, (Object)this);
        this.healthServiceManager = new HealthServiceManager(this.serviceConfig.getHealthCheckInterval());
        this.healthServiceManager.start();
        log.info("Initializing HealthService ...");
        MetricsConfig metricsConfig = (MetricsConfig)this.builderConfig.getConfig(MetricsConfig::builder);
        if (metricsConfig.isEnableStatistics()) {
            log.info("Initializing metrics provider ...");
            MetricsProvider.initialize((MetricsConfig)metricsConfig);
            this.statsProvider = MetricsProvider.getMetricsProvider();
            this.statsProvider.start();
        }
        log.info("Initializing ZooKeeper Client ...");
        this.zkClient = this.createZKClient();
        log.info("Initializing Service Builder ...");
        this.serviceBuilder.initialize();
        log.info("Creating StreamSegmentService ...");
        StreamSegmentStore service = this.serviceBuilder.createStreamSegmentService();
        log.info("Creating TableStoreService ...");
        TableStore tableStoreService = this.serviceBuilder.createTableStoreService();
        log.info("Creating Segment Stats recorder ...");
        this.autoScaleMonitor = new AutoScaleMonitor(service, (AutoScalerConfig)this.builderConfig.getConfig(AutoScalerConfig::builder));
        AutoScalerConfig autoScalerConfig = (AutoScalerConfig)this.builderConfig.getConfig(AutoScalerConfig::builder);
        TokenVerifierImpl tokenVerifier = null;
        if (autoScalerConfig.isAuthEnabled()) {
            tokenVerifier = new TokenVerifierImpl(autoScalerConfig.getTokenSigningKey());
        }
        log.info(this.serviceConfig.toString());
        log.info(autoScalerConfig.toString());
        this.listener = new PravegaConnectionListener(this.serviceConfig.isEnableTls(), this.serviceConfig.isEnableTlsReload(), this.serviceConfig.getListeningIPAddress(), this.serviceConfig.getListeningPort(), service, tableStoreService, this.autoScaleMonitor.getStatsRecorder(), this.autoScaleMonitor.getTableSegmentStatsRecorder(), tokenVerifier, this.serviceConfig.getCertFile(), this.serviceConfig.getKeyFile(), this.serviceConfig.isReplyWithStackTraceOnError(), this.serviceBuilder.getLowPriorityExecutor(), this.serviceConfig.getTlsProtocolVersion(), this.healthServiceManager);
        this.listener.startListening();
        log.info("PravegaConnectionListener started successfully.");
        if (this.serviceConfig.isEnableAdminGateway()) {
            this.adminListener = new AdminConnectionListener(this.serviceConfig.isEnableTls(), this.serviceConfig.isEnableTlsReload(), this.serviceConfig.getListeningIPAddress(), this.serviceConfig.getAdminGatewayPort(), service, tableStoreService, tokenVerifier, this.serviceConfig.getCertFile(), this.serviceConfig.getKeyFile(), this.serviceConfig.getTlsProtocolVersion(), this.healthServiceManager);
            this.adminListener.startListening();
            log.info("AdminConnectionListener started successfully.");
        }
        log.info("StreamSegmentService started.");
        this.healthServiceManager.register(new HealthContributor[]{new ZKHealthContributor(this.zkClient)});
        this.healthServiceManager.register(new HealthContributor[]{new CacheManager.CacheManagerHealthContributor(this.serviceBuilder.getCacheManager())});
        this.healthServiceManager.register(new HealthContributor[]{new SegmentContainerRegistryHealthContributor(this.serviceBuilder.getSegmentContainerRegistry())});
        if (this.serviceConfig.isRestServerEnabled()) {
            log.info("Initializing RESTServer ...");
            this.restServer = new RESTServer(this.serviceConfig.getRestServerConfig(), Collections.singleton(new HealthImpl(new AuthHandlerManager((ServerConfig)this.serviceConfig.getRestServerConfig()), this.healthServiceManager.getEndpoint())));
            this.restServer.startAsync();
            this.restServer.awaitRunning();
        }
    }

    public void shutdown() {
        if (!this.closed) {
            this.serviceBuilder.close();
            log.info("StreamSegmentService shut down.");
            if (this.healthServiceManager != null) {
                this.healthServiceManager.close();
                log.info("HealthServiceManager closed.");
            }
            if (this.restServer != null) {
                this.restServer.stopAsync();
                this.restServer.awaitTerminated();
                log.info("RESTServer closed.");
            }
            if (this.listener != null) {
                this.listener.close();
                log.info("PravegaConnectionListener closed.");
            }
            if (this.adminListener != null) {
                this.adminListener.close();
                log.info("AdminConnectionListener closed.");
            }
            if (this.statsProvider != null) {
                this.statsProvider.close();
                this.statsProvider = null;
                log.info("Metrics statsProvider is now closed.");
            }
            if (this.zkClient != null) {
                this.zkClient.close();
                this.zkClient = null;
                log.info("ZooKeeper Client shut down.");
            }
            if (this.autoScaleMonitor != null) {
                this.autoScaleMonitor.close();
                this.autoScaleMonitor = null;
                log.info("AutoScaleMonitor shut down.");
            }
            if (this.serviceConfig.isSecureZK()) {
                ZKTLSUtils.unsetSecureZKClientProperties();
            }
            this.closed = true;
        }
    }

    private void attachDataLogFactory(ServiceBuilder builder) {
        builder.withDataLogFactory(setup -> {
            switch (this.serviceConfig.getDataLogTypeImplementation()) {
                case BOOKKEEPER: {
                    return new BookKeeperLogFactory((BookKeeperConfig)setup.getConfig(BookKeeperConfig::builder), this.zkClient, setup.getCoreExecutor());
                }
                case INMEMORY: {
                    return new InMemoryDurableDataLogFactory(setup.getCoreExecutor());
                }
            }
            throw new IllegalStateException("Unsupported storage implementation: " + this.serviceConfig.getDataLogTypeImplementation());
        });
    }

    private void attachStorage(ServiceBuilder builder) {
        builder.withStorageFactory(setup -> {
            StorageLoader loader = new StorageLoader();
            return loader.load((ConfigSetup)setup, this.serviceConfig.getStorageImplementation(), this.serviceConfig.getStorageLayout(), setup.getStorageExecutor());
        });
    }

    private void attachZKSegmentManager(ServiceBuilder builder) {
        builder.withContainerManager(setup -> new ZKSegmentContainerManager(setup.getContainerRegistry(), this.zkClient, new Host(this.serviceConfig.getPublishedIPAddress(), this.serviceConfig.getPublishedPort(), null), this.serviceConfig.getParallelContainerStarts(), setup.getCoreExecutor()));
    }

    @VisibleForTesting
    public CuratorFramework createZKClient() {
        if (this.serviceConfig.isSecureZK()) {
            ZKTLSUtils.setSecureZKClientProperties((String)this.serviceConfig.getZkTrustStore(), (String)JKSHelper.loadPasswordFrom((String)this.serviceConfig.getZkTrustStorePasswordPath()));
        }
        CuratorFramework zkClient = CuratorFrameworkFactory.builder().connectString(this.serviceConfig.getZkURL()).namespace("pravega/" + this.serviceConfig.getClusterName()).zookeeperFactory((ZookeeperFactory)new ZKClientFactory()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.serviceConfig.getZkRetrySleepMs(), this.serviceConfig.getZkRetryCount())).sessionTimeoutMs(this.serviceConfig.getZkSessionTimeoutMs()).build();
        zkClient.start();
        return zkClient;
    }

    public static void main(String[] args) throws Exception {
        AtomicReference<ServiceStarter> serviceStarter = new AtomicReference<ServiceStarter>();
        try {
            System.err.println(System.getProperty("pravega.configurationFile", "config.properties"));
            ServiceBuilderConfig config = ServiceBuilderConfig.builder().include(System.getProperty("pravega.configurationFile", "config.properties")).include(System.getProperties()).build();
            log.info("Segment store configuration:");
            config.forEach((key, value) -> log.info("{} = {}", key, value));
            serviceStarter.set(new ServiceStarter(config));
        }
        catch (Throwable e) {
            log.error("Could not create a Service with default config, Aborting.", e);
            System.exit(1);
        }
        try {
            ((ServiceStarter)serviceStarter.get()).start();
        }
        catch (Throwable e) {
            log.error("Could not start the Service, Aborting.", e);
            System.exit(1);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("Caught interrupt signal...");
                ((ServiceStarter)serviceStarter.get()).shutdown();
            }));
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException ex) {
            log.info("Caught interrupt signal...");
        }
        finally {
            ((ServiceStarter)serviceStarter.get()).shutdown();
            System.exit(0);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthServiceManager getHealthServiceManager() {
        return this.healthServiceManager;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServiceBuilder getServiceBuilder() {
        return this.serviceBuilder;
    }

    @ThreadSafe
    static class ZKClientFactory
    implements ZookeeperFactory {
        @GuardedBy(value="this")
        private ZooKeeper client;
        @GuardedBy(value="this")
        private String connectString;
        @GuardedBy(value="this")
        private int sessionTimeout;
        @GuardedBy(value="this")
        private boolean canBeReadOnly;

        ZKClientFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
            Exceptions.checkNotNullOrEmpty((String)connectString, (String)"connectString");
            Preconditions.checkArgument((sessionTimeout > 0 ? 1 : 0) != 0, (Object)"sessionTimeout should be a positive integer");
            ZKClientFactory zKClientFactory = this;
            synchronized (zKClientFactory) {
                if (this.client == null) {
                    this.connectString = connectString;
                    this.sessionTimeout = sessionTimeout;
                    this.canBeReadOnly = canBeReadOnly;
                }
                log.info("Creating new Zookeeper client with arguments: {}, {}, {}.", new Object[]{this.connectString, this.sessionTimeout, this.canBeReadOnly});
                this.client = new ZooKeeper(this.connectString, this.sessionTimeout, watcher, this.canBeReadOnly);
                return this.client;
            }
        }
    }
}

