/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.storage.ConfigSetup;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.StorageFactoryCreator;
import io.pravega.segmentstore.storage.StorageFactoryInfo;
import io.pravega.segmentstore.storage.StorageLayoutType;
import io.pravega.segmentstore.storage.noop.NoOpStorageFactory;
import io.pravega.segmentstore.storage.noop.StorageExtraConfig;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLoader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageLoader.class);

    public StorageFactory load(ConfigSetup setup, String storageImplementation, StorageLayoutType storageLayoutType, ScheduledExecutorService executor) {
        ServiceLoader<StorageFactoryCreator> loader = ServiceLoader.load(StorageFactoryCreator.class);
        StorageExtraConfig noOpConfig = (StorageExtraConfig)setup.getConfig(StorageExtraConfig::builder);
        for (StorageFactoryCreator factoryCreator : loader) {
            StorageFactoryInfo[] factories;
            for (StorageFactoryInfo factoryInfo : factories = factoryCreator.getStorageFactories()) {
                log.info("Loading {}, trying {}", (Object)storageImplementation, (Object)factoryInfo);
                if (!factoryInfo.getName().equals(storageImplementation) || factoryInfo.getStorageLayoutType() != storageLayoutType) continue;
                StorageFactory factory = factoryCreator.createFactory(factoryInfo, setup, executor);
                if (!noOpConfig.isStorageNoOpMode()) {
                    return factory;
                }
                log.warn("{} IS IN NO-OP MODE: DATA LOSS WILL HAPPEN! MAKE SURE IT IS BY FULL INTENTION FOR TESTING PURPOSE!", (Object)storageImplementation);
                return new NoOpStorageFactory(noOpConfig, (Executor)executor, factory, null);
            }
        }
        return null;
    }
}

