/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.delegationtoken;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.InvalidClaimException;
import io.pravega.auth.InvalidTokenException;
import io.pravega.auth.TokenException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.shared.security.token.JsonWebToken;
import io.pravega.shared.security.token.JwtParser;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenVerifierImpl
implements DelegationTokenVerifier {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenVerifierImpl.class);
    private static final Pattern RESOURCE_PARTS_TO_REPLACE = Pattern.compile("prn::|/scope:|stream:");
    private final byte[] tokenSigningKey;

    @VisibleForTesting
    public TokenVerifierImpl(String tokenSigningKeyBasis) {
        Exceptions.checkNotNullOrEmpty((String)tokenSigningKeyBasis, (String)"tokenSigningKeyBasis");
        this.tokenSigningKey = tokenSigningKeyBasis.getBytes();
    }

    @Override
    public JsonWebToken verifyToken(@NonNull String resource, String token, @NonNull AuthHandler.Permissions expectedLevel) throws TokenExpiredException, InvalidTokenException, InvalidClaimException, TokenException {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (expectedLevel == null) {
            throw new NullPointerException("expectedLevel is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty((String)token)) {
            throw new InvalidTokenException("Token is null or empty");
        }
        JsonWebToken jwt = JwtParser.parse((String)token, (byte[])this.tokenSigningKey);
        Map permissionsByResource = jwt.getPermissionsByResource();
        Optional<Map.Entry> matchingClaim = permissionsByResource.entrySet().stream().filter(entry -> this.resourceMatchesClaimKey((String)entry.getKey(), resource) && expectedLevel.compareTo((Enum)AuthHandler.Permissions.valueOf((String)entry.getValue().toString())) <= 0).findFirst();
        if (!matchingClaim.isPresent()) {
            log.debug(String.format("No matching claim found for resource [%s] and permission [%s] in token.", resource, expectedLevel));
            throw new InvalidClaimException(String.format("No matching claim found for resource: [%s] and permission: [%s] in the delegation token.", resource, expectedLevel));
        }
        return jwt;
    }

    private boolean resourceMatchesClaimKey(String claimKey, String resource) {
        log.trace("claimKey = {}, resourceKey = {}", (Object)claimKey, (Object)resource);
        claimKey = RESOURCE_PARTS_TO_REPLACE.matcher(claimKey).replaceAll("");
        boolean result = resource.equals(claimKey) || claimKey.endsWith("/") && resource.startsWith(claimKey) || resource.startsWith(claimKey + "/") || claimKey.equals("*");
        log.trace("claimKey: [{}], resource: [{}], result: [{}]", new Object[]{claimKey, resource, result});
        return result;
    }
}

