/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import io.pravega.common.Exceptions;
import io.pravega.common.io.filesystem.FileModificationEventWatcher;
import io.pravega.common.io.filesystem.FileModificationMonitor;
import io.pravega.common.io.filesystem.FileModificationPollingMonitor;
import io.pravega.segmentstore.server.host.handler.ConnectionTracker;
import io.pravega.segmentstore.server.host.handler.ServerConnectionInboundHandler;
import io.pravega.segmentstore.server.host.handler.TrackedConnection;
import io.pravega.segmentstore.server.host.security.TLSConfigChangeEventConsumer;
import io.pravega.segmentstore.server.host.security.TLSConfigChangeFileConsumer;
import io.pravega.segmentstore.server.host.security.TLSHelper;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.HealthServiceManager;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import io.pravega.shared.protocol.netty.RequestProcessor;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionListener
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectionListener.class);
    private final String host;
    private final int port;
    private Channel serverChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    @VisibleForTesting
    private final HealthServiceManager healthServiceManager;
    private final ConnectionTracker connectionTracker;
    private final boolean enableTls;
    @VisibleForTesting
    private final boolean enableTlsReload;
    private final String pathToTlsCertFile;
    private final String pathToTlsKeyFile;
    private final String[] tlsProtocolVersion;
    private FileModificationMonitor tlsCertFileModificationMonitor;

    public AbstractConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, String certFile, String keyFile, String[] tlsProtocolVersion) {
        this(enableTls, enableTlsReload, host, port, certFile, keyFile, tlsProtocolVersion, null);
    }

    public AbstractConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, String certFile, String keyFile, String[] tlsProtocolVersion, HealthServiceManager healthServiceManager) {
        this.enableTls = enableTls;
        this.enableTlsReload = this.enableTls && enableTlsReload;
        this.host = Exceptions.checkNotNullOrEmpty((String)host, (String)"host");
        this.port = port;
        this.pathToTlsCertFile = certFile;
        this.pathToTlsKeyFile = keyFile;
        this.tlsProtocolVersion = Arrays.copyOf(tlsProtocolVersion, tlsProtocolVersion.length);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        this.connectionTracker = new ConnectionTracker();
        this.healthServiceManager = healthServiceManager;
    }

    public abstract List<ChannelHandler> createEncodingStack(String var1);

    public abstract RequestProcessor createRequestProcessor(TrackedConnection var1);

    public void startListening() {
        final AtomicReference<SslContext> sslCtx = this.enableTls ? new AtomicReference<SslContext>(TLSHelper.newServerSslContext(this.pathToTlsCertFile, this.pathToTlsKeyFile, this.tlsProtocolVersion)) : null;
        boolean nio = false;
        try {
            this.bossGroup = new EpollEventLoopGroup(1);
            this.workerGroup = new EpollEventLoopGroup();
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
            nio = true;
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
        }
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(nio ? NioServerSocketChannel.class : EpollServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (AbstractConnectionListener.this.enableTls) {
                    SslHandler sslHandler = ((SslContext)sslCtx.get()).newHandler(ch.alloc());
                    p.addLast("tls", (ChannelHandler)sslHandler);
                }
                ServerConnectionInboundHandler lsh = new ServerConnectionInboundHandler();
                AbstractConnectionListener.this.createEncodingStack(ch.remoteAddress().toString()).forEach(xva$0 -> p.addLast(new ChannelHandler[]{xva$0}));
                lsh.setRequestProcessor(AbstractConnectionListener.this.createRequestProcessor(new TrackedConnection(lsh, AbstractConnectionListener.this.connectionTracker)));
                p.addLast(new ChannelHandler[]{lsh});
            }
        });
        if (this.enableTls && this.enableTlsReload) {
            this.enableTlsContextReload(sslCtx);
        }
        this.serverChannel = b.bind(this.host, this.port).awaitUninterruptibly().channel();
        if (this.healthServiceManager != null) {
            this.healthServiceManager.register(new HealthContributor[]{new ConnectionListenerHealthContributor(this)});
        }
    }

    @VisibleForTesting
    void enableTlsContextReload(AtomicReference<SslContext> sslCtx) {
        this.tlsCertFileModificationMonitor = this.prepareCertificateMonitor(this.pathToTlsCertFile, this.pathToTlsKeyFile, sslCtx);
        this.tlsCertFileModificationMonitor.startMonitoring();
        log.info("Successfully started file modification monitoring for TLS certificate: [{}]", (Object)this.pathToTlsCertFile);
    }

    @VisibleForTesting
    FileModificationMonitor prepareCertificateMonitor(String tlsCertificatePath, String tlsKeyPath, AtomicReference<SslContext> sslCtx) {
        return this.prepareCertificateMonitor(Files.isSymbolicLink(Paths.get(tlsCertificatePath, new String[0])), tlsCertificatePath, tlsKeyPath, sslCtx);
    }

    @VisibleForTesting
    FileModificationMonitor prepareCertificateMonitor(boolean isTLSCertPathSymLink, String tlsCertificatePath, String tlsKeyPath, AtomicReference<SslContext> sslCtx) {
        try {
            FileModificationEventWatcher result;
            if (isTLSCertPathSymLink) {
                log.info("The path to certificate file [{}] was found to be a symbolic link,  so using [{}] to monitor for certificate changes", (Object)tlsCertificatePath, (Object)FileModificationPollingMonitor.class.getSimpleName());
                result = new FileModificationPollingMonitor(Paths.get(tlsCertificatePath, new String[0]), (Consumer)new TLSConfigChangeFileConsumer(sslCtx, tlsCertificatePath, tlsKeyPath, this.tlsProtocolVersion));
            } else {
                result = new FileModificationEventWatcher(Paths.get(tlsCertificatePath, new String[0]), (Consumer)new TLSConfigChangeEventConsumer(sslCtx, tlsCertificatePath, tlsKeyPath, this.tlsProtocolVersion));
            }
            return result;
        }
        catch (FileNotFoundException e) {
            log.error("Failed to prepare a monitor for the certificate at path [{}]", (Object)tlsCertificatePath, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        Exceptions.handleInterrupted(() -> {
            if (this.serverChannel != null) {
                this.serverChannel.close();
                this.serverChannel.closeFuture().sync();
            }
        });
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.tlsCertFileModificationMonitor != null) {
            this.tlsCertFileModificationMonitor.stopMonitoring();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HealthServiceManager getHealthServiceManager() {
        return this.healthServiceManager;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableTlsReload() {
        return this.enableTlsReload;
    }

    private static class ConnectionListenerHealthContributor
    extends AbstractHealthContributor {
        @NonNull
        private final AbstractConnectionListener listener;

        private ConnectionListenerHealthContributor(AbstractConnectionListener listener) {
            super(listener.getClass().getSimpleName());
            this.listener = listener;
        }

        public Status doHealthCheck(Health.HealthBuilder builder) {
            boolean ready;
            Status status = Status.DOWN;
            boolean running = this.listener.serverChannel.isOpen();
            if (running) {
                status = Status.NEW;
            }
            if (ready = this.listener.serverChannel.isActive()) {
                status = Status.UP;
            }
            builder.details((Map)ImmutableMap.of((Object)"host", (Object)this.listener.host, (Object)"port", (Object)this.listener.port));
            return status;
        }
    }
}

