/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.delegationtoken.PassingTokenVerifier;
import io.pravega.segmentstore.server.host.handler.AbstractConnectionListener;
import io.pravega.segmentstore.server.host.handler.AdminRequestProcessorImpl;
import io.pravega.segmentstore.server.host.handler.TrackedConnection;
import io.pravega.shared.health.HealthServiceManager;
import io.pravega.shared.metrics.MetricNotifier;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.CommandEncoder;
import io.pravega.shared.protocol.netty.ExceptionLoggingHandler;
import io.pravega.shared.protocol.netty.RequestProcessor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConnectionListener
extends AbstractConnectionListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminConnectionListener.class);
    private final StreamSegmentStore store;
    private final TableStore tableStore;
    private final DelegationTokenVerifier tokenVerifier;

    public AdminConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, DelegationTokenVerifier tokenVerifier, String certFile, String keyFile, String[] tlsProtocolVersion) {
        this(enableTls, enableTlsReload, host, port, streamSegmentStore, tableStore, tokenVerifier, certFile, keyFile, tlsProtocolVersion, null);
    }

    public AdminConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, DelegationTokenVerifier tokenVerifier, String certFile, String keyFile, String[] tlsProtocolVersion, HealthServiceManager healthServiceManager) {
        super(enableTls, enableTlsReload, host, port, certFile, keyFile, tlsProtocolVersion, healthServiceManager);
        this.store = (StreamSegmentStore)Preconditions.checkNotNull((Object)streamSegmentStore, (Object)"streamSegmentStore");
        this.tableStore = (TableStore)Preconditions.checkNotNull((Object)tableStore, (Object)"tableStore");
        this.tokenVerifier = tokenVerifier != null ? tokenVerifier : new PassingTokenVerifier();
    }

    @Override
    public RequestProcessor createRequestProcessor(TrackedConnection c) {
        return new AdminRequestProcessorImpl(this.store, this.tableStore, c, this.tokenVerifier);
    }

    @Override
    public List<ChannelHandler> createEncodingStack(String connectionName) {
        ArrayList<ChannelHandler> stack = new ArrayList<ChannelHandler>();
        stack.add((ChannelHandler)new ExceptionLoggingHandler(connectionName));
        stack.add((ChannelHandler)new CommandEncoder(null, MetricNotifier.NO_OP_METRIC_NOTIFIER));
        stack.add((ChannelHandler)new LengthFieldBasedFrameDecoder(0xFFFFFF, 4, 4));
        stack.add((ChannelHandler)new CommandDecoder());
        return stack;
    }
}

