/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.LoggerHelpers;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.delegationtoken.PassingTokenVerifier;
import io.pravega.segmentstore.server.host.handler.ConnectionTracker;
import io.pravega.segmentstore.server.host.handler.PravegaRequestProcessor;
import io.pravega.segmentstore.server.host.handler.ServerConnection;
import io.pravega.segmentstore.server.host.handler.TrackedConnection;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.shared.protocol.netty.AdminRequestProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRequestProcessorImpl
extends PravegaRequestProcessor
implements AdminRequestProcessor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminRequestProcessorImpl.class);

    public AdminRequestProcessorImpl(@NonNull StreamSegmentStore segmentStore, @NonNull TableStore tableStore, @NonNull ServerConnection connection) {
        this(segmentStore, tableStore, new TrackedConnection(connection, new ConnectionTracker()), new PassingTokenVerifier());
        if (segmentStore == null) {
            throw new NullPointerException("segmentStore is marked non-null but is null");
        }
        if (tableStore == null) {
            throw new NullPointerException("tableStore is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
    }

    public AdminRequestProcessorImpl(@NonNull StreamSegmentStore segmentStore, @NonNull TableStore tableStore, @NonNull TrackedConnection connection, @NonNull DelegationTokenVerifier tokenVerifier) {
        this(segmentStore, tableStore, connection, SegmentStatsRecorder.noOp(), TableSegmentStatsRecorder.noOp(), tokenVerifier, true);
        if (segmentStore == null) {
            throw new NullPointerException("segmentStore is marked non-null but is null");
        }
        if (tableStore == null) {
            throw new NullPointerException("tableStore is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (tokenVerifier == null) {
            throw new NullPointerException("tokenVerifier is marked non-null but is null");
        }
    }

    public AdminRequestProcessorImpl(@NonNull StreamSegmentStore segmentStore, @NonNull TableStore tableStore, @NonNull TrackedConnection connection, @NonNull SegmentStatsRecorder statsRecorder, @NonNull TableSegmentStatsRecorder tableStatsRecorder, @NonNull DelegationTokenVerifier tokenVerifier, boolean replyWithStackTraceOnError) {
        super(segmentStore, tableStore, connection, statsRecorder, tableStatsRecorder, tokenVerifier, replyWithStackTraceOnError);
        if (segmentStore == null) {
            throw new NullPointerException("segmentStore is marked non-null but is null");
        }
        if (tableStore == null) {
            throw new NullPointerException("tableStore is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (statsRecorder == null) {
            throw new NullPointerException("statsRecorder is marked non-null but is null");
        }
        if (tableStatsRecorder == null) {
            throw new NullPointerException("tableStatsRecorder is marked non-null but is null");
        }
        if (tokenVerifier == null) {
            throw new NullPointerException("tokenVerifier is marked non-null but is null");
        }
    }

    public void hello(WireCommands.Hello hello) {
        log.info("Received hello from connection: {}", (Object)this.getConnection());
        this.getConnection().send((WireCommand)new WireCommands.Hello(14, 5));
        if (hello.getLowVersion() > 14 || hello.getHighVersion() < 5) {
            log.warn("Incompatible wire protocol versions {} from connection {}", (Object)hello, (Object)this.getConnection());
            this.getConnection().close();
        }
    }

    public void keepAlive(WireCommands.KeepAlive keepAlive) {
        log.info("Received a keepAlive from connection: {}", (Object)this.getConnection());
        this.getConnection().send((WireCommand)keepAlive);
    }

    public void flushToStorage(WireCommands.FlushToStorage flushToStorage) {
        String operation = "flushToStorage";
        int containerId = flushToStorage.getContainerId();
        if (!this.verifyToken(null, flushToStorage.getRequestId(), flushToStorage.getDelegationToken(), "flushToStorage")) {
            return;
        }
        long trace = LoggerHelpers.traceEnter((Logger)log, (String)"flushToStorage", (Object[])new Object[]{flushToStorage});
        ((CompletableFuture)this.getSegmentStore().flushToStorage(containerId, TIMEOUT).thenAccept(v -> {
            LoggerHelpers.traceLeave((Logger)log, (String)"flushToStorage", (long)trace, (Object[])new Object[0]);
            this.getConnection().send((WireCommand)new WireCommands.StorageFlushed(flushToStorage.getRequestId()));
        })).exceptionally(ex -> this.handleException(flushToStorage.getRequestId(), null, "flushToStorage", (Throwable)ex));
    }
}

