/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthHandler;
import io.pravega.auth.TokenException;
import io.pravega.auth.TokenExpiredException;
import io.pravega.common.Exceptions;
import io.pravega.common.LoggerHelpers;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.BufferView;
import io.pravega.segmentstore.contracts.AttributeId;
import io.pravega.segmentstore.contracts.AttributeUpdate;
import io.pravega.segmentstore.contracts.AttributeUpdateCollection;
import io.pravega.segmentstore.contracts.AttributeUpdateType;
import io.pravega.segmentstore.contracts.Attributes;
import io.pravega.segmentstore.contracts.BadAttributeUpdateException;
import io.pravega.segmentstore.contracts.BadOffsetException;
import io.pravega.segmentstore.contracts.ContainerNotFoundException;
import io.pravega.segmentstore.contracts.StreamSegmentExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentNotExistsException;
import io.pravega.segmentstore.contracts.StreamSegmentSealedException;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.server.IllegalContainerStateException;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.handler.TrackedConnection;
import io.pravega.segmentstore.server.host.handler.WriterState;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.shared.protocol.netty.Append;
import io.pravega.shared.protocol.netty.ByteBufWrapper;
import io.pravega.shared.protocol.netty.DelegatingRequestProcessor;
import io.pravega.shared.protocol.netty.FailingRequestProcessor;
import io.pravega.shared.protocol.netty.RequestProcessor;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import io.pravega.shared.security.token.JsonWebToken;
import java.time.Duration;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendProcessor
extends DelegatingRequestProcessor {
    static final Duration TIMEOUT = Duration.ofMinutes(1L);
    private static final String EMPTY_STACK_TRACE = "";
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(AppendProcessor.class));
    private final StreamSegmentStore store;
    private final TrackedConnection connection;
    private final RequestProcessor nextRequestProcessor;
    private final SegmentStatsRecorder statsRecorder;
    private final DelegationTokenVerifier tokenVerifier;
    private final boolean replyWithStackTraceOnError;
    private final ConcurrentHashMap<Pair<String, UUID>, WriterState> writerStates = new ConcurrentHashMap();
    private final ScheduledExecutorService tokenExpiryHandlerExecutor;

    AppendProcessor(@NonNull StreamSegmentStore store, @NonNull TrackedConnection connection, @NonNull RequestProcessor nextRequestProcessor, @NonNull SegmentStatsRecorder statsRecorder, DelegationTokenVerifier tokenVerifier, boolean replyWithStackTraceOnError, ScheduledExecutorService tokenExpiryHandlerExecutor) {
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (nextRequestProcessor == null) {
            throw new NullPointerException("nextRequestProcessor is marked non-null but is null");
        }
        if (statsRecorder == null) {
            throw new NullPointerException("statsRecorder is marked non-null but is null");
        }
        this.store = store;
        this.connection = connection;
        this.nextRequestProcessor = nextRequestProcessor;
        this.statsRecorder = statsRecorder;
        this.tokenVerifier = tokenVerifier;
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
        this.tokenExpiryHandlerExecutor = tokenExpiryHandlerExecutor;
    }

    @VisibleForTesting
    public static AppendProcessorBuilder defaultBuilder() {
        return AppendProcessor.builder().nextRequestProcessor((RequestProcessor)new FailingRequestProcessor()).statsRecorder(SegmentStatsRecorder.noOp()).replyWithStackTraceOnError(false);
    }

    public void hello(WireCommands.Hello hello) {
        log.info("Received hello from connection: {}", (Object)this.connection);
        this.connection.send((WireCommand)new WireCommands.Hello(14, 5));
        if (hello.getLowVersion() > 14 || hello.getHighVersion() < 5) {
            log.warn(hello.getRequestId(), "Incompatible wire protocol versions {} from connection {}", new Object[]{hello, this.connection});
            this.connection.close();
        }
    }

    public void keepAlive(WireCommands.KeepAlive keepAlive) {
        log.debug("Received a keepAlive from connection: {}", (Object)this.connection);
        this.connection.send((WireCommand)keepAlive);
    }

    public void setupAppend(WireCommands.SetupAppend setupAppend) {
        String newSegment = setupAppend.getSegment();
        UUID writer = setupAppend.getWriterId();
        log.info("Setting up appends for writer: {} on segment: {}", (Object)writer, (Object)newSegment);
        if (this.tokenVerifier != null) {
            try {
                JsonWebToken token = this.tokenVerifier.verifyToken(newSegment, setupAppend.getDelegationToken(), AuthHandler.Permissions.READ_UPDATE);
                this.setupTokenExpiryTask(setupAppend, token);
            }
            catch (TokenException e2) {
                this.handleException(setupAppend.getWriterId(), setupAppend.getRequestId(), newSegment, "Update Segment Attribute", e2);
                return;
            }
        }
        AttributeId writerAttributeId = AttributeId.fromUUID((UUID)writer);
        Futures.exceptionallyComposeExpecting((CompletableFuture)this.store.getAttributes(newSegment, Collections.singleton(writerAttributeId), true, TIMEOUT), e -> e instanceof StreamSegmentSealedException, () -> this.store.getAttributes(newSegment, Collections.singleton(writerAttributeId), false, TIMEOUT)).whenComplete((attributes, u) -> {
            try {
                if (u != null) {
                    this.handleException(writer, setupAppend.getRequestId(), newSegment, "setting up append", (Throwable)u);
                } else {
                    long eventNumber = attributes.getOrDefault(writerAttributeId, Long.MIN_VALUE);
                    WriterState current = this.writerStates.put((Pair<String, UUID>)Pair.of((Object)newSegment, (Object)writer), new WriterState(eventNumber));
                    if (current != null) {
                        log.info("SetupAppend invoked again for writer {}. Last event number from store is {}. Prev writer state {}", new Object[]{writer, eventNumber, current});
                    }
                    this.connection.send((WireCommand)new WireCommands.AppendSetup(setupAppend.getRequestId(), newSegment, writer, eventNumber));
                }
            }
            catch (Throwable e) {
                this.handleException(writer, setupAppend.getRequestId(), newSegment, "handling setupAppend result", e);
            }
        });
    }

    @VisibleForTesting
    CompletableFuture<Void> setupTokenExpiryTask(@NonNull WireCommands.SetupAppend setupAppend, @NonNull JsonWebToken token) {
        if (setupAppend == null) {
            throw new NullPointerException("setupAppend is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        String segment = setupAppend.getSegment();
        UUID writerId = setupAppend.getWriterId();
        long requestId = setupAppend.getRequestId();
        if (token.getExpirationTime() == null) {
            return CompletableFuture.completedFuture(null);
        }
        return Futures.delayedTask(() -> {
            if (this.isSetupAppendCompleted(segment, writerId)) {
                log.debug("Closing client connection for writer {} due to token expiry, when processing request {} for segment {}", new Object[]{writerId, requestId, segment});
                this.connection.close();
            }
            return null;
        }, (Duration)token.durationToExpiry(), (ScheduledExecutorService)this.tokenExpiryHandlerExecutor);
    }

    @VisibleForTesting
    boolean isSetupAppendCompleted(String newSegment, UUID writer) {
        return this.writerStates.containsKey(Pair.of((Object)newSegment, (Object)writer));
    }

    public void append(Append append) {
        long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"append", (Object[])new Object[]{append});
        UUID id = append.getWriterId();
        WriterState state = this.writerStates.get(Pair.of((Object)append.getSegment(), (Object)id));
        Preconditions.checkState((state != null ? 1 : 0) != 0, (String)"Data from unexpected connection: Segment=%s, WriterId=%s.", (Object)append.getSegment(), (Object)id);
        long previousEventNumber = state.beginAppend(append.getEventNumber());
        int appendLength = append.getData().readableBytes();
        this.connection.adjustOutstandingBytes(appendLength);
        Timer timer = new Timer();
        ((CompletableFuture)this.storeAppend(append, previousEventNumber).whenComplete((newLength, ex) -> {
            this.handleAppendResult(append, (Long)newLength, (Throwable)ex, state, timer);
            LoggerHelpers.traceLeave((Logger)log, (String)"storeAppend", (long)traceId, (Object[])new Object[]{append, ex});
        })).whenComplete((v, e) -> {
            this.connection.adjustOutstandingBytes(-appendLength);
            append.getData().release();
        });
    }

    private CompletableFuture<Long> storeAppend(Append append, long lastEventNumber) {
        AttributeUpdateCollection attributes = AttributeUpdateCollection.from((AttributeUpdate[])new AttributeUpdate[]{new AttributeUpdate(AttributeId.fromUUID((UUID)append.getWriterId()), AttributeUpdateType.ReplaceIfEquals, append.getEventNumber(), lastEventNumber), new AttributeUpdate(Attributes.EVENT_COUNT, AttributeUpdateType.Accumulate, (long)append.getEventCount())});
        ByteBufWrapper buf = new ByteBufWrapper(append.getData());
        if (append.isConditional()) {
            return this.store.append(append.getSegment(), append.getExpectedLength().longValue(), (BufferView)buf, attributes, TIMEOUT);
        }
        return this.store.append(append.getSegment(), (BufferView)buf, attributes, TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAppendResult(Append append, Long newWriteOffset, Throwable exception, WriterState state, Timer elapsedTimer) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        boolean success = exception == null;
        try {
            if (success) {
                Object object = state.getAckLock();
                synchronized (object) {
                    long previousLastAcked = state.appendSuccessful(append.getEventNumber());
                    if (previousLastAcked < append.getEventNumber()) {
                        WireCommands.DataAppended dataAppendedAck = new WireCommands.DataAppended(append.getRequestId(), append.getWriterId(), append.getEventNumber(), previousLastAcked, newWriteOffset.longValue());
                        log.trace("Sending DataAppended : {}", (Object)dataAppendedAck);
                        this.connection.send((WireCommand)dataAppendedAck);
                    }
                }
                if (append.getEventNumber() > state.getLowestFailedEventNumber()) {
                    log.warn(append.getRequestId(), "Acknowledged a successful append after a failed one. Segment={}, WriterId={}, FailedEventNumber={}, AppendEventNumber={}", new Object[]{append.getSegment(), append.getWriterId(), state.getLowestFailedEventNumber(), append.getEventNumber()});
                }
            } else if (append.isConditional() && Exceptions.unwrap((Throwable)exception) instanceof BadOffsetException) {
                log.debug("Conditional append failed due to incorrect offset: {}, {}", (Object)append, (Object)exception.getMessage());
                Object object = state.getAckLock();
                synchronized (object) {
                    state.conditionalAppendFailed(append.getEventNumber());
                    this.connection.send((WireCommand)new WireCommands.ConditionalCheckFailed(append.getWriterId(), append.getEventNumber(), append.getRequestId()));
                }
            } else {
                state.appendFailed(append.getEventNumber(), () -> this.handleException(append.getWriterId(), append.getRequestId(), append.getSegment(), append.getEventNumber(), "appending data", exception));
            }
            this.executeDelayedErrorHandler(state, append.getSegment(), append.getWriterId());
        }
        catch (Throwable e) {
            success = false;
            this.handleException(append.getWriterId(), append.getEventNumber(), append.getSegment(), "handling append result", e);
        }
        if (success) {
            this.statsRecorder.recordAppend(append.getSegment(), append.getDataLength(), append.getEventCount(), elapsedTimer.getElapsed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelayedErrorHandler(WriterState state, String segmentName, UUID writerId) {
        WriterState.DelayedErrorHandler h = state.fetchEligibleDelayedErrorHandler();
        if (h == null) {
            return;
        }
        Object object = state.getAckLock();
        synchronized (object) {
            try {
                h.getHandlersToExecute().forEach(Runnable::run);
            }
            finally {
                if (h.getHandlersRemaining() == 0) {
                    this.writerStates.remove(Pair.of((Object)segmentName, (Object)writerId));
                }
            }
        }
    }

    private void handleException(UUID writerId, long requestId, String segment, String doingWhat, Throwable u) {
        this.handleException(writerId, requestId, segment, -1L, doingWhat, u);
    }

    private void handleException(UUID writerId, long requestId, String segment, long eventNumber, String doingWhat, Throwable u) {
        String clientReplyStackTrace;
        if (u == null) {
            IllegalStateException exception = new IllegalStateException("No exception to handle.");
            log.error(requestId, "Append processor: Error {} on segment = '{}'", new Object[]{doingWhat, segment, exception});
            throw exception;
        }
        u = Exceptions.unwrap((Throwable)u);
        String string = clientReplyStackTrace = this.replyWithStackTraceOnError ? Throwables.getStackTraceAsString((Throwable)u) : EMPTY_STACK_TRACE;
        if (u instanceof StreamSegmentExistsException) {
            log.warn(requestId, "Segment '{}' already exists and {} cannot perform operation '{}'.", new Object[]{segment, writerId, doingWhat});
            this.connection.send((WireCommand)new WireCommands.SegmentAlreadyExists(requestId, segment, clientReplyStackTrace));
        } else if (u instanceof StreamSegmentNotExistsException) {
            log.warn(requestId, "Segment '{}' does not exist and {} cannot perform operation '{}'.", new Object[]{segment, writerId, doingWhat});
            this.connection.send((WireCommand)new WireCommands.NoSuchSegment(requestId, segment, clientReplyStackTrace, -1L));
        } else if (u instanceof StreamSegmentSealedException) {
            log.info("Segment '{}' is sealed and {} cannot perform operation '{}'.", new Object[]{segment, writerId, doingWhat});
            this.connection.send((WireCommand)new WireCommands.SegmentIsSealed(requestId, segment, clientReplyStackTrace, eventNumber));
        } else if (u instanceof ContainerNotFoundException) {
            int containerId = ((ContainerNotFoundException)u).getContainerId();
            log.warn(requestId, "Wrong host. Segment '{}' (Container {}) is not owned and {} cannot perform operation '{}'.", new Object[]{segment, containerId, writerId, doingWhat});
            this.connection.send((WireCommand)new WireCommands.WrongHost(requestId, segment, EMPTY_STACK_TRACE, clientReplyStackTrace));
        } else if (u instanceof BadAttributeUpdateException) {
            log.warn(requestId, "Bad attribute update by {} on segment {}.", new Object[]{writerId, segment, u});
            this.connection.send((WireCommand)new WireCommands.InvalidEventNumber(writerId, requestId, clientReplyStackTrace));
            this.connection.close();
        } else if (u instanceof TokenExpiredException) {
            log.warn(requestId, "Token expired for writer {} on segment {}.", new Object[]{writerId, segment, u});
            this.connection.close();
        } else if (u instanceof TokenException) {
            log.warn(requestId, "Token check failed or writer {} on segment {}.", new Object[]{writerId, segment, u});
            this.connection.send((WireCommand)new WireCommands.AuthTokenCheckFailed(requestId, clientReplyStackTrace, WireCommands.AuthTokenCheckFailed.ErrorCode.TOKEN_CHECK_FAILED));
        } else if (u instanceof UnsupportedOperationException) {
            log.warn(requestId, "Unsupported Operation '{}'.", new Object[]{doingWhat, u});
            this.connection.send((WireCommand)new WireCommands.OperationUnsupported(requestId, doingWhat, clientReplyStackTrace));
        } else if (u instanceof CancellationException) {
            log.info("Closing connection '{}' while performing append on Segment '{}' due to {}.", new Object[]{this.connection, segment, u.toString()});
            this.connection.close();
        } else {
            this.logError(segment, u);
            this.connection.close();
        }
    }

    private void logError(String segment, Throwable u) {
        if (u instanceof IllegalContainerStateException) {
            log.warn("Error (Segment = '{}', Operation = 'append'): {}.", (Object)segment, (Object)u.toString());
        } else {
            log.error("Error (Segment = '{}', Operation = 'append')", (Object)segment, (Object)u);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static AppendProcessorBuilder builder() {
        return new AppendProcessorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RequestProcessor getNextRequestProcessor() {
        return this.nextRequestProcessor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class AppendProcessorBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private StreamSegmentStore store;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TrackedConnection connection;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RequestProcessor nextRequestProcessor;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SegmentStatsRecorder statsRecorder;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DelegationTokenVerifier tokenVerifier;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean replyWithStackTraceOnError;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ScheduledExecutorService tokenExpiryHandlerExecutor;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        AppendProcessorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder store(@NonNull StreamSegmentStore store) {
            if (store == null) {
                throw new NullPointerException("store is marked non-null but is null");
            }
            this.store = store;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder connection(@NonNull TrackedConnection connection) {
            if (connection == null) {
                throw new NullPointerException("connection is marked non-null but is null");
            }
            this.connection = connection;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder nextRequestProcessor(@NonNull RequestProcessor nextRequestProcessor) {
            if (nextRequestProcessor == null) {
                throw new NullPointerException("nextRequestProcessor is marked non-null but is null");
            }
            this.nextRequestProcessor = nextRequestProcessor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder statsRecorder(@NonNull SegmentStatsRecorder statsRecorder) {
            if (statsRecorder == null) {
                throw new NullPointerException("statsRecorder is marked non-null but is null");
            }
            this.statsRecorder = statsRecorder;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder tokenVerifier(DelegationTokenVerifier tokenVerifier) {
            this.tokenVerifier = tokenVerifier;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder replyWithStackTraceOnError(boolean replyWithStackTraceOnError) {
            this.replyWithStackTraceOnError = replyWithStackTraceOnError;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessorBuilder tokenExpiryHandlerExecutor(ScheduledExecutorService tokenExpiryHandlerExecutor) {
            this.tokenExpiryHandlerExecutor = tokenExpiryHandlerExecutor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public AppendProcessor build() {
            return new AppendProcessor(this.store, this.connection, this.nextRequestProcessor, this.statsRecorder, this.tokenVerifier, this.replyWithStackTraceOnError, this.tokenExpiryHandlerExecutor);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AppendProcessor.AppendProcessorBuilder(store=" + this.store + ", connection=" + this.connection + ", nextRequestProcessor=" + this.nextRequestProcessor + ", statsRecorder=" + this.statsRecorder + ", tokenVerifier=" + this.tokenVerifier + ", replyWithStackTraceOnError=" + this.replyWithStackTraceOnError + ", tokenExpiryHandlerExecutor=" + this.tokenExpiryHandlerExecutor + ")";
        }
    }
}

