/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.pravega.segmentstore.server.host.handler.ServerConnection;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionTracker {
    @VisibleForTesting
    static final int LOW_WATERMARK = 0x100000;
    private static final int DEFAULT_ALL_CONNECTIONS_MAX_OUTSTANDING_BYTES = 0x20000000;
    private static final int DEFAULT_SINGLE_CONNECTION_MAX_OUTSTANDING = 0x8000000;
    private final int allConnectionsLimit;
    private final int singleConnectionDoubleLimit;
    private final AtomicLong totalOutstanding = new AtomicLong(0L);

    public ConnectionTracker() {
        this(0x20000000, 0x8000000);
    }

    ConnectionTracker(int allConnectionsMaxOutstandingBytes, int singleConnectionMaxOutstandingBytes) {
        Preconditions.checkArgument((allConnectionsMaxOutstandingBytes >= 0x100000 ? 1 : 0) != 0, (String)"allConnectionsMaxOutstandingBytes must be a value greater than %s.", (int)0x100000);
        Preconditions.checkArgument((singleConnectionMaxOutstandingBytes >= 0x100000 ? 1 : 0) != 0, (String)"singleConnectionMaxOutstandingBytes must be a value greater than %s.", (int)0x100000);
        Preconditions.checkArgument((singleConnectionMaxOutstandingBytes <= allConnectionsMaxOutstandingBytes ? 1 : 0) != 0, (String)"singleConnectionMaxOutstandingBytes (%s) must be at most allConnectionsMaxOutstandingBytes (%s).", (int)singleConnectionMaxOutstandingBytes, (int)allConnectionsMaxOutstandingBytes);
        this.allConnectionsLimit = allConnectionsMaxOutstandingBytes;
        this.singleConnectionDoubleLimit = 2 * singleConnectionMaxOutstandingBytes;
    }

    @VisibleForTesting
    long getTotalOutstanding() {
        return this.totalOutstanding.get();
    }

    void updateOutstandingBytes(ServerConnection connection, long deltaBytes, long connectionOutstandingBytes) {
        if (this.shouldContinueReading(deltaBytes, connectionOutstandingBytes)) {
            connection.resumeReading();
        } else {
            connection.pauseReading();
        }
    }

    private boolean shouldContinueReading(long deltaBytes, long connectionOutstandingBytes) {
        assert (deltaBytes <= connectionOutstandingBytes) : "connection delta greater than connection outstanding";
        long total = this.totalOutstanding.updateAndGet(p -> Math.max(0L, p + deltaBytes));
        if (total >= (long)this.allConnectionsLimit) {
            return false;
        }
        return connectionOutstandingBytes < 0x100000L || connectionOutstandingBytes < (long)this.singleConnectionDoubleLimit - total;
    }
}

