/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.pravega.segmentstore.contracts.StreamSegmentStore;
import io.pravega.segmentstore.contracts.tables.TableStore;
import io.pravega.segmentstore.server.host.delegationtoken.DelegationTokenVerifier;
import io.pravega.segmentstore.server.host.delegationtoken.PassingTokenVerifier;
import io.pravega.segmentstore.server.host.handler.AbstractConnectionListener;
import io.pravega.segmentstore.server.host.handler.AppendProcessor;
import io.pravega.segmentstore.server.host.handler.PravegaRequestProcessor;
import io.pravega.segmentstore.server.host.handler.TrackedConnection;
import io.pravega.segmentstore.server.host.stat.SegmentStatsRecorder;
import io.pravega.segmentstore.server.host.stat.TableSegmentStatsRecorder;
import io.pravega.segmentstore.server.store.ServiceConfig;
import io.pravega.shared.health.HealthServiceManager;
import io.pravega.shared.metrics.MetricNotifier;
import io.pravega.shared.protocol.netty.AppendDecoder;
import io.pravega.shared.protocol.netty.CommandDecoder;
import io.pravega.shared.protocol.netty.CommandEncoder;
import io.pravega.shared.protocol.netty.ExceptionLoggingHandler;
import io.pravega.shared.protocol.netty.RequestProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PravegaConnectionListener
extends AbstractConnectionListener {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PravegaConnectionListener.class);
    private final StreamSegmentStore store;
    private final TableStore tableStore;
    private final SegmentStatsRecorder statsRecorder;
    private final TableSegmentStatsRecorder tableStatsRecorder;
    private final DelegationTokenVerifier tokenVerifier;
    private final ScheduledExecutorService tokenExpiryHandlerExecutor;
    private final boolean replyWithStackTraceOnError;

    @VisibleForTesting
    public PravegaConnectionListener(boolean enableTls, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, ScheduledExecutorService tokenExpiryExecutor, String[] tlsProtocolVersion) {
        this(enableTls, false, "localhost", port, streamSegmentStore, tableStore, SegmentStatsRecorder.noOp(), TableSegmentStatsRecorder.noOp(), new PassingTokenVerifier(), null, null, true, tokenExpiryExecutor, tlsProtocolVersion, null);
    }

    @VisibleForTesting
    public PravegaConnectionListener(boolean enableTls, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, ScheduledExecutorService tokenExpiryExecutor) {
        this(enableTls, port, streamSegmentStore, tableStore, tokenExpiryExecutor, ((String)ServiceConfig.TLS_PROTOCOL_VERSION.getDefaultValue()).split(","));
    }

    public PravegaConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, SegmentStatsRecorder statsRecorder, TableSegmentStatsRecorder tableStatsRecorder, DelegationTokenVerifier tokenVerifier, String certFile, String keyFile, boolean replyWithStackTraceOnError, ScheduledExecutorService executor, String[] tlsProtocolVersion, HealthServiceManager healthServiceManager) {
        super(enableTls, enableTlsReload, host, port, certFile, keyFile, tlsProtocolVersion, healthServiceManager);
        this.store = (StreamSegmentStore)Preconditions.checkNotNull((Object)streamSegmentStore, (Object)"streamSegmentStore");
        this.tableStore = (TableStore)Preconditions.checkNotNull((Object)tableStore, (Object)"tableStore");
        this.statsRecorder = (SegmentStatsRecorder)Preconditions.checkNotNull((Object)statsRecorder, (Object)"statsRecorder");
        this.tableStatsRecorder = (TableSegmentStatsRecorder)Preconditions.checkNotNull((Object)tableStatsRecorder, (Object)"tableStatsRecorder");
        this.replyWithStackTraceOnError = replyWithStackTraceOnError;
        this.tokenVerifier = tokenVerifier != null ? tokenVerifier : new PassingTokenVerifier();
        this.tokenExpiryHandlerExecutor = executor;
    }

    public PravegaConnectionListener(boolean enableTls, boolean enableTlsReload, String host, int port, StreamSegmentStore streamSegmentStore, TableStore tableStore, SegmentStatsRecorder statsRecorder, TableSegmentStatsRecorder tableStatsRecorder, DelegationTokenVerifier tokenVerifier, String certFile, String keyFile, boolean replyWithStackTraceOnError, ScheduledExecutorService executor, String[] tlsProtocolVersion) {
        this(enableTls, enableTlsReload, host, port, streamSegmentStore, tableStore, statsRecorder, tableStatsRecorder, tokenVerifier, certFile, keyFile, replyWithStackTraceOnError, executor, tlsProtocolVersion, null);
    }

    @Override
    public RequestProcessor createRequestProcessor(TrackedConnection c) {
        PravegaRequestProcessor prp = new PravegaRequestProcessor(this.store, this.tableStore, c, this.statsRecorder, this.tableStatsRecorder, this.tokenVerifier, this.replyWithStackTraceOnError);
        return new AppendProcessor(this.store, c, prp, this.statsRecorder, this.tokenVerifier, this.replyWithStackTraceOnError, this.tokenExpiryHandlerExecutor);
    }

    @Override
    public List<ChannelHandler> createEncodingStack(String connectionName) {
        ArrayList<ChannelHandler> stack = new ArrayList<ChannelHandler>();
        stack.add((ChannelHandler)new ExceptionLoggingHandler(connectionName));
        stack.add((ChannelHandler)new CommandEncoder(null, MetricNotifier.NO_OP_METRIC_NOTIFIER));
        stack.add((ChannelHandler)new LengthFieldBasedFrameDecoder(0xFFFFFF, 4, 4));
        stack.add((ChannelHandler)new CommandDecoder());
        stack.add((ChannelHandler)new AppendDecoder());
        return stack;
    }
}

