/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.segmentstore.server.host.handler.ConnectionTracker;
import io.pravega.segmentstore.server.host.handler.ServerConnection;
import io.pravega.shared.protocol.netty.WireCommand;
import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;

public class TrackedConnection
implements AutoCloseable {
    @NonNull
    private final ServerConnection connection;
    @NonNull
    private final ConnectionTracker connectionTracker;
    private final AtomicLong outstandingBytes = new AtomicLong();

    @VisibleForTesting
    public TrackedConnection(ServerConnection connection) {
        this(connection, new ConnectionTracker());
    }

    void adjustOutstandingBytes(int delta) {
        long currentOutstanding = this.outstandingBytes.updateAndGet(p -> Math.max(0L, p + (long)delta));
        this.connectionTracker.updateOutstandingBytes(this.connection, delta, currentOutstanding);
    }

    void send(WireCommand cmd) {
        this.connection.send(cmd);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public String toString() {
        return String.format("%s [%s/%s]", this.connection, this.outstandingBytes, this.connectionTracker.getTotalOutstanding());
    }

    @ConstructorProperties(value={"connection", "connectionTracker"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TrackedConnection(@NonNull ServerConnection connection, @NonNull ConnectionTracker connectionTracker) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        if (connectionTracker == null) {
            throw new NullPointerException("connectionTracker is marked non-null but is null");
        }
        this.connection = connection;
        this.connectionTracker = connectionTracker;
    }
}

