/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.handler;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@ThreadSafe
class WriterState {
    static final long NO_FAILED_EVENT_NUMBER = Long.MAX_VALUE;
    private final Object ackLock = new Object();
    @GuardedBy(value="this")
    private long lastStoredEventNumber;
    @GuardedBy(value="this")
    private long lastAckedEventNumber;
    @GuardedBy(value="this")
    private int inFlightCount = 0;
    @GuardedBy(value="this")
    private long smallestFailedEventNumber = Long.MAX_VALUE;
    @GuardedBy(value="this")
    private ArrayList<ErrorContext> errorContexts;

    WriterState(long initialEventNumber) {
        this.lastStoredEventNumber = initialEventNumber;
        this.lastAckedEventNumber = initialEventNumber;
    }

    synchronized long beginAppend(long eventNumber) {
        long previousEventNumber = this.lastStoredEventNumber;
        Preconditions.checkState((eventNumber >= previousEventNumber ? 1 : 0) != 0, (Object)"Event was already appended.");
        this.lastStoredEventNumber = eventNumber;
        ++this.inFlightCount;
        return previousEventNumber;
    }

    synchronized void conditionalAppendFailed(long eventNumber) {
        --this.inFlightCount;
        if (this.inFlightCount == 0) {
            this.lastStoredEventNumber = this.lastAckedEventNumber;
        }
        this.updateErrorContexts(eventNumber);
    }

    synchronized void appendFailed(long eventNumber, @NonNull Runnable delayedErrorHandler) {
        if (delayedErrorHandler == null) {
            throw new NullPointerException("delayedErrorHandler is marked non-null but is null");
        }
        --this.inFlightCount;
        this.smallestFailedEventNumber = Math.min(eventNumber, this.smallestFailedEventNumber);
        if (this.errorContexts == null) {
            this.errorContexts = new ArrayList();
        }
        this.updateErrorContexts(eventNumber);
        this.errorContexts.add(new ErrorContext(eventNumber, this.lastStoredEventNumber, this.inFlightCount, delayedErrorHandler));
        this.errorContexts.sort(Comparator.comparingLong(ErrorContext::getFailedEventNumber));
    }

    synchronized long appendSuccessful(long eventNumber) {
        --this.inFlightCount;
        long previousLastAcked = this.lastAckedEventNumber;
        this.lastAckedEventNumber = Math.max(previousLastAcked, eventNumber);
        this.updateErrorContexts(eventNumber);
        return previousLastAcked;
    }

    synchronized long getLowestFailedEventNumber() {
        return this.smallestFailedEventNumber;
    }

    synchronized DelayedErrorHandler fetchEligibleDelayedErrorHandler() {
        if (this.errorContexts == null) {
            return null;
        }
        ArrayList<Runnable> toRun = new ArrayList<Runnable>();
        Iterator<ErrorContext> i = this.errorContexts.iterator();
        while (i.hasNext()) {
            ErrorContext c = i.next();
            Runnable r = c.getDelayedErrorHandlerIfEligible();
            if (r == null) continue;
            toRun.add(r);
            i.remove();
        }
        return new DelayedErrorHandler(toRun, this.errorContexts.size());
    }

    @GuardedBy(value="this")
    private void updateErrorContexts(long eventNumber) {
        if (this.errorContexts != null) {
            this.errorContexts.forEach(c -> c.appendComplete(eventNumber));
        }
    }

    public synchronized String toString() {
        return String.format("Stored=%s, Acked=%s, InFlight=%s", this.lastStoredEventNumber, this.lastAckedEventNumber, this.inFlightCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getAckLock() {
        return this.ackLock;
    }

    private static class ErrorContext {
        private final long failedEventNumber;
        private final long lastStoredEventNumber;
        private int remainingInFlightCount;
        private final Runnable delayedErrorHandler;

        ErrorContext(long failedEventNumber, long lastStoredEventNumber, int remainingInFlightCount, Runnable delayedErrorHandler) {
            this.failedEventNumber = failedEventNumber;
            this.lastStoredEventNumber = lastStoredEventNumber;
            this.remainingInFlightCount = remainingInFlightCount;
            this.delayedErrorHandler = delayedErrorHandler;
        }

        void appendComplete(long eventNumber) {
            if (eventNumber < this.lastStoredEventNumber) {
                --this.remainingInFlightCount;
                assert (this.remainingInFlightCount >= 0);
            }
        }

        Runnable getDelayedErrorHandlerIfEligible() {
            if (this.remainingInFlightCount == 0) {
                return this.delayedErrorHandler;
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getFailedEventNumber() {
            return this.failedEventNumber;
        }
    }

    static class DelayedErrorHandler {
        private final List<Runnable> handlersToExecute;
        private final int handlersRemaining;

        @ConstructorProperties(value={"handlersToExecute", "handlersRemaining"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private DelayedErrorHandler(List<Runnable> handlersToExecute, int handlersRemaining) {
            this.handlersToExecute = handlersToExecute;
            this.handlersRemaining = handlersRemaining;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<Runnable> getHandlersToExecute() {
            return this.handlersToExecute;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getHandlersRemaining() {
            return this.handlersRemaining;
        }
    }
}

