/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.health;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Service;
import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import java.util.Map;
import lombok.NonNull;

public class SegmentContainerHealthContributor
extends AbstractHealthContributor {
    private final SegmentContainer segmentContainer;

    public SegmentContainerHealthContributor(@NonNull SegmentContainer segmentContainer) {
        super("SegmentContainer");
        if (segmentContainer == null) {
            throw new NullPointerException("segmentContainer is marked non-null but is null");
        }
        this.segmentContainer = segmentContainer;
    }

    public Status doHealthCheck(Health.HealthBuilder builder) {
        Status status = Status.DOWN;
        if (this.segmentContainer.state() == Service.State.NEW) {
            status = Status.NEW;
        }
        if (this.segmentContainer.state() == Service.State.STARTING) {
            status = Status.STARTING;
        }
        if (this.segmentContainer.state() == Service.State.RUNNING) {
            status = Status.UP;
        }
        builder.details((Map)ImmutableMap.of((Object)"Id", (Object)this.segmentContainer.getId(), (Object)"ActiveSegments", (Object)this.segmentContainer.getActiveSegments()));
        return status;
    }
}

