/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.health;

import io.pravega.segmentstore.server.SegmentContainer;
import io.pravega.segmentstore.server.SegmentContainerRegistry;
import io.pravega.segmentstore.server.host.health.SegmentContainerHealthContributor;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.HealthContributor;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import lombok.NonNull;

public class SegmentContainerRegistryHealthContributor
extends AbstractHealthContributor {
    private final SegmentContainerRegistry segmentContainerRegistry;

    public SegmentContainerRegistryHealthContributor(@NonNull SegmentContainerRegistry segmentContainerRegistry) {
        super("SegmentContainerRegistry");
        if (segmentContainerRegistry == null) {
            throw new NullPointerException("segmentContainerRegistry is marked non-null but is null");
        }
        this.segmentContainerRegistry = segmentContainerRegistry;
    }

    public Status doHealthCheck(Health.HealthBuilder builder) {
        boolean ready;
        for (SegmentContainer container : this.segmentContainerRegistry.getContainers()) {
            this.register(new HealthContributor[]{new SegmentContainerHealthContributor(container)});
        }
        Status status = Status.DOWN;
        boolean bl = ready = !this.segmentContainerRegistry.isClosed();
        if (ready) {
            status = Status.UP;
        }
        return status;
    }
}

