/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.health;

import com.google.common.collect.ImmutableMap;
import io.pravega.shared.health.Health;
import io.pravega.shared.health.Status;
import io.pravega.shared.health.impl.AbstractHealthContributor;
import java.util.Map;
import lombok.NonNull;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;

public class ZKHealthContributor
extends AbstractHealthContributor {
    private final CuratorFramework zk;

    public ZKHealthContributor(@NonNull CuratorFramework zk) {
        super("zookeeper");
        if (zk == null) {
            throw new NullPointerException("zk is marked non-null but is null");
        }
        this.zk = zk;
    }

    public Status doHealthCheck(Health.HealthBuilder builder) {
        boolean ready;
        boolean running;
        Status status = Status.DOWN;
        boolean bl = running = this.zk.getState() == CuratorFrameworkState.STARTED;
        if (running) {
            status = Status.NEW;
        }
        if (ready = this.zk.getZookeeperClient().isConnected()) {
            status = Status.UP;
        }
        builder.details((Map)ImmutableMap.of((Object)"zk-connection-url", (Object)this.zk.getZookeeperClient().getCurrentConnectionString()));
        return status;
    }
}

