/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.segmentstore.server.host.security;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.pravega.common.Exceptions;
import java.io.File;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TLSHelper.class);
    public static final String TLS_HANDLER_NAME = "tls";

    public static SslContext newServerSslContext(String pathToCertificateFile, String pathToServerKeyFile, String[] tlsProtocolVersion) {
        Exceptions.checkNotNullOrEmpty((String)pathToCertificateFile, (String)"pathToCertificateFile");
        Exceptions.checkNotNullOrEmpty((String)pathToServerKeyFile, (String)"pathToServerKeyFile");
        Exceptions.checkArgument((tlsProtocolVersion != null ? 1 : 0) != 0, (String)"tlsProtocolVersion", (String)"Invalid TLS Protocol Version", (Object[])new Object[0]);
        return TLSHelper.newServerSslContext(new File(pathToCertificateFile), new File(pathToServerKeyFile), tlsProtocolVersion);
    }

    public static SslContext newServerSslContext(File certificateFile, File serverKeyFile, String[] tlsProtocolVersion) {
        Preconditions.checkNotNull((Object)certificateFile);
        Preconditions.checkNotNull((Object)serverKeyFile);
        Preconditions.checkNotNull((Object)tlsProtocolVersion);
        TLSHelper.ensureExistAndAreReadable(certificateFile, serverKeyFile);
        try {
            SslContext result = SslContextBuilder.forServer((File)certificateFile, (File)serverKeyFile).protocols(tlsProtocolVersion).build();
            log.debug("Done creating a new SSL Context for the server.");
            return result;
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void ensureExistAndAreReadable(File certificateFile, File serverKeyFile) {
        Preconditions.checkArgument((boolean)certificateFile.exists(), (Object)String.format("Certificate file %s doesn't exist", certificateFile.getAbsolutePath()));
        Preconditions.checkArgument((boolean)certificateFile.canRead(), (String)"Certificate file %s can't be read", (Object)certificateFile.getAbsolutePath());
        Preconditions.checkArgument((boolean)serverKeyFile.exists(), (Object)String.format("Key file %s doesn't exist", serverKeyFile.getAbsolutePath()));
        Preconditions.checkArgument((boolean)serverKeyFile.canRead(), (Object)String.format("Key file %s can't be read", serverKeyFile.getAbsolutePath()));
    }
}

